/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.ideimpl.webbrowser.BrowserOptions;
import oracle.javatools.controls.FileField;

public final class BrowserOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private JTextField textfield_browserCommand;
    private JButton button_browse;
    private ProxySettingsPanel proxyPanel;

    public BrowserOptionsPanel() {
        this.setHelpID("f1_prefweb_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    private BrowserOptions findBrowserOptions(TraversableContext traversableContext) {
        BrowserOptions browserOptions = (BrowserOptions)traversableContext.find("WebBrowserOptions");
        return browserOptions;
    }

    public void onEntry(TraversableContext traversableContext) {
        BrowserOptions browserOptions = this.findBrowserOptions(traversableContext);
        String string = browserOptions.getBrowserCmdLine();
        this.textfield_browserCommand.setText(string);
        this.proxyPanel.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        int n;
        BrowserOptions browserOptions = this.findBrowserOptions(traversableContext);
        String string = this.textfield_browserCommand.getText();
        if (string != null && string.length() > 0 && !this.isCommandLineValid(string) && (n = JOptionPane.showConfirmDialog(this, IdeImplArb.getString(74), IdeImplArb.getString(73), 0)) != 0) {
            throw new TraversalException(null);
        }
        browserOptions.setBrowserCmdLine(string);
        this.proxyPanel.onExit(traversableContext);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.button_browse) {
            String string;
            URL uRL;
            String string2 = IdeImplArb.getString(72);
            String string3 = this.textfield_browserCommand.getText();
            URL uRL2 = string3 != null && string3.length() > 0 ? URLFactory.newFileURL(string3) : null;
            URLChooser uRLChooser = DialogUtil.newURLChooser(uRL2);
            int n = uRLChooser.showOpenDialog(this, string2);
            if (n == 0 && (uRL = uRLChooser.getSelectedURL()) != null && (string = URLFileSystem.getPlatformPathName(uRL)) != null) {
                this.textfield_browserCommand.setText(string);
            }
        }
    }

    private void initializeComponent() {
        String string = IdeImplArb.getString(70);
        JLabel jLabel = new JLabel();
        this.textfield_browserCommand = new FileField();
        ResourceUtils.resLabel(jLabel, this.textfield_browserCommand, string);
        String string2 = IdeImplArb.getString(71);
        this.button_browse = new JButton();
        ResourceUtils.resButton(this.button_browse, string2);
        this.button_browse.addActionListener(this);
        this.proxyPanel = new ProxySettingsPanel();
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(2, 5, 2, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets2, 0, 0);
        jPanel.add((Component)this.textfield_browserCommand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.button_browse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(Box.createVerticalStrut(15), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)this.proxyPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, insets, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
        String string3 = System.getProperty("oracle.macosx.disableWebBrowser");
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            jLabel.setVisible(false);
            this.textfield_browserCommand.setVisible(false);
            this.button_browse.setVisible(false);
        }
    }

    private boolean isCommandLineValid(String string) {
        if (string != null && string.length() > 0) {
            File file = new File(string);
            if (file.exists()) {
                return true;
            }
            int n = string.lastIndexOf(32);
            if (n == -1) {
                return false;
            }
            return this.isCommandLineValid(string.substring(0, n));
        }
        return false;
    }
}

