/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.OpenDocumentException;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.DefaultPrintWriter;
import oracle.ide.util.ExecUtil;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.webbrowser.BrowserOptions;
import oracle.javatools.util.EnvironmentVariables;

public final class BrowserRunner
extends oracle.ide.webbrowser.BrowserRunner {
    private static String osName = System.getProperty("os.name", "Windows").toLowerCase();
    private static final String OLD_DEFAULT_BROWSER_KEY = "Software\\Classes\\htmlfile\\shell\\open\\command";
    private static final String DEFAULT_BROWSER_KEY = "Software\\Classes\\http\\shell\\open\\command";
    private static String unixBrowser = System.getProperty("UNIX_WEB_BROWSER");
    private static final Object UNIX_BROWSER_LOCK = new Object();

    public void runBrowserOnURL(URL uRL, File file, PrintWriter printWriter) {
        try {
            this.runBrowserOnURLImpl(uRL, file, printWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void runBrowserOnURLV2(URL uRL, File file, PrintWriter printWriter) throws Exception {
        this.runBrowserOnURLImpl(uRL, file, printWriter);
    }

    static boolean isPlatformWindows() {
        return File.separatorChar == '\\';
    }

    static boolean isPlatformWindowsMe() {
        return osName.startsWith("windows me");
    }

    static boolean isPlatformMac() {
        return osName.startsWith("mac") || osName.startsWith("darwin");
    }

    private void runBrowserOnURLImpl(URL uRL, File file, PrintWriter printWriter) throws Exception {
        IdeSettings ideSettings = Ide.getSettings();
        BrowserOptions browserOptions = (BrowserOptions)ideSettings.getData("WebBrowserOptions");
        String string = browserOptions != null ? browserOptions.getBrowserCmdLine(uRL) : null;
        BrowserRunner.runBrowser(string, uRL, file, printWriter);
    }

    private static void runBrowser(String string, URL uRL, File file, PrintWriter printWriter) throws Exception {
        String string2 = BrowserRunner.getPlatformTargetURLString(uRL);
        if (ModelUtil.hasLength((String)string)) {
            BrowserRunner.runBrowserCommand(string, string2, printWriter);
        } else if (BrowserRunner.isPlatformWindows()) {
            String string3 = BrowserRunner.getWindowsDefaultBrowserPath();
            if (string3 != null) {
                int n = string3.indexOf("%1");
                if (n != -1) {
                    string3 = string3.substring(0, n) + string2 + string3.substring(n + 2);
                    string2 = "";
                }
                BrowserRunner.runBrowserCommand(string3, string2, printWriter);
            } else {
                BrowserRunner.runBrowserOnWindows(string2, file, printWriter);
            }
        } else if (BrowserRunner.isPlatformMac()) {
            BrowserRunner.runBrowserOnMac(string2, printWriter);
        } else {
            BrowserRunner.runBrowserOnUnix(string2, printWriter);
        }
    }

    private static String getKeyValue(String string) {
        block13: {
            RegistryKey registryKey = null;
            try {
                try {
                    registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(string, 131097L);
                    if (registryKey == null) break block13;
                    String string2 = registryKey.getStringValue(null);
                    if (registryKey != null) {
                        try {
                            registryKey.close();
                        }
                        catch (RegistryException registryException) {
                            // empty catch block
                        }
                    }
                    return string2;
                }
                catch (Exception exception) {}
            }
            finally {
                if (registryKey != null) {
                    try {
                        registryKey.close();
                    }
                    catch (RegistryException registryException) {}
                }
            }
        }
        return null;
    }

    private static String getWindowsDefaultBrowserPath() {
        String string = BrowserRunner.getKeyValue(DEFAULT_BROWSER_KEY);
        if (string == null) {
            string = BrowserRunner.getKeyValue(OLD_DEFAULT_BROWSER_KEY);
        }
        return string;
    }

    private static String getPlatformTargetURLString(URL uRL) {
        String string = BrowserRunner.isPlatformWindows() ? ("file".equalsIgnoreCase(uRL.getProtocol()) ? URLFileSystem.toDisplayString(uRL) : URLFileSystem.toEncodedString(uRL, "UTF-8")) : (BrowserRunner.isPlatformMac() ? URLFileSystem.toDisplayString(uRL) : URLFileSystem.toEncodedString(uRL, "UTF-8"));
        return string;
    }

    private static void runBrowserCommand(String string, String string2, PrintWriter printWriter) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        String[] stringArray = IdeUtil.convertStringToStringArray(string, true, true);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(stringArray[n2]);
            ++n2;
        }
        BrowserRunner.runBrowserCommandImpl(arrayList, string2, printWriter);
    }

    private static void runBrowserOnWindows(String string, File file, PrintWriter printWriter) throws Exception {
        String string2 = file != null ? file.getAbsolutePath() : string;
        try {
            NativeHandler.openDocument(string2);
            return;
        }
        catch (OpenDocumentException openDocumentException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ArrayList<String> arrayList = new ArrayList<String>(5);
        if (BrowserRunner.isPlatformWindowsMe()) {
            String string3 = Ide.getProperty("WindowMe.BrowserPath");
            if (string3 == null) {
                string3 = "\"C:\\Program Files\\Internet explorer\\iexplore.exe\"";
            }
            System.out.println("Windows ME Browser Path used is: " + string3);
            arrayList.add(string3);
            if (file != null) {
                string2 = "\"" + file.getAbsolutePath() + "\"";
            }
        } else {
            arrayList.add("cmd.exe");
            arrayList.add("/c");
            arrayList.add("start");
            arrayList.add("\"Oracle9i JDeveloper\"");
            if (file != null) {
                string2 = "\"" + file.getAbsolutePath() + "\"";
            }
        }
        BrowserRunner.runBrowserCommandImpl(arrayList, string2, printWriter);
    }

    private static void runBrowserOnMac(String string, PrintWriter printWriter) {
        try {
            Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
            Method method = clazz.getMethod("openURL", String.class);
            Object[] objectArray = new Object[]{string};
            method.invoke(null, objectArray);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runBrowserOnUnix(String string, PrintWriter printWriter) throws Exception {
        if (unixBrowser == null) {
            Object object = UNIX_BROWSER_LOCK;
            synchronized (object) {
                if (unixBrowser == null) {
                    BrowserRunner.findAndRunBrowserOnUnix(string, printWriter);
                    return;
                }
            }
        }
        BrowserRunner.runBrowserOnUnix(unixBrowser, string, printWriter);
    }

    private static void findAndRunBrowserOnUnix(String string, PrintWriter printWriter) throws Exception {
        String string2 = EnvironmentVariables.getVariable((String)"BROWSER");
        if (string2 == null) {
            string2 = "netscape:mozilla:firefox:opera";
        }
        String[] stringArray = string2.split(":");
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            try {
                BrowserRunner.runBrowserOnUnix(string3, string, printWriter);
                unixBrowser = string3;
                break;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        if (unixBrowser == null) {
            throw new IOException("A default web browser could not be found.");
        }
    }

    private static void runBrowserOnUnix(String string, String string2, PrintWriter printWriter) throws Exception {
        String string3 = "_jdevmarker_";
        string = string.replaceAll("%%", "_jdevmarker_");
        string = string.replaceAll("%c", ":");
        Matcher matcher = Pattern.compile("%s").matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            string = matcher.replaceAll(string2);
        }
        string = string.replaceAll("_jdevmarker_", "%");
        if (bl) {
            Process process = Runtime.getRuntime().exec(string);
            BrowserRunner.handleOutput(process, printWriter);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(5);
            arrayList.add(string);
            BrowserRunner.runBrowserCommandImpl(arrayList, string2, printWriter);
        }
    }

    private static void runBrowserCommandImpl(ArrayList arrayList, String string, PrintWriter printWriter) throws Exception {
        arrayList.add(string);
        String[] stringArray = BrowserRunner.toCommandArray(arrayList);
        Process process = Runtime.getRuntime().exec(stringArray);
        BrowserRunner.handleOutput(process, printWriter);
    }

    private static void handleOutput(Process process, PrintWriter printWriter) throws Exception {
        ProcessOutput processOutput = new ProcessOutput(process.getErrorStream(), printWriter);
        new Thread((Runnable)processOutput, "BrowserProcessErr").start();
        ProcessOutput processOutput2 = new ProcessOutput(process.getInputStream(), printWriter);
        new Thread((Runnable)processOutput2, "BrowserProcessOut").start();
    }

    private static String[] toCommandArray(ArrayList arrayList) {
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return ExecUtil.cleanUpCommand(stringArray);
    }

    private static final class ProcessOutput
    implements Runnable {
        private BufferedReader _in;
        private PrintWriter _printWriter;

        ProcessOutput(InputStream inputStream, PrintWriter printWriter) throws IOException {
            this._in = new BufferedReader(new InputStreamReader(inputStream));
            this._printWriter = printWriter != null ? printWriter : new DefaultPrintWriter();
        }

        public void run() {
            try {
                try {
                    String string;
                    while ((string = this._in.readLine()) != null) {
                        this._printWriter.println(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                if (this._in != null) {
                    try {
                        this._in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

