/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Window;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.SwingUtilities;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.AuthenticationPrompt;

public class IdeAuthenticator
extends Authenticator {
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication passwordAuthentication;
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && (passwordAuthentication = this.getProxyAuthentication()) != null) {
            return passwordAuthentication;
        }
        AuthenticationPromptRunner authenticationPromptRunner = new AuthenticationPromptRunner(null);
        if (SwingUtilities.isEventDispatchThread()) {
            authenticationPromptRunner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(authenticationPromptRunner);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return authenticationPromptRunner.getPasswordAuthentication();
    }

    private PasswordAuthentication getProxyAuthentication() {
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        if (proxyOptions.getUseProxyAuthentication().booleanValue()) {
            String string = this.getRequestingHost();
            String string2 = proxyOptions.getProxyHost();
            int n = this.getRequestingPort();
            int n2 = Integer.parseInt(proxyOptions.getProxyPort());
            if (string.equalsIgnoreCase(string2) && n == n2) {
                return new PasswordAuthentication(proxyOptions.getProxyUserName(), proxyOptions.getProxyPassword().toCharArray());
            }
        }
        return null;
    }

    static String mav$getRequestingHost(IdeAuthenticator ideAuthenticator) {
        return ideAuthenticator.getRequestingHost();
    }

    static int mav$getRequestingPort(IdeAuthenticator ideAuthenticator) {
        return ideAuthenticator.getRequestingPort();
    }

    static String mav$getRequestingProtocol(IdeAuthenticator ideAuthenticator) {
        return ideAuthenticator.getRequestingProtocol();
    }

    static String mav$getRequestingPrompt(IdeAuthenticator ideAuthenticator) {
        return ideAuthenticator.getRequestingPrompt();
    }

    private final class AuthenticationPromptRunner
    implements Runnable {
        private PasswordAuthentication authentication;

        public void run() {
            AuthenticationPrompt authenticationPrompt = new AuthenticationPrompt(IdeAuthenticator.mav$getRequestingHost(IdeAuthenticator.this), IdeAuthenticator.mav$getRequestingPort(IdeAuthenticator.this), IdeAuthenticator.mav$getRequestingProtocol(IdeAuthenticator.this), IdeAuthenticator.mav$getRequestingPrompt(IdeAuthenticator.this));
            if (authenticationPrompt.runDialog(this.getParentWindow())) {
                this.authentication = new PasswordAuthentication(authenticationPrompt.getUserName(), authenticationPrompt.getPassword());
            }
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }

        private Window getParentWindow() {
            Window window = IdeUtil.findActiveModalWindow();
            return window != null ? window : IdeUtil.getMainWindow();
        }

        private AuthenticationPromptRunner() {
        }

        AuthenticationPromptRunner(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

