/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.config.ClientSetting;
import oracle.ide.panels.Navigable;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ideimpl.resource.IdeImplArb;

public class ProxyAddin
implements ChangeListener,
Addin {
    private static final String PROPERTY_PROXY_HOST = "http.proxyHost";
    private static final String PROPERTY_PROXY_PORT = "http.proxyPort";
    private static final String PROPERTY_PROXY_USERNAME = "http.proxyUserName";
    private static final String PROPERTY_PROXY_USERNAME2 = "http.proxyUsername";
    private static final String PROPERTY_PROXY_PASSWORD = "http.proxyPassword";
    private static final String PROPERTY_PROXY_HOST_SECURE = "https.proxyHost";
    private static final String PROPERTY_PROXY_PORT_SECURE = "https.proxyPort";
    private static final String PROPERTY_PROXY_USERNAME_SECURE = "https.proxyUserName";
    private static final String PROPERTY_PROXY_USERNAME_SECURE2 = "https.proxyUsername";
    private static final String PROPERTY_PROXY_PASSWORD_SECURE = "https.proxyPassword";
    private static final String PROPERTY_PROXY_EXCEPTIONS = "http.nonProxyHosts";
    private static final String PROPERTY_PROXY_EXCEPTIONS_SECURE = "https.nonProxyHosts";
    private static final String DEFAULT_PROXY_PORT = "80";
    private static Navigable NAV;

    public static Navigable getNavigable() {
        if (NAV == null) {
            NAV = new Navigable(IdeImplArb.getString(80), ProxySettingsPanel.class);
        }
        return NAV;
    }

    public void initialize() {
        ClientSetting clientSetting = ClientSetting.findOrCreate("oracle.ide");
        ProxyOptions proxyOptions = (ProxyOptions)clientSetting.getData("proxy-options");
        if (proxyOptions == null) {
            proxyOptions = this.getInitialProxyOptions();
            if (proxyOptions.getUseProxy().booleanValue()) {
                String string = proxyOptions.getProxyExceptions();
                if (string.trim().length() == 0) {
                    string = "localhost|127.0.0.1";
                } else {
                    String string2 = string.toLowerCase();
                    if (string2.indexOf("localhost") == -1 && string2.indexOf("127.0.0.1") == -1) {
                        string = string + "|localhost|127.0.0.1";
                    }
                }
                proxyOptions.setProxyExceptions(string);
            }
            clientSetting.putData("proxy-options", proxyOptions);
        }
        proxyOptions.addChangeListener(this);
        proxyOptions.fireChangeEvent();
        ClientSetting.registerUI(ProxyAddin.getNavigable());
    }

    private ProxyOptions getInitialProxyOptions() {
        ProxyOptions proxyOptions = new ProxyOptions();
        String string = System.getProperty(PROPERTY_PROXY_HOST);
        String string2 = System.getProperty(PROPERTY_PROXY_PORT);
        String string3 = System.getProperty(PROPERTY_PROXY_EXCEPTIONS);
        if (string != null) {
            if (string2 == null || string2.length() == 0) {
                string2 = DEFAULT_PROXY_PORT;
            }
            if (string3 == null) {
                string3 = "";
            }
            proxyOptions.setUseProxy(Boolean.TRUE);
            proxyOptions.setProxyHost(string);
            proxyOptions.setProxyPort(string2);
            proxyOptions.setProxyExceptions(string3);
        } else {
            proxyOptions.setUseProxy(Boolean.FALSE);
        }
        return proxyOptions;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ProxyOptions proxyOptions = (ProxyOptions)changeEvent.getSource();
        this.updateSystemProperties(proxyOptions);
    }

    private void updateSystemProperties(ProxyOptions proxyOptions) {
        block9: {
            Boolean bl = proxyOptions.getUseProxy();
            boolean bl2 = bl != null ? bl : false;
            String string = proxyOptions.getProxyHost();
            String string2 = proxyOptions.getProxyExceptions();
            Boolean bl3 = proxyOptions.getUseProxyAuthentication();
            boolean bl4 = bl3 != null ? bl3 : false;
            String string3 = proxyOptions.getProxyUserName();
            String string4 = proxyOptions.getProxyPassword();
            if (bl2 && string != null && string.length() > 0) {
                String string5 = proxyOptions.getProxyPort();
                if (string5 == null || string5.length() == 0) {
                    string5 = DEFAULT_PROXY_PORT;
                }
                if (string2 == null) {
                    string2 = "";
                }
                try {
                    System.setProperty(PROPERTY_PROXY_HOST, string);
                    System.setProperty(PROPERTY_PROXY_PORT, string5);
                    System.setProperty(PROPERTY_PROXY_EXCEPTIONS, string2);
                    System.setProperty(PROPERTY_PROXY_HOST_SECURE, string);
                    System.setProperty(PROPERTY_PROXY_PORT_SECURE, string5);
                    System.setProperty(PROPERTY_PROXY_EXCEPTIONS_SECURE, string2);
                    if (bl4) {
                        System.setProperty(PROPERTY_PROXY_USERNAME, string3);
                        System.setProperty(PROPERTY_PROXY_USERNAME2, string3);
                        System.setProperty(PROPERTY_PROXY_PASSWORD, string4);
                        System.setProperty(PROPERTY_PROXY_USERNAME_SECURE, string3);
                        System.setProperty(PROPERTY_PROXY_USERNAME_SECURE2, string3);
                        System.setProperty(PROPERTY_PROXY_PASSWORD_SECURE, string4);
                        break block9;
                    }
                    Properties properties = System.getProperties();
                    properties.remove(PROPERTY_PROXY_USERNAME);
                    properties.remove(PROPERTY_PROXY_USERNAME2);
                    properties.remove(PROPERTY_PROXY_PASSWORD);
                    properties.remove(PROPERTY_PROXY_USERNAME_SECURE);
                    properties.remove(PROPERTY_PROXY_USERNAME_SECURE2);
                    properties.remove(PROPERTY_PROXY_PASSWORD_SECURE);
                }
                catch (SecurityException securityException) {}
            } else {
                try {
                    Properties properties = System.getProperties();
                    properties.remove(PROPERTY_PROXY_HOST);
                    properties.remove(PROPERTY_PROXY_PORT);
                    properties.remove(PROPERTY_PROXY_EXCEPTIONS);
                    properties.remove(PROPERTY_PROXY_HOST_SECURE);
                    properties.remove(PROPERTY_PROXY_PORT_SECURE);
                    properties.remove(PROPERTY_PROXY_USERNAME);
                    properties.remove(PROPERTY_PROXY_USERNAME2);
                    properties.remove(PROPERTY_PROXY_PASSWORD);
                    properties.remove(PROPERTY_PROXY_USERNAME_SECURE);
                    properties.remove(PROPERTY_PROXY_USERNAME_SECURE2);
                    properties.remove(PROPERTY_PROXY_PASSWORD_SECURE);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }
}

