/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.CheckMasterListRunnable;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.ideimpl.webupdate.controls.Balloon;
import oracle.ideimpl.webupdate.controls.BalloonLayout;
import oracle.ideimpl.webupdate.controls.BalloonManager;
import oracle.javatools.data.HashStructure;

public final class AutomaticCheckForUpdates {
    public static final String CONTEXT_KEY_MASTER_LIST = "autoCfuMasterList";
    private static final int HIDE_ACTION_ID = Ide.findOrCreateCmdID("AutoUpdateHide");
    private static final int PREFS_ACTION_ID = Ide.findOrCreateCmdID("AutoUpdatePrefs");
    private Collection _masterList;
    private JComponent _notificationIcon;
    private JCheckBox _skipCheckbox;
    private Controller _controller;
    private ContextMenu _contextMenu;
    private MouseListener _mouseListener;

    void $init$() {
        this._masterList = null;
        this._notificationIcon = null;
        this._skipCheckbox = null;
        this._controller = null;
        this._contextMenu = null;
        this._mouseListener = null;
    }

    AutomaticCheckForUpdates() {
        this.$init$();
    }

    public void check() {
        if (Boolean.valueOf(System.getProperty("ide.cfu.autoskip")).booleanValue()) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("ide.cfu.autoforce")).booleanValue()) {
            this.installBalloon();
        }
        6 var1_1 = new 6();
        Thread thread = new Thread((Runnable)var1_1, "Automatic check for updates");
        thread.setPriority(1);
        thread.start();
    }

    private void checkMasterList() {
        5 var1_1 = new 5(UpdateManager.getInstance().getMasterServerURL());
        var1_1.setAutomaticUpdateMode(true);
        var1_1.run();
    }

    private void checkForUpdates(List list) {
        this._masterList = list;
        4 var2_2 = new 4(list);
        var2_2.setAutomaticUpdatesMode(true);
        var2_2.run();
    }

    private void installBalloon() {
        Balloon balloon = new Balloon();
        JLabel jLabel = new JLabel();
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setIcon(UpdateArb.getIcon(122));
        jLabel.setText("Updates are available");
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setPreferredColumns(40);
        multiLineLabel.setText("New features are available for download. Click here to review and install available updates.");
        balloon.add((Component)jLabel, BalloonLayout.HEADER);
        balloon.add((Component)multiLineLabel, BalloonLayout.TEXT);
        balloon.add((Component)balloon.createCloseButton(), BalloonLayout.CLOSE_BUTTON);
        JCheckBox jCheckBox = new JCheckBox("Skip automatic check for updates");
        jCheckBox.setOpaque(false);
        balloon.add((Component)jCheckBox, BalloonLayout.FOOTER);
        this._skipCheckbox = jCheckBox;
        3 var5_5 = new 3();
        balloon.addActionListener(var5_5);
        balloon.addComponentListener(new 2(this, balloon, var5_5, jCheckBox));
        this.installNotificationIcon();
        BalloonManager.showBalloon(balloon, this._notificationIcon, 25000);
    }

    private void installNotificationIcon() {
        if (this._notificationIcon == null) {
            JLabel jLabel = new JLabel();
            jLabel.setIcon(UpdateArb.getIcon(122));
            Ide.getStatusBar().getToolbar().add((Component)jLabel, 0);
            Ide.getStatusBar().getToolbar().revalidate();
            this._mouseListener = new 1();
            jLabel.addMouseListener(this._mouseListener);
            this._notificationIcon = jLabel;
        }
    }

    public void uninstallNotificationIcon() {
        if (this._notificationIcon != null) {
            Ide.getStatusBar().getToolbar().remove(this._notificationIcon);
            Ide.getStatusBar().getToolbar().invalidate();
            this._notificationIcon.removeMouseListener(this._mouseListener);
            this._notificationIcon = null;
            UpdateManager.getInstance().clearAutomaticCheckForUpdates();
            this.unregisterActions();
            this._contextMenu = null;
        }
    }

    public void updateSkipCheckbox() {
        if (this._skipCheckbox != null) {
            boolean bl = WebUpdateAddin.getPreferences().getBoolean("checkOnStartup");
            this._skipCheckbox.setSelected(bl ^ true);
        }
    }

    private ContextMenu getOrCreateContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this.registerActions();
        }
        return this._contextMenu;
    }

    private void registerActions() {
        this._controller = new MyController(null);
        IdeAction ideAction = IdeAction.find(HIDE_ACTION_ID);
        if (ideAction == null) {
            ideAction = IdeAction.get(HIDE_ACTION_ID, null, "Hide");
        }
        ideAction.addController(this._controller);
        IdeAction ideAction2 = IdeAction.find(PREFS_ACTION_ID);
        if (ideAction2 == null) {
            ideAction2 = IdeAction.get(PREFS_ACTION_ID, null, "Preferences...");
        }
        ideAction2.addController(this._controller);
    }

    private void unregisterActions() {
        IdeAction ideAction;
        IdeAction ideAction2 = IdeAction.find(HIDE_ACTION_ID);
        if (ideAction2 != null) {
            ideAction2.removeController(this._controller);
        }
        if ((ideAction = IdeAction.find(PREFS_ACTION_ID)) != null) {
            ideAction.removeController(this._controller);
        }
        this._controller = null;
    }

    static void mav$checkMasterList(AutomaticCheckForUpdates automaticCheckForUpdates) {
        automaticCheckForUpdates.checkMasterList();
    }

    static void mav$checkForUpdates(AutomaticCheckForUpdates automaticCheckForUpdates, List list) {
        automaticCheckForUpdates.checkForUpdates(list);
    }

    static void wa$_masterList(AutomaticCheckForUpdates automaticCheckForUpdates, Collection collection) {
        automaticCheckForUpdates._masterList = collection;
    }

    static void mav$installBalloon(AutomaticCheckForUpdates automaticCheckForUpdates) {
        automaticCheckForUpdates.installBalloon();
    }

    static Collection ra$_masterList(AutomaticCheckForUpdates automaticCheckForUpdates) {
        return automaticCheckForUpdates._masterList;
    }

    static void wa$_skipCheckbox(AutomaticCheckForUpdates automaticCheckForUpdates, JCheckBox jCheckBox) {
        automaticCheckForUpdates._skipCheckbox = jCheckBox;
    }

    static ContextMenu mav$getOrCreateContextMenu(AutomaticCheckForUpdates automaticCheckForUpdates) {
        return automaticCheckForUpdates.getOrCreateContextMenu();
    }

    static int ra$HIDE_ACTION_ID() {
        return HIDE_ACTION_ID;
    }

    static int ra$PREFS_ACTION_ID() {
        return PREFS_ACTION_ID;
    }

    public final class 6
    implements Runnable {
        public void run() {
            HashStructure hashStructure = WebUpdateAddin.getPreferences();
            if (hashStructure.getBoolean("checkOnStartup", true)) {
                AutomaticCheckForUpdates.mav$checkMasterList(AutomaticCheckForUpdates.this);
            }
        }
    }

    public final class 5
    extends CheckMasterListRunnable {
        protected void failed(Throwable throwable) {
            WebUpdateAddin.getPreferences().putString("lastErrorType", "generic");
            WebUpdateAddin.getPreferences().putString("lastError", throwable.getMessage());
        }

        protected void finished(List list) {
            ArrayList<UpdateCenter> arrayList = new ArrayList<UpdateCenter>(list);
            UpdateHook updateHook = (UpdateHook)ExtensionRegistry.getExtensionRegistry().getHook(UpdateHook.ELEMENT);
            arrayList.addAll(updateHook.getUpdateCenters());
            for (UpdateCenter updateCenter : arrayList) {
                updateCenter.setEnabled(true);
            }
            AutomaticCheckForUpdates.mav$checkForUpdates(AutomaticCheckForUpdates.this, list);
        }

        public 5(String string) {
            super(string);
        }
    }

    public final class 4
    extends CheckUpdatesRunnable {
        protected void updateCenterError(UpdateCenter updateCenter, Throwable throwable) {
            WebUpdateAddin.getPreferences().putString("lastErrorType", "generic");
            WebUpdateAddin.getPreferences().putString("lastError", throwable.getMessage());
        }

        protected void finished(Collection collection) {
            WebUpdateAddin.getPreferences().putString("lastErrorType", "none");
            boolean bl = false;
            HashStructure hashStructure = WebUpdateAddin.getPreferences().getHashStructure("previousUpdates");
            if (hashStructure == null) {
                hashStructure = HashStructure.newInstance();
            }
            HashStructure hashStructure2 = HashStructure.newInstance();
            for (UpdateInfo updateInfo : collection) {
                String string = updateInfo.getID();
                String string2 = hashStructure.getString(string);
                hashStructure2.putString(string, updateInfo.getVersion().toCanonicalString());
                if (string2 == null) {
                    bl = true;
                    continue;
                }
                Version version = new Version(string2);
                if (updateInfo.getVersion().compareTo((Object)version) <= 0) continue;
                bl = true;
            }
            if (bl) {
                EventQueue.invokeLater(new 1());
            } else {
                AutomaticCheckForUpdates.wa$_masterList(AutomaticCheckForUpdates.this, null);
                UpdateManager.getInstance().clearAutomaticCheckForUpdates();
            }
            WebUpdateAddin.getPreferences().putHashStructure("previousUpdates", hashStructure2);
        }

        protected void stopped() {
        }

        public 4(List list) {
            super(list);
        }

        public final class 1
        implements Runnable {
            public void run() {
                AutomaticCheckForUpdates.mav$installBalloon(AutomaticCheckForUpdates.this);
            }
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            IdeAction ideAction = IdeAction.find(WebUpdateAddin.CFU_ACTION_ID);
            Context context = Context.newIdeContext();
            context.setProperty(AutomaticCheckForUpdates.CONTEXT_KEY_MASTER_LIST, AutomaticCheckForUpdates.ra$_masterList(AutomaticCheckForUpdates.this));
            try {
                ideAction.performAction(context);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public final class 2
    extends ComponentAdapter {
        private final /* synthetic */ Balloon v$b;
        private final /* synthetic */ ActionListener v$al;
        private final /* synthetic */ JCheckBox v$cbSkipNextTime;
        final /* synthetic */ AutomaticCheckForUpdates this$0;

        public void componentHidden(ComponentEvent componentEvent) {
            componentEvent.getComponent().removeComponentListener(this);
            this.v$b.removeActionListener(this.v$al);
            WebUpdateAddin.getPreferences().putBoolean("checkOnStartup", this.v$cbSkipNextTime.isSelected() ^ true);
            if (this.v$cbSkipNextTime.isSelected()) {
                this.this$0.uninstallNotificationIcon();
            }
            AutomaticCheckForUpdates.wa$_skipCheckbox(this.this$0, null);
        }

        public 2(AutomaticCheckForUpdates automaticCheckForUpdates, Balloon balloon, ActionListener actionListener, JCheckBox jCheckBox) {
            this.v$cbSkipNextTime = jCheckBox;
            this.v$al = actionListener;
            this.v$b = balloon;
            this.this$0 = automaticCheckForUpdates;
        }
    }

    public final class oracle.ideimpl.webupdate.AutomaticCheckForUpdates$1
    extends MouseAdapter {
        private Context createContext(MouseEvent mouseEvent) {
            Context context = Context.newIdeContext(Ide.getMainWindow().getIdeMainWindowView(), mouseEvent);
            context.setProperty(AutomaticCheckForUpdates.CONTEXT_KEY_MASTER_LIST, AutomaticCheckForUpdates.ra$_masterList(AutomaticCheckForUpdates.this));
            return context;
        }

        private ContextMenu createContextMenu() {
            ContextMenu contextMenu = AutomaticCheckForUpdates.mav$getOrCreateContextMenu(AutomaticCheckForUpdates.this);
            1 var2_2 = new 1();
            contextMenu.addContextMenuListener(var2_2);
            return contextMenu;
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            this.createContextMenu().show(this.createContext(mouseEvent));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                this.createContextMenu().fireDefaultAction(this.createContext(mouseEvent));
            }
        }

        public final class 1
        implements ContextMenuListener {
            public void menuWillShow(ContextMenu contextMenu) {
                float f = 0.0f;
                contextMenu.add((Component)contextMenu.createMenuItem(IdeAction.find(WebUpdateAddin.CFU_ACTION_ID)), f);
                contextMenu.add((Component)contextMenu.createMenuItem(IdeAction.find(AutomaticCheckForUpdates.ra$HIDE_ACTION_ID())), f += 0.1f);
                contextMenu.add((Component)contextMenu.createMenuItem(IdeAction.find(AutomaticCheckForUpdates.ra$PREFS_ACTION_ID())), f);
            }

            public void menuWillHide(ContextMenu contextMenu) {
                contextMenu.removeContextMenuListener(this);
            }

            public boolean handleDefaultAction(Context context) {
                try {
                    IdeAction.find(WebUpdateAddin.CFU_ACTION_ID).performAction(context);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
        }
    }

    private final class MyController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == AutomaticCheckForUpdates.ra$HIDE_ACTION_ID()) {
                AutomaticCheckForUpdates.this.uninstallNotificationIcon();
                return true;
            }
            if (ideAction.getCommandId() == AutomaticCheckForUpdates.ra$PREFS_ACTION_ID()) {
                Ide.getSettings().showDialog((Frame)((Object)Ide.getMainWindow()), new String[]{"Extensions"});
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return ideAction.getCommandId() == AutomaticCheckForUpdates.ra$HIDE_ACTION_ID() || ideAction.getCommandId() == AutomaticCheckForUpdates.ra$PREFS_ACTION_ID();
        }

        private MyController() {
        }

        MyController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

