/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oracle.ideimpl.webupdate.ProgressMonitor;

public class BasicProgressMonitor
extends JPanel
implements ProgressMonitor {
    private final JLabel _message;
    private final JProgressBar _progress;
    private final JLabel _note;
    private final JButton _stopButton;
    private int _totalSteps;
    private int _jumpPerStep;
    private int _stepsElapsed;
    private boolean _canceled;
    private static final int MAX_PROGRESS = 100000;

    void $init$() {
        this._message = new JLabel();
        this._progress = new JProgressBar();
        this._note = new JLabel();
        this._stopButton = new JButton("Stop");
        this._stepsElapsed = 0;
    }

    public BasicProgressMonitor() {
        this.$init$();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._message, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this._progress, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._stopButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._note, gridBagConstraints);
        this._stopButton.setEnabled(false);
        this._progress.setMaximum(100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int n) {
        BasicProgressMonitor basicProgressMonitor = this;
        synchronized (basicProgressMonitor) {
            this._totalSteps = n;
            this._jumpPerStep = 100000 / n;
            System.err.println(n + " steps at " + this._jumpPerStep + " ticks per step");
        }
        EventQueue.invokeLater(new 6());
    }

    public void finished() {
        EventQueue.invokeLater(new 5());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanced(int n) {
        BasicProgressMonitor basicProgressMonitor = this;
        synchronized (basicProgressMonitor) {
            this._stepsElapsed += n;
        }
        EventQueue.invokeLater(new 4());
    }

    public synchronized boolean isCanceled() {
        return this._canceled;
    }

    public synchronized void setCanceled(boolean bl) {
        this._canceled = bl;
    }

    public void setMessage(String string) {
        EventQueue.invokeLater(new 3(this, string));
    }

    public void setDetailMessage(String string) {
        EventQueue.invokeLater(new 2(this, string));
    }

    public ProgressMonitor createSubMonitor(int n) {
        return new SubMonitor(this, n * this._jumpPerStep, this._stepsElapsed * this._jumpPerStep);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        BasicProgressMonitor basicProgressMonitor = new BasicProgressMonitor();
        jFrame.setContentPane(basicProgressMonitor);
        basicProgressMonitor.setMessage("Test Message");
        basicProgressMonitor.setDetailMessage("Test Note");
        1 var3_3 = new 1(basicProgressMonitor);
        var3_3.start();
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static JButton ra$_stopButton(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._stopButton;
    }

    static JProgressBar ra$_progress(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._progress;
    }

    static int ra$_stepsElapsed(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._stepsElapsed;
    }

    static int ra$_jumpPerStep(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._jumpPerStep;
    }

    static JLabel ra$_message(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._message;
    }

    static JLabel ra$_note(BasicProgressMonitor basicProgressMonitor) {
        return basicProgressMonitor._note;
    }

    public final class 6
    implements Runnable {
        public void run() {
            BasicProgressMonitor.ra$_stopButton(BasicProgressMonitor.this).setEnabled(true);
            BasicProgressMonitor.ra$_progress(BasicProgressMonitor.this).setValue(0);
        }
    }

    public final class 5
    implements Runnable {
        public void run() {
            BasicProgressMonitor.ra$_stopButton(BasicProgressMonitor.this).setEnabled(false);
            BasicProgressMonitor.ra$_progress(BasicProgressMonitor.this).setValue(100000);
        }
    }

    public final class 4
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BasicProgressMonitor basicProgressMonitor = BasicProgressMonitor.this;
            synchronized (basicProgressMonitor) {
                BasicProgressMonitor.ra$_progress(BasicProgressMonitor.this).setValue(BasicProgressMonitor.ra$_stepsElapsed(BasicProgressMonitor.this) * BasicProgressMonitor.ra$_jumpPerStep(BasicProgressMonitor.this));
            }
        }
    }

    public final class 3
    implements Runnable {
        private final /* synthetic */ String v$message;
        final /* synthetic */ BasicProgressMonitor this$0;

        public void run() {
            BasicProgressMonitor.ra$_message(this.this$0).setText(this.v$message);
        }

        public 3(BasicProgressMonitor basicProgressMonitor, String string) {
            this.v$message = string;
            this.this$0 = basicProgressMonitor;
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ String v$detailMessage;
        final /* synthetic */ BasicProgressMonitor this$0;

        public void run() {
            BasicProgressMonitor.ra$_note(this.this$0).setText(this.v$detailMessage);
        }

        public 2(BasicProgressMonitor basicProgressMonitor, String string) {
            this.v$detailMessage = string;
            this.this$0 = basicProgressMonitor;
        }
    }

    private static class SubMonitor
    implements ProgressMonitor {
        private final ProgressMonitor _parent;
        private final int _allocatedTicks;
        private int _jumpPerStep;
        private int _startProgress;
        private int _stepsElapsed;

        void $init$() {
            this._stepsElapsed = 0;
        }

        SubMonitor(ProgressMonitor progressMonitor, int n, int n2) {
            this.$init$();
            this._parent = progressMonitor;
            this._allocatedTicks = n;
            this._startProgress = n2;
        }

        private ProgressMonitor getParent() {
            return this._parent;
        }

        private BasicProgressMonitor getRootMonitor() {
            ProgressMonitor progressMonitor = this;
            while (!(progressMonitor instanceof BasicProgressMonitor)) {
                progressMonitor = progressMonitor.getParent();
            }
            return (BasicProgressMonitor)progressMonitor;
        }

        public synchronized void start(int n) {
            this._jumpPerStep = this._allocatedTicks / n;
        }

        public void finished() {
            EventQueue.invokeLater(new 2());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void advanced(int n) {
            SubMonitor subMonitor = this;
            synchronized (subMonitor) {
                ++this._stepsElapsed;
            }
            EventQueue.invokeLater(new 1());
        }

        public boolean isCanceled() {
            return this.getRootMonitor().isCanceled();
        }

        public void setCanceled(boolean bl) {
            this.getRootMonitor().setCanceled(bl);
        }

        public void setMessage(String string) {
            this.getRootMonitor().setMessage(string);
        }

        public void setDetailMessage(String string) {
            this.getRootMonitor().setDetailMessage(string);
        }

        public ProgressMonitor createSubMonitor(int n) {
            return new SubMonitor(this, n * this._jumpPerStep, this._stepsElapsed * this._jumpPerStep);
        }

        static BasicProgressMonitor mav$getRootMonitor(SubMonitor subMonitor) {
            return subMonitor.getRootMonitor();
        }

        static int ra$_startProgress(SubMonitor subMonitor) {
            return subMonitor._startProgress;
        }

        static int ra$_allocatedTicks(SubMonitor subMonitor) {
            return subMonitor._allocatedTicks;
        }

        static int ra$_stepsElapsed(SubMonitor subMonitor) {
            return subMonitor._stepsElapsed;
        }

        static int ra$_jumpPerStep(SubMonitor subMonitor) {
            return subMonitor._jumpPerStep;
        }

        public final class 2
        implements Runnable {
            public void run() {
                JProgressBar jProgressBar = BasicProgressMonitor.ra$_progress(SubMonitor.mav$getRootMonitor(SubMonitor.this));
                jProgressBar.setValue(SubMonitor.ra$_startProgress(SubMonitor.this) + SubMonitor.ra$_allocatedTicks(SubMonitor.this));
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                JProgressBar jProgressBar = BasicProgressMonitor.ra$_progress(SubMonitor.mav$getRootMonitor(SubMonitor.this));
                jProgressBar.setValue(SubMonitor.ra$_startProgress(SubMonitor.this) + SubMonitor.ra$_stepsElapsed(SubMonitor.this) * SubMonitor.ra$_jumpPerStep(SubMonitor.this));
            }
        }
    }

    public static final class 1
    extends Thread {
        private final /* synthetic */ BasicProgressMonitor v$mon;

        public void run() {
            this.v$mon.start(10);
            int n = 0;
            while (n < 10) {
                this.v$mon.setMessage("Step " + (n + 1) + " of 10");
                this.subtask(this.v$mon);
                this.v$mon.advanced(1);
                ++n;
            }
            this.v$mon.finished();
        }

        private void subtask(ProgressMonitor progressMonitor) {
            int n = (int)(Math.random() * 100.0);
            n = Math.max(n, 1);
            ProgressMonitor progressMonitor2 = progressMonitor.createSubMonitor(1);
            progressMonitor2.start(n);
            int n2 = 0;
            while (n2 < n) {
                progressMonitor2.setDetailMessage("SubStep " + (n2 + 1) + " of " + n);
                try {
                    Thread.sleep((int)(200.0 * Math.random()));
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                progressMonitor2.advanced(1);
                ++n2;
            }
            progressMonitor2.finished();
        }

        public 1(BasicProgressMonitor basicProgressMonitor) {
            this.v$mon = basicProgressMonitor;
        }
    }
}

