/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.BufferedInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.MasterListEntry;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.parser.MasterListParser;

public abstract class CheckMasterListRunnable
implements Runnable {
    private boolean _isRunning;
    private final String[] _localHostNames;
    private final String _masterURL;
    private UpdateCenterMonitor _monitor;
    private boolean _isAutomaticUpdateMode;

    public CheckMasterListRunnable(String string) {
        this._masterURL = string;
        this._localHostNames = this.buildLocalHostNames();
    }

    void setAutomaticUpdateMode(boolean bl) {
        this._isAutomaticUpdateMode = bl;
    }

    private String[] buildLocalHostNames() {
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            String[] stringArray = new String[inetAddressArray.length];
            int n = 0;
            while (n < inetAddressArray.length) {
                stringArray[n] = inetAddressArray[n].getCanonicalHostName();
                ++n;
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return new String[0];
        }
    }

    public final void setMonitor(UpdateCenterMonitor updateCenterMonitor) {
        this._monitor = updateCenterMonitor;
    }

    protected final UpdateCenterMonitor getMonitor() {
        if (this._monitor == null) {
            this._monitor = new 1();
        }
        return this._monitor;
    }

    private boolean matchesLocalDomains(MasterListEntry masterListEntry) {
        int n = 0;
        while (n < this._localHostNames.length) {
            if (masterListEntry.matchesDomain(this._localHostNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void run() {
        if (this.getMonitor().isStopped()) {
            return;
        }
        try {
            this.setRunning(true);
            this.getMonitor().start();
            this.getMonitor().setMessage(UpdateArb.getString(108));
            ArrayList<UpdateCenter> arrayList = new ArrayList<UpdateCenter>();
            URL uRL = URLFactory.newURL(this._masterURL);
            BufferedInputStream bufferedInputStream = null;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setRequestProperty("User-Agent", UpdateManager.getInstance().getUserAgent(uRL.toString(), this._isAutomaticUpdateMode));
                bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                List list = new MasterListParser().parse(bufferedInputStream);
                for (MasterListEntry masterListEntry : list) {
                    if (!this.matchesLocalDomains(masterListEntry)) continue;
                    arrayList.add(masterListEntry.getUpdateCenter());
                }
            }
            finally {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            this.getMonitor().finish();
            this.setRunning(false);
            this.finished(arrayList);
        }
        catch (Throwable throwable) {
            this.getMonitor().finish();
            this.setRunning(false);
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            this.failed(throwable);
        }
    }

    public synchronized boolean isRunning() {
        return this._isRunning;
    }

    private synchronized void setRunning(boolean bl) {
        this._isRunning = bl;
    }

    protected abstract void failed(Throwable var1);

    protected abstract void finished(List var1);

    public final class 1
    implements UpdateCenterMonitor {
        public void setMessage(String string) {
        }

        public void setProgress(int n) {
        }

        public void start() {
        }

        public void finish() {
        }

        public boolean isStopped() {
            return false;
        }

        public void setMaximum(int n) {
        }
    }
}

