/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.ide.util.Version;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.parser.UpdateCenterParser;

public abstract class CheckUpdatesRunnable
implements Runnable {
    private final List _updateCenters;
    private boolean _isRunning;
    private boolean _isAutomaticUpdateMode;
    private UpdateCenterMonitor _monitor;

    public CheckUpdatesRunnable(List list) {
        this._updateCenters = list;
    }

    void setAutomaticUpdatesMode(boolean bl) {
        this._isAutomaticUpdateMode = bl;
    }

    public final void setMonitor(UpdateCenterMonitor updateCenterMonitor) {
        this._monitor = updateCenterMonitor;
    }

    protected final UpdateCenterMonitor getMonitor() {
        if (this._monitor == null) {
            this._monitor = new 2();
        }
        return this._monitor;
    }

    public void run() {
        if (this.isStopped()) {
            return;
        }
        try {
            this.setRunning(true);
            this.getMonitor().start();
            this.getMonitor().setMaximum(this._updateCenters.size() * 2);
            Map map = this.getAllAvailableUpdates();
            if (this.isStopped()) {
                this.stopped();
                this.getMonitor().finish();
                this.setRunning(false);
                return;
            }
            Map map2 = this.findInstallableUpdates(map);
            if (this.isStopped()) {
                this.stopped();
                this.getMonitor().finish();
                this.setRunning(false);
                return;
            }
            HashSet<UpdateBundle> hashSet = new HashSet<UpdateBundle>();
            for (UpdateInfo updateInfo : map2.values()) {
                hashSet.add(updateInfo.getBundle());
            }
            HashSet<UpdateBundle> hashSet2 = new HashSet<UpdateBundle>();
            block4: for (UpdateBundle updateBundle : hashSet) {
                for (UpdateInfo updateInfo : updateBundle.getUpdates()) {
                    if (map2.containsKey(updateInfo.getID())) continue;
                    hashSet2.add(updateBundle);
                    continue block4;
                }
            }
            for (UpdateBundle updateBundle : hashSet2) {
                for (UpdateInfo updateInfo : updateBundle.getUpdates()) {
                    map2.remove(updateInfo.getID());
                }
            }
            this.finished(Collections.unmodifiableCollection(map2.values()));
        }
        finally {
            this.getMonitor().finish();
            this.setRunning(false);
        }
    }

    private Map findInstallableUpdates(Map map) {
        HashMap hashMap = new HashMap();
        while (this.scanUpdates(map, hashMap)) {
        }
        return hashMap;
    }

    private boolean scanUpdates(Map map, Map map2) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        block0: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)map.get(string);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                boolean bl2;
                if (this.isStopped()) {
                    return false;
                }
                UpdateInfo updateInfo = (UpdateInfo)iterator2.next();
                Extension extension = extensionRegistry.findExtensionEvenIfNotLoaded(updateInfo.getID());
                if (extension != null && extension.getVersion().compareTo((Object)updateInfo.getVersion()) >= 0 || !(bl2 = this.getInstallableUpdate(updateInfo, map2))) continue;
                bl = true;
                map2.put(string, updateInfo);
                iterator.remove();
                continue block0;
            }
        }
        return bl;
    }

    private boolean getInstallableUpdate(UpdateInfo updateInfo, Map map) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        updateInfo.clearRequiredUpdates();
        updateInfo.setNew(extensionRegistry.findExtension(updateInfo.getID()) == null);
        for (String string : updateInfo.getRequiredIds()) {
            UpdateInfo updateInfo2 = (UpdateInfo)map.get(string);
            if (updateInfo2 != null) {
                if (CheckUpdatesRunnable.testCompatibleVersion(updateInfo, string, updateInfo2.getVersion())) {
                    updateInfo.addRequiredUpdate(updateInfo2);
                    continue;
                }
                return false;
            }
            Extension extension = extensionRegistry.findExtension(string);
            if (extension == null) {
                return false;
            }
            Version version = extension.getVersion();
            if (CheckUpdatesRunnable.testCompatibleVersion(updateInfo, string, version)) continue;
            return false;
        }
        return true;
    }

    public static boolean testCompatibleVersion(UpdateInfo updateInfo, String string, Version version) {
        Version version2 = updateInfo.getRequiredMinVersion(string);
        Version version3 = updateInfo.getRequiredMaxVersion(string);
        if (version2 != null && version.compareTo((Object)version2) < 0) {
            return false;
        }
        return version3 == null || version.compareTo((Object)version3) <= 0;
    }

    private Map getAllAvailableUpdates() {
        HashMap hashMap = new HashMap();
        UpdateCenterParser updateCenterParser = new UpdateCenterParser();
        int n = 0;
        while (n < this._updateCenters.size()) {
            if (this.isStopped()) {
                return null;
            }
            InputStream inputStream = null;
            UpdateCenter updateCenter = (UpdateCenter)this._updateCenters.get(n);
            try {
                try {
                    this.getMonitor().setMessage(UpdateArb.format(161, updateCenter.getName()));
                    URL uRL = URLFactory.newURL(updateCenter.getURL());
                    if ("file".equals(uRL.getProtocol())) {
                        inputStream = new FileInputStream(uRL.getPath());
                    } else {
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setRequestProperty("User-Agent", UpdateManager.getInstance().getUserAgent(uRL.toString(), this._isAutomaticUpdateMode));
                        inputStream = uRLConnection.getInputStream();
                    }
                    this.getMonitor().setProgress(n * 2);
                    if (this.isStopped()) {
                        Map map = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        return map;
                    }
                    Collection collection = updateCenterParser.parse(inputStream);
                    for (UpdateBundle updateBundle : collection) {
                        for (UpdateInfo updateInfo : updateBundle.getUpdates()) {
                            updateInfo.setSourceCenter(updateCenter);
                            ArrayList<UpdateInfo> arrayList = (ArrayList<UpdateInfo>)hashMap.get(updateInfo.getID());
                            if (arrayList == null) {
                                arrayList = new ArrayList<UpdateInfo>();
                                hashMap.put(updateInfo.getID(), arrayList);
                            } else {
                                for (UpdateInfo updateInfo2 : arrayList) {
                                    if (!updateInfo2.getVersion().equals((Object)updateInfo.getVersion())) continue;
                                    updateInfo = null;
                                    break;
                                }
                            }
                            if (updateInfo == null) continue;
                            arrayList.add(updateInfo);
                        }
                    }
                }
                catch (Exception exception) {
                    this.updateCenterError(updateCenter, exception);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            ++n;
        }
        1 var18_22 = new 1();
        for (String string : hashMap.keySet()) {
            List list = (List)hashMap.get(string);
            Collections.sort(list, var18_22);
        }
        return hashMap;
    }

    private synchronized boolean isStopped() {
        return this.getMonitor().isStopped();
    }

    public synchronized boolean isRunning() {
        return this._isRunning;
    }

    private synchronized void setRunning(boolean bl) {
        this._isRunning = bl;
    }

    protected abstract void updateCenterError(UpdateCenter var1, Throwable var2);

    protected abstract void finished(Collection var1);

    protected abstract void stopped();

    public final class 2
    implements UpdateCenterMonitor {
        public void setMessage(String string) {
        }

        public void setProgress(int n) {
        }

        public void start() {
        }

        public void finish() {
        }

        public boolean isStopped() {
            return false;
        }

        public void setMaximum(int n) {
        }
    }

    public final class 1
    implements Comparator {
        public boolean equals(Object object) {
            return object == this;
        }

        public int compare(Object object, Object object2) {
            return ((UpdateInfo)object2).getVersion().compareTo((Object)((UpdateInfo)object).getVersion());
        }
    }
}

