/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class DeterminateProgressMonitor {
    private final JProgressBar m_progress;
    private final JLabel m_label;
    private int m_stepSize;
    private int m_stepCount;
    private boolean m_stopped;
    private int m_currentStepNotch;

    void $init$() {
        this.m_stepSize = 1;
        this.m_stepCount = 0;
        this.m_stopped = false;
        this.m_currentStepNotch = 0;
    }

    public DeterminateProgressMonitor(JProgressBar jProgressBar, JLabel jLabel) {
        this.$init$();
        this.m_progress = jProgressBar;
        this.m_label = jLabel;
        this.m_progress.setMaximum(100);
    }

    Component getComponent() {
        return this.m_progress;
    }

    public synchronized boolean isStopped() {
        return this.m_stopped;
    }

    public synchronized void setStopped(boolean bl) {
        this.m_stopped = bl;
    }

    public void setMajorStepCount(int n) {
        this.m_stepCount = n;
        this.m_stepSize = 100 / n;
    }

    public void startStep(int n) {
        int n2;
        this.m_currentStepNotch = n2 = n * this.m_stepSize;
        this.m_progress.setValue(n2);
    }

    public void endStep(int n) {
        if (n == this.m_stepCount - 1) {
            this.m_progress.setValue(100);
        }
        int n2 = (n + 1) * this.m_stepSize;
        this.m_progress.setValue(n2);
    }

    public void setStepProgress(double d) {
        int n = this.m_currentStepNotch + (int)(d * (double)this.m_stepSize);
        this.m_progress.setValue(n);
    }

    void setMessage(String string) {
        if (!this.isStopped()) {
            this.m_label.setText(string);
        }
    }
}

