/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.OTNAuthPanel;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.WOCAuthenticator;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.DeterminateProgressMonitor;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;

public abstract class DownloadUpdatesRunnable
implements Runnable {
    private static final Logger LOG = Logger.getLogger(DownloadUpdatesRunnable.class.getName());
    private static final boolean DEBUG_MODE = false;
    private static final int BUFFER_SIZE = 4096;
    private static final int AUTH_RETRY = 3;
    private static final long DIAGNOSTIC_SLOWDOWN = 500L;
    private static final NumberFormat TWO_DP_FORMAT = NumberFormat.getInstance();
    private ProxyOptions _savedProxyOptions;
    private static WOCAuthenticator.AuthenticationToken s_wocAuthToken;
    private DeterminateProgressMonitor _monitor;
    private final Collection _remoteUpdates;

    static {
        TWO_DP_FORMAT.setMaximumFractionDigits(2);
        TWO_DP_FORMAT.setMinimumFractionDigits(2);
        TWO_DP_FORMAT.setParseIntegerOnly(false);
    }

    public DownloadUpdatesRunnable(Collection collection) {
        this._remoteUpdates = collection;
    }

    public final void setMonitor(DeterminateProgressMonitor determinateProgressMonitor) {
        this._monitor = determinateProgressMonitor;
    }

    protected final DeterminateProgressMonitor getMonitor() {
        return this._monitor;
    }

    public void run() {
        File file = new File(UpdateManager.getInstance().getDirectories().getTemp());
        if (!file.exists()) {
            if (!file.mkdirs()) {
                this.failed(new Exception("Unable to create temporary directory " + file));
            }
        } else if (!file.isDirectory()) {
            this.failed(new Exception("File " + file + " is in the way."));
        }
        HashSet<UpdateBundle> hashSet = new HashSet<UpdateBundle>();
        for (UpdateInfo updateInfo : this._remoteUpdates) {
            hashSet.add(updateInfo.getBundle());
        }
        HashMap<UpdateBundle, File> hashMap = new HashMap<UpdateBundle, File>();
        this.getMonitor().setMajorStepCount(hashSet.size());
        int n = 0;
        for (UpdateBundle updateBundle : hashSet) {
            String string;
            int n2;
            UpdateCenter updateCenter;
            if (this.getMonitor().isStopped()) {
                this.cancelled();
            }
            this.getMonitor().startStep(n);
            this.getMonitor().setMessage(UpdateArb.format(54, updateBundle.getName()));
            URL uRL = URLFactory.newURL(updateBundle.getDownloadUrl());
            if (uRL == null && (updateCenter = ((UpdateInfo)updateBundle.getUpdates().iterator().next()).getSourceCenter()) != null && (n2 = (string = updateCenter.getURL()).lastIndexOf(47)) >= 1) {
                uRL = URLFactory.newURL(string.substring(0, n2 + 1) + updateBundle.getDownloadUrl());
            }
            String string2 = URLFileSystem.getFileName(uRL);
            File file2 = new File(file, string2);
            int n3 = 0;
            while (file2.exists()) {
                file2 = new File(file, string2 + "." + String.valueOf(++n3));
            }
            try {
                this.copy(updateBundle.getName(), uRL, file2);
                hashMap.put(updateBundle, file2);
                this.getMonitor().endStep(n++);
                if (!this.getMonitor().isStopped()) continue;
                this.cancelled();
            }
            catch (IOException iOException) {
                if (!this.getMonitor().isStopped()) {
                    this.failed(iOException);
                } else {
                    this.cancelled();
                }
                return;
            }
        }
        this.finished(hashMap);
    }

    protected abstract void failed(Exception var1);

    protected abstract void cancelled();

    protected abstract void finished(Map var1);

    private WOCAuthenticator.AuthenticationToken authenticateOTN(String string) throws IOException {
        if (this.getMonitor().isStopped()) {
            throw new IOException("Cancelled Authentication");
        }
        if (s_wocAuthToken == null) {
            OTNAuthPanel oTNAuthPanel = new OTNAuthPanel();
            HelpUtils.setHelpID((JComponent)oTNAuthPanel, (String)"f1_idedsignin_html");
            oTNAuthPanel.setHintText(UpdateArb.format(163, string));
            int n = 0;
            while (n < 3) {
                PasswordAuthentication passwordAuthentication;
                Window window = IdeUtil.findActiveModalWindow();
                if (window == null) {
                    window = IdeUtil.getMainWindow();
                }
                if ((passwordAuthentication = oTNAuthPanel.runDialog(window, UpdateArb.getString(164))) != null) {
                    WOCAuthenticator.AuthenticationToken authenticationToken = new WOCAuthenticator().logIn(passwordAuthentication);
                    if (authenticationToken != null) {
                        s_wocAuthToken = authenticationToken;
                        break;
                    }
                } else {
                    throw new IOException(UpdateArb.getString(34));
                }
                ++n;
            }
            if (s_wocAuthToken == null) {
                throw new IOException(UpdateArb.getString(33));
            }
        }
        return s_wocAuthToken;
    }

    private void copy(String string, URL uRL, File file) throws IOException {
        long l = -1;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            block22: {
                if ("http".equals(uRL.getProtocol())) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    String string2 = uRL.getHost();
                    if ("download.oracle.com".equals(string2)) {
                        WOCAuthenticator.AuthenticationToken authenticationToken = this.authenticateOTN(string);
                        bl = this.fixProxyForDownloadOracleCom();
                        WOCAuthenticator.endorse(httpURLConnection, authenticationToken);
                    }
                    httpURLConnection.setRequestProperty("User-Agent", UpdateManager.getInstance().getUserAgent(uRL.toString(), false));
                    inputStream = httpURLConnection.getInputStream();
                    l = httpURLConnection.getContentLength();
                }
                if (l == (long)-1) {
                    l = URLFileSystem.getLength(uRL);
                }
                if (inputStream == null) {
                    inputStream = URLFileSystem.openInputStream(uRL);
                }
                if (inputStream == null) {
                    throw new IOException(UpdateArb.format(83, uRL));
                }
                outputStream = new FileOutputStream(file);
                byte[] byArray = new byte[4096];
                long l2 = 0L;
                String string3 = DownloadUpdatesRunnable.getDisplaySize(l);
                long l3 = System.currentTimeMillis();
                do {
                    if (this.getMonitor().isStopped()) {
                        throw new IOException("Stopped during copy");
                    }
                    int n = inputStream.read(byArray);
                    if (n < 0) break block22;
                    outputStream.write(byArray, 0, n);
                    l2 += (long)n;
                    if (l == (long)-1) {
                        this.getMonitor().setMessage("Downloading " + string);
                        continue;
                    }
                    this.getMonitor().setMessage(UpdateArb.format(55, string, DownloadUpdatesRunnable.getDisplaySize(l2), string3));
                    this.getMonitor().setStepProgress((double)l2 / (double)l);
                } while (!this.getMonitor().isStopped());
                throw new IOException("Cancelled");
            }
            this.getMonitor().setStepProgress(1.0);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bl) {
                this.unfixProxyForDownloadOracleCom();
            }
        }
    }

    private void unfixProxyForDownloadOracleCom() {
        if (this._savedProxyOptions != null) {
            ProxyOptions.setProxyOptions(this._savedProxyOptions);
            this._savedProxyOptions = null;
        }
    }

    private boolean fixProxyForDownloadOracleCom() {
        this._savedProxyOptions = null;
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        if (!proxyOptions.getUseProxy().booleanValue() || proxyOptions.getProxyHost() == null || proxyOptions.getProxyHost().trim().length() == 0) {
            if (this.isOracleInternalUser()) {
                LOG.info("Detected internal Oracle user with no proxy. Using emeacache for download.oracle.com.");
                this._savedProxyOptions = proxyOptions;
                ProxyOptions proxyOptions2 = new ProxyOptions();
                proxyOptions2.setProxyHost("emeacache.uk.oracle.com");
                proxyOptions2.setProxyPort("80");
                proxyOptions2.setUseProxy(Boolean.TRUE);
                ProxyOptions.setProxyOptions(proxyOptions2);
            }
        } else if (proxyOptions.getProxyHost().endsWith(".oracle.com")) {
            ProxyOptions proxyOptions3 = new ProxyOptions();
            proxyOptions.copyTo(proxyOptions3);
            if (proxyOptions.getProxyExceptions() != null && proxyOptions.getProxyExceptions().indexOf("oracle.com") != -1) {
                LOG.info("Detected internal Oracle user with proxy exclusion for oracle.com. Removing exception for download.oracle.com");
                this._savedProxyOptions = proxyOptions;
                proxyOptions3.setProxyExceptions("");
            }
            if (proxyOptions.getProxyHost().equalsIgnoreCase("www-proxy.us.oracle.com")) {
                LOG.info("Detected internal Oracle user using www-proxy.us.oracle.com. Changing to emeacache.uk.oracle.com to avoid download restrictions for download.oracle.com");
                this._savedProxyOptions = proxyOptions;
                proxyOptions3.setProxyHost("emeacache.uk.oracle.com");
            }
            if (this._savedProxyOptions != null) {
                ProxyOptions.setProxyOptions(proxyOptions3);
            }
        }
        return this._savedProxyOptions != null;
    }

    private boolean isOracleInternalUser() {
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            int n = 0;
            while (n < inetAddressArray.length) {
                String string = inetAddressArray[n].getCanonicalHostName();
                if (string != null && string.endsWith(".oracle.com")) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return false;
    }

    private static String getDisplaySize(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l < 1024L) {
            stringBuffer.append(TWO_DP_FORMAT.format(l));
            stringBuffer.append(" bytes");
        } else if (l >= 1024L && l < 0x100000L) {
            stringBuffer.append(TWO_DP_FORMAT.format((double)l / 1024.0));
            stringBuffer.append(" KB");
        } else if (l >= 0x100000L && l < 0x40000000L) {
            stringBuffer.append(TWO_DP_FORMAT.format((double)l / 1048567.0));
            stringBuffer.append(" MB");
        } else {
            stringBuffer.append(TWO_DP_FORMAT.format((double)l / 1.073741824E9));
            stringBuffer.append(" GB");
        }
        return stringBuffer.toString();
    }
}

