/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.NotABundleException;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.parser.UpdateXMLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

class InternalUpdateGenerator {
    private static final Logger LOGGER = Logger.getLogger(InternalUpdateGenerator.class.getName());
    private static final String NONDEBUG = "nondebug";
    private static final Pattern[] SKIP_PATTERNS = new Pattern[]{Pattern.compile("^jdev.+\\.zip$"), Pattern.compile("^ExtensionSDK.zip$")};

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length < 1) {
            System.err.println("Usage: ");
            System.err.println("  InternalUpdateGenerator <propertiesfile>");
            System.exit(1);
        }
        if (!(file = new File(stringArray[0])).exists()) {
            System.err.println(stringArray[0] + " doesn't exist.");
            System.exit(1);
        }
        FileInputStream fileInputStream = null;
        Properties properties = null;
        try {
            try {
                properties = new Properties();
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
                if (properties.isEmpty()) {
                    System.err.println(stringArray[0] + " is empty.");
                    System.exit(1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        HashMap<String, UpdateSet> hashMap = new HashMap<String, UpdateSet>();
        for (String string : properties.keySet()) {
            int n = string.indexOf(46);
            if (n > 0) {
                String string2 = string.substring(0, n);
                LOGGER.info("UpdateInfo name for " + string + " is " + string2);
                String string3 = string.substring(n + 1);
                UpdateSet updateSet = (UpdateSet)hashMap.get(string2);
                if (updateSet == null) {
                    updateSet = new UpdateSet(null);
                    hashMap.put(string2, updateSet);
                }
                updateSet.name = string2;
                if ("labelroot".equals(string3)) {
                    File file2 = new File(properties.getProperty(string));
                    if (!file2.exists()) {
                        System.err.println(file2 + " doesn't exist.");
                        continue;
                    }
                    if (!file2.isDirectory()) {
                        System.err.println(file2 + " is not a directory.");
                        continue;
                    }
                    updateSet.baseDir = file2;
                    continue;
                }
                if ("relativepath".equals(string3)) {
                    updateSet.relativePath = properties.getProperty(string);
                    continue;
                }
                System.err.println("Unrecognized property: " + string3);
                continue;
            }
            LOGGER.info("Skipped because key doesn't contain a prefix: " + string);
        }
        Document document = null;
        UpdateXMLBuilder updateXMLBuilder = new UpdateXMLBuilder();
        try {
            try {
                String string;
                document = updateXMLBuilder.createUpdatesDocument();
                for (UpdateSet updateSet : hashMap.values()) {
                    if (updateSet.baseDir != null && updateSet.relativePath != null) {
                        InternalUpdateGenerator.processBundleDir(updateSet.baseDir, updateSet.relativePath, document);
                        continue;
                    }
                    if (updateSet.baseDir == null) {
                        LOGGER.warning("Skipping update set " + updateSet.name + " baseDir is null. ");
                        continue;
                    }
                    if (updateSet.relativePath != null) continue;
                    LOGGER.warning("Skipping update set " + updateSet.name + " relativePath is null. ");
                }
                String string4 = properties.getProperty("transformStylesheet");
                if (string4 != null) {
                    File file3 = new File(string4);
                    if (!file3.exists()) {
                        LOGGER.severe("Stylesheet " + file3 + " doesn't exist!");
                    } else {
                        document = InternalUpdateGenerator.xslTransform(document, file3);
                    }
                }
                if ((string = properties.getProperty("displayStylesheet")) != null) {
                    ProcessingInstruction processingInstruction = document.createProcessingInstruction("xml-stylesheet", "href=\"" + string + "\" type=\"text/xsl\"");
                    document.insertBefore(processingInstruction, document.getDocumentElement());
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
        }
        finally {
            if (document != null) {
                try {
                    DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)documentBuilder.getDOMImplementation().getFeature("LS", "3.0");
                    LSOutput lSOutput = dOMImplementationLS.createLSOutput();
                    lSOutput.setByteStream(System.out);
                    LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
                    lSSerializer.setNewLine("\n");
                    lSSerializer.write(document, lSOutput);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
            }
        }
    }

    private static Document xslTransform(Document document, File file) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new FileInputStream(file)));
            DOMSource dOMSource = new DOMSource(document);
            DOMResult dOMResult = new DOMResult();
            transformer.transform(dOMSource, dOMResult);
            Document document2 = (Document)dOMResult.getNode();
            return document2;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            Document document3 = document;
            return document3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            Document document4 = document;
            return document4;
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            Document document5 = document;
            return document5;
        }
    }

    private static void processBundleDir(File file, String string, Document document) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            File file3 = new File(file2, NONDEBUG);
            if (!file3.exists()) {
                LOGGER.warning(file3 + " does not exist, skipping.");
            } else {
                File[] fileArray2 = file3.listFiles();
                int n2 = 0;
                while (n2 < fileArray2.length) {
                    File file4 = fileArray2[n2];
                    try {
                        if (file4.getName().toLowerCase().endsWith(".zip") && !InternalUpdateGenerator.isSkipped(file4)) {
                            InternalUpdateGenerator.processZip(file4, document, string);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static final boolean isSkipped(File file) {
        String string = file.getName();
        int n = 0;
        while (n < SKIP_PATTERNS.length) {
            Pattern pattern = SKIP_PATTERNS[n];
            if (pattern.matcher(string).matches()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final void processZip(File file, Document document, String string) throws IOException {
        try {
            LocalUpdateBundle localUpdateBundle = LocalUpdateBundle.createInstance(file, false);
            UpdateBundle updateBundle = localUpdateBundle.getBundle();
            Set set = updateBundle.getUpdates();
            File file2 = file.getParentFile().getParentFile();
            String string2 = string + "/" + file2.getName() + "/nondebug/" + file.getName();
            if (set.size() == 1) {
                UpdateInfo updateInfo = (UpdateInfo)set.iterator().next();
                updateInfo.setDownloadURL(string2);
            } else {
                updateBundle.setDownloadUrl(string2);
            }
            UpdateXMLBuilder updateXMLBuilder = new UpdateXMLBuilder();
            updateXMLBuilder.appendUpdateBundle(document, updateBundle);
        }
        catch (NotABundleException notABundleException) {
            System.err.println("Skipped " + file + ": Not a bundle. ");
        }
    }

    InternalUpdateGenerator() {
    }

    private static class UpdateSet {
        public String name;
        public File baseDir;
        public String relativePath;

        private UpdateSet() {
        }

        UpdateSet(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

