/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.NotABundleException;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.parser.LocalBundleParser;
import org.xml.sax.SAXException;

public final class LocalUpdateBundle {
    private static final String BUNDLE_MANIFEST = "META-INF/bundle.xml";
    private UpdateBundle _bundle;
    private File _bundleFile;

    public LocalUpdateBundle(UpdateBundle updateBundle) {
        this._bundle = updateBundle;
    }

    public UpdateBundle getBundle() {
        return this._bundle;
    }

    public void setBundleFile(File file) {
        this._bundleFile = file;
    }

    public File getBundleFile() {
        return this._bundleFile;
    }

    public String getContent(String string) throws IOException {
        ZipFile zipFile = new ZipFile(this.getBundleFile());
        ZipEntry zipEntry = zipFile.getEntry(string);
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuffer.append(string2);
                string2 = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
        return stringBuffer.toString();
    }

    public static LocalUpdateBundle createInstance(File file) throws NotABundleException {
        return LocalUpdateBundle.createInstance(file, true);
    }

    static LocalUpdateBundle createInstance(File file, boolean bl) throws NotABundleException {
        if (!file.exists()) {
            throw new NotABundleException(UpdateArb.format(117, file.getName()));
        }
        if (file.isDirectory()) {
            throw new NotABundleException(UpdateArb.format(118, file.getName()));
        }
        if (!file.canRead()) {
            throw new NotABundleException(UpdateArb.format(119, file.getName()));
        }
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipEntry zipEntry = zipFile.getEntry(BUNDLE_MANIFEST);
                if (zipEntry == null) {
                    throw new NotABundleException(UpdateArb.format(133, file.getName(), BUNDLE_MANIFEST));
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                UpdateBundle updateBundle = new LocalBundleParser().parse(inputStream);
                LocalUpdateBundle localUpdateBundle = new LocalUpdateBundle(updateBundle);
                localUpdateBundle.setBundleFile(file);
                if (bl) {
                    for (UpdateInfo updateInfo : updateBundle.getUpdates()) {
                        Extension extension = ExtensionRegistry.getExtensionRegistry().findExtension(updateInfo.getID());
                        updateInfo.setNew(extension == null);
                    }
                }
                LocalUpdateBundle localUpdateBundle2 = localUpdateBundle;
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                return localUpdateBundle2;
            }
            catch (IOException iOException) {
                throw new NotABundleException(UpdateArb.format(120, file.getName()), iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new NotABundleException(UpdateArb.getString(134), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new NotABundleException(UpdateArb.getString(134), sAXException);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            throw throwable;
        }
    }
}

