/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.Version;
import oracle.ide.util.Pair;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;

public final class UpdateInfo
implements Comparable {
    private UpdateBundle _bundle;
    private boolean _isExtension;
    private String _name;
    private String _description;
    private String _id;
    private Version _version;
    private String _clickThrough;
    private Map _requiredIds;
    private String _downloadUrl;
    private String _author;
    private String _authorUrl;
    private String _preferredInstallLocation;
    private boolean _isNew;
    private List _requiredUpdates;
    private UpdateCenter _center;
    private String _postStartupHookClass;

    void $init$() {
        this._requiredIds = new HashMap();
        this._isNew = false;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UpdateInfo) {
            String string = ((UpdateInfo)object).getID();
            return this.getID() != null && string != null && this.getID().equals(string);
        }
        return false;
    }

    public int hashCode() {
        if (this.getID() == null) {
            return super.hashCode();
        }
        return this.getID().hashCode();
    }

    public void setBundle(UpdateBundle updateBundle) {
        this._bundle = updateBundle;
    }

    public UpdateBundle getBundle() {
        return this._bundle;
    }

    public String getPostStartupHookClass() {
        return this._postStartupHookClass;
    }

    public void setPostStartupHookClass(String string) {
        this._postStartupHookClass = string;
    }

    public String getPreferredInstallLocation() {
        return this._preferredInstallLocation;
    }

    public void setPreferredInstallLocation(String string) {
        this._preferredInstallLocation = string;
    }

    public void setSourceCenter(UpdateCenter updateCenter) {
        this._center = updateCenter;
    }

    public UpdateCenter getSourceCenter() {
        return this._center;
    }

    public boolean isNew() {
        return this._isNew;
    }

    void setNew(boolean bl) {
        this._isNew = bl;
    }

    void addRequiredUpdate(UpdateInfo updateInfo) {
        if (this._requiredUpdates == null) {
            this._requiredUpdates = new ArrayList();
        }
        this._requiredUpdates.add(updateInfo);
    }

    void clearRequiredUpdates() {
        if (this._requiredUpdates != null) {
            this._requiredUpdates.clear();
        }
    }

    public List getRequiredUpdates() {
        if (this._requiredUpdates == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this._requiredUpdates);
    }

    public void setAuthor(String string) {
        this._author = string;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthorURL(String string) {
        this._authorUrl = string;
    }

    public String getAuthorURL() {
        return this._authorUrl;
    }

    public void setDownloadURL(String string) {
        this._downloadUrl = string;
    }

    public String getDownloadURL() {
        String string;
        int n;
        UpdateCenter updateCenter;
        if (this._downloadUrl != null && this._downloadUrl.indexOf(58) == -1 && (updateCenter = this.getSourceCenter()) != null && (n = (string = updateCenter.getURL()).lastIndexOf(47)) >= 1) {
            this._downloadUrl = string.substring(0, n + 1) + this._downloadUrl;
        }
        return this._downloadUrl;
    }

    public void addRequiredUpdate(String string, Version version, Version version2) {
        this._requiredIds.put(string, new Pair(version, version2));
    }

    public Collection getRequiredIds() {
        return this._requiredIds.keySet();
    }

    public Version getRequiredMinVersion(String string) {
        Pair pair = (Pair)this._requiredIds.get(string);
        if (pair != null) {
            return (Version)pair.getFirst();
        }
        return null;
    }

    public Version getRequiredMaxVersion(String string) {
        Pair pair = (Pair)this._requiredIds.get(string);
        if (pair != null) {
            return (Version)pair.getSecond();
        }
        return null;
    }

    public void setClickThroughURL(String string) {
        this._clickThrough = string;
    }

    public String getClickThroughURL() {
        return this._clickThrough;
    }

    public boolean hasClickThrough() {
        return this._clickThrough != null;
    }

    public void setID(String string) {
        this._id = string;
    }

    public String getID() {
        return this._id;
    }

    public void setVersion(Version version) {
        this._version = version;
    }

    public Version getVersion() {
        return this._version;
    }

    public boolean isExtension() {
        return this._isExtension;
    }

    public void setExtension(boolean bl) {
        this._isExtension = bl;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String toString() {
        return "UpdateInfo[ name=" + this.getName() + ", description=" + this.getDescription() + ", isExtension=" + this.isExtension() + ", version=" + this.getVersion() + "]";
    }

    public int compareTo(Object object) {
        UpdateInfo updateInfo = (UpdateInfo)object;
        return this.getName().compareTo(updateInfo.getName());
    }

    public UpdateInfo() {
        this.$init$();
    }
}

