/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.GuidGen;
import oracle.ideimpl.webupdate.AutomaticCheckForUpdates;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.dialogs.ExceptionDialog;

public final class UpdateManager {
    private AutomaticCheckForUpdates _autoCheck;
    private static UpdateManager s_instance = null;
    private UpdateCenter[] m_updateCenters;
    private static final String DEFERRED_FILE = "deferred-updates.xml";
    private static final String CENTER_LIST_FILE = "updatecenters.xml";
    private static final String CENTER_LIST_ROOT = "updatecenters";
    private static final String CENTER_LIST_NS = Version.BASE_NAMESPACE_URI + "updatecenters";
    private Directories m_directories;
    private boolean m_singleUserMode;
    private static String s_masterServerURL;
    private static final String DEFAULT_MASTER_SERVER = "http://www.oracle.com/technology/products/jdev/101/update/master.xml";

    void $init$() {
        this._autoCheck = null;
        this.m_singleUserMode = false;
    }

    static {
        String string = System.getProperty("ide.update.masterserver");
        if (string == null) {
            string = DEFAULT_MASTER_SERVER;
        }
        s_masterServerURL = string;
    }

    private UpdateManager() throws SingletonClassException {
        this.$init$();
        if (s_instance != null) {
            throw new SingletonClassException("");
        }
    }

    public synchronized AutomaticCheckForUpdates getAutomaticCheckForUpdates() {
        if (this._autoCheck == null) {
            this._autoCheck = new AutomaticCheckForUpdates();
        }
        return this._autoCheck;
    }

    synchronized void clearAutomaticCheckForUpdates() {
        this._autoCheck = null;
    }

    public boolean isUsingDefaultMasterServer() {
        return DEFAULT_MASTER_SERVER.equals(this.getMasterServerURL());
    }

    public String getMasterServerURL() {
        return s_masterServerURL;
    }

    public void setDirectories(Directories directories) {
        this.m_directories = directories;
        this.m_singleUserMode = new File(directories.getUserExtensionsHome()).equals(new File(directories.getGlobalExtensionsHome()));
    }

    public Directories getDirectories() {
        return this.m_directories;
    }

    private boolean canWriteToDir(File file) {
        File file2 = new File(file, "tempfile.tmp");
        if (file2.exists() && file2.delete()) {
            return false;
        }
        try {
            if (file2.createNewFile()) {
                file2.delete();
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        return false;
    }

    public boolean isGlobalExtensionInstallationAllowed() {
        File file = new File(this.getDirectories().getGlobalExtensionsHome());
        if (!file.exists()) {
            return false;
        }
        return this.canWriteToDir(file);
    }

    public boolean isSingleUserMode() {
        return this.m_singleUserMode;
    }

    public UpdateCenter[] getUpdateCenters() {
        if (this.m_updateCenters == null) {
            this.loadUpdateCenterList();
        }
        return this.m_updateCenters;
    }

    private URL getCenterListFile() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.ide");
        return URLFactory.newURL(uRL, CENTER_LIST_FILE);
    }

    private void loadUpdateCenterList() {
        URL uRL = this.getCenterListFile();
        if (!URLFileSystem.exists(uRL)) {
            this.m_updateCenters = new UpdateCenter[0];
            return;
        }
        ListStructureIO listStructureIO = new ListStructureIO(CENTER_LIST_NS, CENTER_LIST_ROOT);
        try {
            ListStructure listStructure = (ListStructure)listStructureIO.load(uRL);
            this.m_updateCenters = new UpdateCenter[listStructure.size()];
            int n = 0;
            while (n < listStructure.size()) {
                HashStructure hashStructure = (HashStructure)listStructure.get(n);
                UpdateCenter updateCenter = new UpdateCenter();
                updateCenter.setProperties(hashStructure);
                this.m_updateCenters[n] = updateCenter;
                ++n;
            }
        }
        catch (IOException iOException) {
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)iOException);
        }
    }

    private void saveUpdateCenterList() throws IOException {
        if (this.m_updateCenters == null) {
            throw new IllegalStateException("Attempted to save update center list before it has been loaded.");
        }
        URL uRL = this.getCenterListFile();
        ListStructureIO listStructureIO = new ListStructureIO(CENTER_LIST_NS, CENTER_LIST_ROOT);
        ListStructure listStructure = ListStructure.newInstance();
        int n = 0;
        while (n < this.m_updateCenters.length) {
            listStructure.add((Object)this.m_updateCenters[n].getProperties());
            ++n;
        }
        listStructureIO.save(uRL, listStructure);
    }

    public void setUpdateCenters(List list) throws IOException {
        this.m_updateCenters = new UpdateCenter[list.size()];
        list.toArray(this.m_updateCenters);
        this.saveUpdateCenterList();
    }

    public static UpdateManager getInstance() {
        if (s_instance == null) {
            try {
                s_instance = new UpdateManager();
            }
            catch (SingletonClassException singletonClassException) {
                // empty catch block
            }
        }
        return s_instance;
    }

    public File getDeferredUpdatesFile() {
        return new File(this.getDirectories().getUserSettingsHome(), DEFERRED_FILE);
    }

    public String getUserAgent(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Ide.getProgramShortName());
        stringBuffer.append("/");
        stringBuffer.append(Version.VER);
        stringBuffer.append(" (");
        stringBuffer.append(System.getProperty("os.name"));
        stringBuffer.append(" ");
        stringBuffer.append(System.getProperty("os.version"));
        stringBuffer.append("; ");
        stringBuffer.append(System.getProperty("os.arch"));
        stringBuffer.append("; Java ");
        stringBuffer.append(System.getProperty("java.version"));
        stringBuffer.append("; ");
        stringBuffer.append(this.isFirstTime(string) ? "Y" : "N");
        stringBuffer.append(bl ? "A" : "M");
        stringBuffer.append("; ");
        stringBuffer.append(this.getSystemGuid());
        stringBuffer.append("; ");
        stringBuffer.append(Version.EDITION);
        stringBuffer.append(") ");
        stringBuffer.append(Version.VER_FULL);
        return stringBuffer.toString();
    }

    private String getSystemGuid() {
        HashStructure hashStructure = WebUpdateAddin.getPreferences();
        String string = hashStructure.getString("instanceGuid");
        if (string == null) {
            string = GuidGen.toString(GuidGen.uuidCreate());
            hashStructure.putString("instanceGuid", string);
        }
        return string;
    }

    private boolean isFirstTime(String string) {
        boolean bl;
        ListStructure listStructure;
        HashStructure hashStructure = WebUpdateAddin.getPreferences();
        HashStructure hashStructure2 = hashStructure.getHashStructure("pingedVersions2");
        if (hashStructure2 == null) {
            hashStructure2 = HashStructure.newInstance();
            hashStructure.putHashStructure("pingedVersions2", hashStructure2);
        }
        if ((listStructure = hashStructure2.getListStructure(Version.VER_FULL)) == null) {
            listStructure = ListStructure.newInstance();
            hashStructure2.putListStructure(Version.VER_FULL, listStructure);
        }
        if (bl = listStructure.contains((Object)string) ^ true) {
            listStructure.add((Object)string);
        }
        return bl;
    }
}

