/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.config.IdeSettings;
import oracle.ide.icons.IdeIcons;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.webupdate.HashStructureWrapper;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.wizard.UpdateWizard;
import oracle.javatools.data.HashStructure;

public class UpdatePreferences
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox _autoCheck;
    private JButton _checkNow;
    private JLabel _errorMessage;
    private TraversableContext _tc;
    private String _lastErrorType;

    void $init$() {
        this._autoCheck = new JCheckBox();
        this._checkNow = new JButton();
        this._errorMessage = new JLabel();
        this._tc = null;
        this._lastErrorType = "none";
    }

    public UpdatePreferences() {
        this.$init$();
        this.layoutControls();
        this.resControls();
        this.initListeners();
    }

    private void resControls() {
        ResourceUtils.resButton(this._autoCheck, "Automatically Check for Updates");
        ResourceUtils.resButton(this._checkNow, "Check for Updates");
        this._errorMessage.setIcon(IdeIcons.getIcon(3));
        this._errorMessage.setText("The last automatic check failed");
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 10, 0);
        this.add((Component)this._checkNow, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._errorMessage, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._autoCheck, gridBagConstraints);
    }

    private void initListeners() {
        this._checkNow.addActionListener(new 2());
        this._autoCheck.addActionListener(new 1());
    }

    private void checkForUpdates() {
        boolean bl = new UpdateWizard(UpdateManager.getInstance()).runWizard(this, null);
        if (bl) {
            IdeSettings ideSettings = (IdeSettings)this._tc.find("ide-options");
            ideSettings.setAskExit(true);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        String string;
        this._tc = traversableContext;
        HashStructureWrapper hashStructureWrapper = (HashStructureWrapper)traversableContext.find("updatesPreferences");
        if (hashStructureWrapper == null || hashStructureWrapper.getHashStructure() == null) {
            hashStructureWrapper = new HashStructureWrapper(HashStructure.newInstance());
        }
        boolean bl = hashStructureWrapper.getHashStructure().getBoolean("checkOnStartup");
        this._autoCheck.setSelected(bl);
        this._lastErrorType = string = hashStructureWrapper.getHashStructure().getString("lastErrorType", "none");
        if ("generic".equals(string)) {
            this._errorMessage.setText("Automatic check for updates was unable to connect");
        } else if ("proxy".equals(string)) {
            this._errorMessage.setText("A proxy problem occurred while checking for updates. Use the Web Browser and Proxy page.");
        }
        this.updateErrorControls();
    }

    private void updateErrorControls() {
        this._errorMessage.setVisible(this._autoCheck.isSelected() && !"none".equals(this._lastErrorType));
    }

    public void onExit(TraversableContext traversableContext) {
        this._tc = null;
        HashStructureWrapper hashStructureWrapper = (HashStructureWrapper)traversableContext.find("updatesPreferences");
        if (hashStructureWrapper == null || hashStructureWrapper.getHashStructure() == null) {
            hashStructureWrapper = new HashStructureWrapper(HashStructure.newInstance());
            traversableContext.put("updatesPreferences", (Object)hashStructureWrapper);
        }
        hashStructureWrapper.getHashStructure().putBoolean("checkOnStartup", this._autoCheck.isSelected());
    }

    public void apply(ApplyEvent applyEvent) {
        if (!this._autoCheck.isSelected()) {
            UpdateManager.getInstance().getAutomaticCheckForUpdates().updateSkipCheckbox();
            UpdateManager.getInstance().getAutomaticCheckForUpdates().uninstallNotificationIcon();
        }
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    static void mav$checkForUpdates(UpdatePreferences updatePreferences) {
        updatePreferences.checkForUpdates();
    }

    static void mav$updateErrorControls(UpdatePreferences updatePreferences) {
        updatePreferences.updateErrorControls();
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            UpdatePreferences.mav$checkForUpdates(UpdatePreferences.this);
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            UpdatePreferences.mav$updateErrorControls(UpdatePreferences.this);
            UpdatePreferences.this.getParent().invalidate();
        }
    }
}

