/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.webupdate.PostStartupHook;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.HashStructureWrapper;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.javatools.data.HashStructure;

public final class WebUpdateAddin
implements Addin {
    public static final String PREFS_FILE = "cfu.xml";
    public static final String PREFS_KEY = "updatesPreferences";
    public static final String PREFS_KEY_AUTOCHECK = "checkOnStartup";
    public static final String PREFS_KEY_LAST_ERROR = "lastError";
    public static final String PREFS_KEY_LAST_ERROR_TYPE = "lastErrorType";
    public static final String PREFS_LAST_ERROR_TYPE_NONE = "none";
    public static final String PREFS_LAST_ERROR_TYPE_PROXY = "proxy";
    public static final String PREFS_LAST_ERROR_TYPE_GENERIC = "generic";
    public static final String PREFS_KEY_PREVIOUS_UPDATES = "previousUpdates";
    public static final String PREFS_KEY_PINGED_VERSIONS = "pingedVersions2";
    public static final String PREFS_KEY_INSTANCE_GUID = "instanceGuid";
    public static final int CFU_ACTION_ID = Ide.findOrCreateCmdID("CheckForUpdates");

    public void initialize() {
        UpdateManager.getInstance().setDirectories(new IdeDirectories(null));
        JMenu jMenu = MenuManager.getJMenu("Help");
        IdeAction ideAction = IdeAction.find(CFU_ACTION_ID);
        JMenuItem jMenuItem = Ide.getMenubar().createMenuItem(ideAction, 1.0f);
        Ide.getMenubar().add(jMenuItem, jMenu, MenuConstants.SECTION_HELP_UPDATES);
        Ide.addIdeListener(new 1());
    }

    private final void runInitHooks() {
        File file = new File(Ide.getOracleHomeDirectory(), "installhooks.properties");
        if (file.exists()) {
            InputStream inputStream = null;
            Properties properties = null;
            try {
                try {
                    properties = new Properties();
                    inputStream = new FileInputStream(file);
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            try {
                if (properties != null) {
                    this.runInitHooks(properties.keySet());
                }
            }
            finally {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
        }
    }

    private final void runInitHooks(Collection collection) {
        for (String string : collection) {
            try {
                Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                PostStartupHook postStartupHook = (PostStartupHook)clazz.newInstance();
                postStartupHook.install();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void checkForNewUpdates() {
        UpdateManager.getInstance().getAutomaticCheckForUpdates().check();
    }

    static HashStructure getPreferences() {
        ClientSetting clientSetting = ClientSetting.findOrCreate("oracle.ide", PREFS_FILE);
        HashStructureWrapper hashStructureWrapper = (HashStructureWrapper)clientSetting.getData(PREFS_KEY);
        if (hashStructureWrapper == null) {
            HashStructure hashStructure = HashStructure.newInstance();
            hashStructure.putBoolean(PREFS_KEY_AUTOCHECK, true);
            hashStructureWrapper = new HashStructureWrapper(hashStructure);
            clientSetting.putData(PREFS_KEY, hashStructureWrapper);
        }
        return hashStructureWrapper.getHashStructure();
    }

    static void mav$runInitHooks(WebUpdateAddin webUpdateAddin) {
        webUpdateAddin.runInitHooks();
    }

    static void mav$checkForNewUpdates(WebUpdateAddin webUpdateAddin) {
        webUpdateAddin.checkForNewUpdates();
    }

    public final class 1
    implements IdeListener {
        public void mainWindowClosing(IdeEvent ideEvent) {
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
            WebUpdateAddin.mav$runInitHooks(WebUpdateAddin.this);
            WebUpdateAddin.mav$checkForNewUpdates(WebUpdateAddin.this);
        }

        public void addinsLoaded(IdeEvent ideEvent) {
        }
    }

    private class IdeDirectories
    implements Directories {
        private String m_temp;

        void $init$() {
            this.m_temp = null;
        }

        public String getTemp() {
            if (this.m_temp == null) {
                File file = new File(Ide.getUserHomeDirectory() + File.separator + "tmp", "update");
                this.m_temp = file.getPath();
            }
            return this.m_temp;
        }

        public String getGlobalExtensionsHome() {
            File file = new File(Ide.getLibDirectory());
            return new File(file.getParentFile(), "extensions").getAbsolutePath();
        }

        public String getPatchesHome() {
            return Ide.getLibDirectory() + File.separator + "patches";
        }

        public String getUserExtensionsHome() {
            return Ide.getUserHomeDirectory() + "extensions";
        }

        public String getGlobalSettingsHome() {
            return Ide.getLibDirectory();
        }

        public String getUserSettingsHome() {
            return Ide.getUserHomeDirectory() + File.separator + "lib";
        }

        private IdeDirectories() {
            this.$init$();
        }

        IdeDirectories(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

