/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.border.Border;

class BalloonBorder
implements Border {
    private static boolean _shadowEnabled = true;
    private static int _shadowSize = 5;
    private static int _shadowDistance = 5;
    private static float _shadowOpacity = 0.6f;
    private static int _shadowAngle = 45;
    private static int _shadowDistanceX;
    private static int _shadowDistanceY;
    private static final int POINTER_HEIGHT = 20;
    private static final int POINTER_WIDTH = 20;
    private static final int POINTER_INSET = 20;
    private static final int ARC = 18;
    private static final int HALF_ARC = 9;
    private static final Insets INSETS;
    private static final Insets INSETS_SHADOW;

    static {
        double d = Math.toRadians(_shadowAngle);
        _shadowDistanceX = (int)(Math.cos(d) * (double)_shadowDistance);
        _shadowDistanceY = (int)(Math.sin(d) * (double)_shadowDistance);
        INSETS = new Insets(9, 9, 29, 9);
        INSETS_SHADOW = new Insets(9, 9, 29 + _shadowSize, 9 + _shadowSize);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private void applyShadow(BufferedImage bufferedImage) {
        int n;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = _shadowSize - 1 >> 1;
        int n5 = _shadowSize - n4;
        int n6 = n4;
        int n7 = n2 - n5;
        int n8 = n4;
        int n9 = n3 - n5;
        int n10 = Color.BLACK.getRGB() & 0xFFFFFF;
        int[] nArray = new int[_shadowSize];
        int n11 = 0;
        int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n12 = n5 * n2;
        float f = _shadowOpacity / (float)_shadowSize;
        int n13 = 0;
        int n14 = 0;
        while (n13 < n3) {
            n = 0;
            n11 = 0;
            int n15 = 0;
            while (n15 < _shadowSize) {
                int n16;
                nArray[n15] = n16 = nArray2[n14] >>> 24;
                n += n16;
                ++n15;
                ++n14;
            }
            n14 -= n5;
            int n17 = n6;
            while (n17 < n7) {
                int n18 = (int)((float)n * f);
                nArray2[n14] = n18 << 24 | n10;
                n -= nArray[n11];
                nArray[n11] = n18 = nArray2[n14 + n5] >>> 24;
                n += n18;
                if (++n11 >= _shadowSize) {
                    n11 -= _shadowSize;
                }
                ++n17;
                ++n14;
            }
            n14 = ++n13 * n2;
        }
        int n19 = 0;
        int n20 = 0;
        while (n19 < n2) {
            n = 0;
            n11 = 0;
            int n21 = 0;
            while (n21 < _shadowSize) {
                int n22;
                nArray[n21] = n22 = nArray2[n20] >>> 24;
                n += n22;
                ++n21;
                n20 += n2;
            }
            n20 -= n12;
            int n23 = n8;
            while (n23 < n9) {
                int n24 = (int)((float)n * f);
                nArray2[n20] = n24 << 24 | n10;
                n -= nArray[n11];
                nArray[n11] = n24 = nArray2[n20 + n12] >>> 24;
                n += n24;
                if (++n11 >= _shadowSize) {
                    n11 -= _shadowSize;
                }
                ++n23;
                n20 += n2;
            }
            n20 = ++n19;
        }
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = _shadowEnabled ? n3 - _shadowSize : n3;
        int n6 = _shadowEnabled ? n4 - _shadowSize : n4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Area area = new Area(new Rectangle(n, n2, n + n5, 9));
        area.add(new Area(new Rectangle(n, n2 + 9, 9, n2 + n6)));
        area.add(new Area(new Rectangle(n, n2 + n6 - 9 - 20, n + n5, n2 + n6)));
        area.add(new Area(new Rectangle(n + n5 - 9, n2, n + n5, n2 + n6)));
        graphics2D.setClip(area);
        if (_shadowEnabled) {
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n2, n5, n6 - 20, 18.0, 18.0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n + n5 - 1 - 20, n2 + n6 - 20);
            generalPath.lineTo(n + n5 - 1 - 20, n2 + n6);
            generalPath.lineTo(n + n5 - 1 - 20 - 20, n2 + n6 - 20);
            graphics2D2.setColor(Color.BLACK);
            graphics2D2.fill(double_);
            graphics2D2.fill(generalPath);
            graphics2D2.dispose();
            this.applyShadow(bufferedImage);
            graphics2D.drawImage((Image)bufferedImage, n + _shadowDistanceX, n2 + _shadowDistanceY, null);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n2, n5 - 1, n6 - 1 - 20, 18.0, 18.0);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n + n5 - 1 - 20, n2 + n6 - 1 - 20);
        generalPath.lineTo(n + n5 - 1 - 20, n2 + n6 - 1);
        generalPath.lineTo(n + n5 - 1 - 20 - 20, n2 + n6 - 1 - 20);
        graphics2D.setColor(component.getBackground());
        graphics2D.fill(double_);
        graphics2D.setColor(component.getForeground());
        graphics2D.draw(double_);
        graphics2D.setColor(component.getBackground());
        graphics2D.fill(generalPath);
        graphics2D.setColor(component.getForeground());
        graphics2D.draw(generalPath);
        graphics2D.setClip(null);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public Insets getBorderInsets(Component component) {
        return _shadowEnabled ? INSETS_SHADOW : INSETS;
    }

    public Point getPointerLocation(Component component) {
        int n = _shadowEnabled ? component.getWidth() - _shadowSize : component.getWidth();
        int n2 = _shadowEnabled ? component.getHeight() - _shadowSize : component.getHeight();
        int n3 = n - 1 - 20;
        int n4 = n2 + _shadowSize;
        return new Point(n3, n4);
    }

    BalloonBorder() {
    }
}

