/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ideimpl.webupdate.controls.Balloon;
import oracle.ideimpl.webupdate.controls.BalloonBorder;

public final class BalloonManager {
    public static final int TTL_ACTION_SUCCESS = 15000;
    public static final int TTL_ACTION_FAILURE = 20000;
    public static final int TTL_OPTIONAL_USER_TASK = 25000;
    private static final int BALLOON_LAYER = JLayeredPane.POPUP_LAYER + 10;
    private static final Object CP_BALLOON = "oracle.ideimpl.webupdate.balloonClientProperty";
    private static final Object CP_TARGET = "oracle.ideimpl.webupdate.targetClientProperty";
    private static final Set _targetComponents = new HashSet();
    private static final ComponentListener _componentListener = new BMComponentListener(null);
    private static final BMContainerListener _containerListener = new BMContainerListener(null);
    private static final Map _rootListener = new HashMap();

    private BalloonManager() {
    }

    public static Balloon getBalloon(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("target is null");
        }
        return (Balloon)jComponent.getClientProperty(CP_BALLOON);
    }

    public static Action getCloseAction(Balloon balloon) {
        return new 3(balloon);
    }

    public static void showBalloon(Balloon balloon, JComponent jComponent, int n) {
        if (Boolean.valueOf(System.getProperty("ide.balloons.disableTimer")).booleanValue()) {
            BalloonManager.showBalloon(balloon, jComponent);
        }
        2 var3_3 = new 2(balloon);
        Timer timer = new Timer(n, var3_3);
        timer.setRepeats(false);
        BalloonManager.showBalloon(balloon, jComponent);
        timer.start();
    }

    public static void showBalloon(Balloon balloon, JComponent jComponent) {
        if (balloon == null) {
            throw new NullPointerException("balloon is null");
        }
        if (jComponent == null) {
            throw new NullPointerException("target is null");
        }
        JLayeredPane jLayeredPane = BalloonManager.getLayeredPane(jComponent);
        if (jLayeredPane == null) {
            throw new IllegalArgumentException("Target must be in a JFrame or JDialog.");
        }
        if (!jComponent.isVisible()) {
            throw new IllegalArgumentException("Target must be visible");
        }
        if (_targetComponents.contains(jComponent)) {
            throw new IllegalArgumentException("Cannot display multiple balloons for component " + jComponent);
        }
        jLayeredPane.add((Component)balloon, BALLOON_LAYER);
        balloon.setSize(balloon.getPreferredSize());
        BalloonManager.centerOnComponent(balloon, jComponent);
        balloon.setVisible(true);
        BalloonManager.registerTarget(balloon, jComponent);
    }

    public static void hideBalloon(Balloon balloon) {
        JComponent jComponent = (JComponent)balloon.getClientProperty(CP_TARGET);
        if (jComponent != null) {
            BalloonManager.unregisterTarget(jComponent, null);
        }
    }

    private static void centerOnComponent(Balloon balloon, Component component) {
        Point point = BalloonManager.getPositionInLayeredPane(component);
        int n = point.x + component.getWidth() / 2;
        int n2 = point.y;
        BalloonBorder balloonBorder = (BalloonBorder)balloon.getBorder();
        Point point2 = balloonBorder.getPointerLocation(balloon);
        int n3 = n - point2.x;
        int n4 = n2 - point2.y;
        balloon.setLocation(n3, n4);
    }

    private static Point getPositionInLayeredPane(Component component) {
        Point point = new Point();
        point.x = component.getLocation().x;
        point.y = component.getLocation().y;
        Container container = component.getParent();
        while (container != null) {
            Point point2 = container.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            if (container instanceof JLayeredPane) break;
            container = container.getParent();
        }
        return point;
    }

    private static void registerTarget(Balloon balloon, JComponent jComponent) {
        Component component;
        BMRootListener bMRootListener;
        jComponent.addComponentListener(_componentListener);
        jComponent.putClientProperty(CP_BALLOON, balloon);
        balloon.putClientProperty(CP_TARGET, jComponent);
        HashSet hashSet = new HashSet(_targetComponents);
        _targetComponents.add(jComponent);
        boolean bl = true;
        for (Component component2 : hashSet) {
            if (component2.getParent() != jComponent.getParent()) continue;
            bl = false;
            break;
        }
        if (bl) {
            jComponent.getParent().addContainerListener(_containerListener);
        }
        if ((bMRootListener = (BMRootListener)_rootListener.get(component = SwingUtilities.getRoot(jComponent))) == null) {
            bMRootListener = new BMRootListener(component);
            _rootListener.put(component, bMRootListener);
        }
        bMRootListener.addTrackedComponent(jComponent);
    }

    private static void unregisterTarget(JComponent jComponent, Container container) {
        Component component;
        BMRootListener bMRootListener;
        if (container == null) {
            container = jComponent.getParent();
        }
        if (container == null) {
            throw new IllegalArgumentException("Expected to either be passed a parent or find one in the hierarchy.");
        }
        _targetComponents.remove(jComponent);
        jComponent.removeComponentListener(_componentListener);
        boolean bl = true;
        for (Component component2 : _targetComponents) {
            if (component2.getParent() != container) continue;
            bl = false;
            break;
        }
        if (bl) {
            container.removeContainerListener(_containerListener);
        }
        if ((bMRootListener = (BMRootListener)_rootListener.get(component = SwingUtilities.getRoot(container))) != null) {
            bMRootListener.removeTrackedComponent(jComponent);
        }
        Balloon balloon = BalloonManager.getBalloon(jComponent);
        balloon.setVisible(false);
        SwingUtilities.invokeLater(new 1(balloon));
        jComponent.putClientProperty(CP_BALLOON, null);
        balloon.putClientProperty(CP_TARGET, null);
    }

    private static JLayeredPane getLayeredPane(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        JLayeredPane jLayeredPane = null;
        if (window instanceof JFrame) {
            jLayeredPane = ((JFrame)window).getLayeredPane();
        } else if (window instanceof JDialog) {
            jLayeredPane = ((JDialog)window).getLayeredPane();
        }
        return jLayeredPane;
    }

    static void maS$centerOnComponent(Balloon balloon, Component component) {
        BalloonManager.centerOnComponent(balloon, component);
    }

    static void maS$unregisterTarget(JComponent jComponent, Container container) {
        BalloonManager.unregisterTarget(jComponent, container);
    }

    static Map ra$_rootListener() {
        return _rootListener;
    }

    public static final class 3
    extends AbstractAction {
        private final /* synthetic */ Balloon v$balloon;

        public void actionPerformed(ActionEvent actionEvent) {
            BalloonManager.hideBalloon(this.v$balloon);
        }

        public 3(Balloon balloon) {
            this.v$balloon = balloon;
        }
    }

    public static final class 2
    implements ActionListener {
        private final /* synthetic */ Balloon v$balloon;

        public void actionPerformed(ActionEvent actionEvent) {
            Timer timer = (Timer)actionEvent.getSource();
            timer.removeActionListener(this);
            timer.stop();
            BalloonManager.hideBalloon(this.v$balloon);
        }

        public 2(Balloon balloon) {
            this.v$balloon = balloon;
        }
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Balloon v$balloon;

        public void run() {
            this.v$balloon.getParent().remove(this.v$balloon);
        }

        public 1(Balloon balloon) {
            this.v$balloon = balloon;
        }
    }

    private static class BMComponentListener
    extends ComponentAdapter {
        public void componentHidden(ComponentEvent componentEvent) {
            BalloonManager.maS$unregisterTarget((JComponent)componentEvent.getSource(), null);
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.centerBalloon(componentEvent);
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.centerBalloon(componentEvent);
        }

        private void centerBalloon(ComponentEvent componentEvent) {
            JComponent jComponent = (JComponent)componentEvent.getSource();
            Balloon balloon = BalloonManager.getBalloon(jComponent);
            BalloonManager.maS$centerOnComponent(balloon, jComponent);
        }

        private BMComponentListener() {
        }

        BMComponentListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class BMContainerListener
    extends ContainerAdapter
    implements ComponentListener {
        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JComponent && BalloonManager.getBalloon((JComponent)component) != null) {
                BalloonManager.maS$unregisterTarget((JComponent)component, containerEvent.getContainer());
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.updateChildren(componentEvent);
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.updateChildren(componentEvent);
        }

        private void updateChildren(ComponentEvent componentEvent) {
            Container container = (Container)componentEvent.getSource();
            int n = 0;
            while (n < container.getComponentCount()) {
                JComponent jComponent;
                Balloon balloon;
                Component component = container.getComponent(n);
                if (component instanceof JComponent && (balloon = BalloonManager.getBalloon(jComponent = (JComponent)component)) != null) {
                    BalloonManager.maS$centerOnComponent(balloon, component);
                }
                ++n;
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        private BMContainerListener() {
        }

        BMContainerListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class BMRootListener
    extends ComponentAdapter {
        private Component _root;
        private Set _trackedComponents;

        void $init$() {
            this._root = null;
            this._trackedComponents = new HashSet();
        }

        BMRootListener(Component component) {
            this.$init$();
            component.addComponentListener(this);
            this._root = component;
        }

        public void addTrackedComponent(JComponent jComponent) {
            this._trackedComponents.add(jComponent);
        }

        public void removeTrackedComponent(JComponent jComponent) {
            this._trackedComponents.remove(jComponent);
            if (this._trackedComponents.isEmpty()) {
                this._root.removeComponentListener(this);
                BalloonManager.ra$_rootListener().remove(this._root);
                this._root = null;
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            for (JComponent jComponent : this._trackedComponents) {
                Balloon balloon = BalloonManager.getBalloon(jComponent);
                if (balloon == null) continue;
                BalloonManager.maS$centerOnComponent(balloon, jComponent);
            }
        }
    }
}

