/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.controls;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import oracle.ideimpl.webupdate.controls.Balloon;

public class BalloonUI
extends PanelUI {
    protected static BalloonUI balloonUI = new BalloonUI();
    private Rectangle _scratch;
    private final MouseAdapter _listener;

    void $init$() {
        this._scratch = new Rectangle();
        this._listener = new 1();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        graphics.setColor(jComponent.getBackground());
        ((Graphics2D)graphics).fill(SwingUtilities.calculateInnerArea(jComponent, this._scratch));
    }

    public void installUI(JComponent jComponent) {
        Balloon balloon = (Balloon)jComponent;
        this.installDefaults(balloon);
        this.installListeners(balloon);
    }

    public void uninstallUI(JComponent jComponent) {
        Balloon balloon = (Balloon)jComponent;
        this.uninstallDefaults(balloon);
        this.uninstallListeners(balloon);
    }

    protected void installDefaults(Balloon balloon) {
        balloon.setOpaque(false);
        LookAndFeel.installColorsAndFont(balloon, "Balloon.background", "Balloon.foreground", "Balloon.font");
        LookAndFeel.installBorder(balloon, "Balloon.border");
    }

    protected void uninstallDefaults(Balloon balloon) {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return balloonUI;
    }

    private void installListeners(Balloon balloon) {
        balloon.addMouseListener(this._listener);
    }

    private void uninstallListeners(Balloon balloon) {
        balloon.removeMouseListener(this._listener);
    }

    public BalloonUI() {
        this.$init$();
    }

    public final class 1
    extends MouseAdapter {
        public void mouseReleased(MouseEvent mouseEvent) {
            Balloon balloon;
            if (mouseEvent.getButton() == 1 && (balloon = this.getBalloon(mouseEvent)) != null) {
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, balloon);
                Rectangle rectangle = SwingUtilities.calculateInnerArea(balloon, null);
                if (rectangle.contains(mouseEvent2.getPoint())) {
                    balloon.fireActionPerformed();
                }
            }
        }

        private Balloon getBalloon(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            while (component != null) {
                if (component instanceof Balloon) {
                    return (Balloon)component;
                }
                component = component.getParent();
            }
            return null;
        }
    }
}

