/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import oracle.ideimpl.webupdate.controls.BalloonBorder;

class BasicLookAndFeel {
    private static boolean _init = false;

    public static void initDefaults() {
        if (!_init) {
            try {
                BasicLookAndFeel.initDefaultsImpl();
            }
            finally {
                _init = true;
            }
        }
    }

    private static void initDefaultsImpl() {
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Tooltip.background");
        Color color2 = UIManager.getColor("Tooltip.foreground");
        if (color == null) {
            color = UIManager.getColor("info");
        }
        if (color2 == null) {
            color2 = UIManager.getColor("infoText");
        }
        Object[] objectArray = new Object[]{"BalloonUI", "oracle.ideimpl.webupdate.controls.BalloonUI", "Balloon.background", color, "Balloon.foreground", color2, "Balloon.border", new BalloonBorderUIResource(null), "Balloon.font", UIManager.getFont("Tooltip.font"), "Balloon.headerFont", new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{font.getName(), new Integer(1), new Integer(font.getSize())}), "Balloon.closeButtonBorder", new SmallButtonBorder(null)};
        UIManager.getDefaults().putDefaults(objectArray);
    }

    BasicLookAndFeel() {
    }

    private static class BalloonBorderUIResource
    extends BalloonBorder
    implements UIResource {
        private BalloonBorderUIResource() {
        }

        BalloonBorderUIResource(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class SmallButtonBorder
    implements UIResource,
    Border {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            Color color = component.getForeground();
            graphics.setColor(color);
            graphics.drawLine(2, 0, n3 - 3, 0);
            graphics.drawLine(0, 2, 0, n4 - 3);
            graphics.drawLine(2, n4 - 1, n3 - 3, n4 - 1);
            graphics.drawLine(n3 - 1, 2, n3 - 1, n4 - 3);
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() * 4 / 7);
            graphics.setColor(color2);
            graphics.drawLine(0, 1, 1, 1);
            graphics.drawLine(1, 0, 1, 1);
            graphics.drawLine(n3 - 1, 1, n3 - 2, 1);
            graphics.drawLine(n3 - 2, 0, n3 - 2, 1);
            graphics.drawLine(n3 - 1, n4 - 2, n3 - 2, n4 - 2);
            graphics.drawLine(n3 - 2, n4 - 1, n3 - 2, n4 - 2);
            graphics.drawLine(0, n4 - 2, 1, n4 - 2);
            graphics.drawLine(1, n4 - 1, 1, n4 - 2);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        private SmallButtonBorder() {
        }

        SmallButtonBorder(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static abstract class LazyLoadIcon
    implements Icon {
        private Icon _delegate;

        private Icon getDelegate() {
            if (this._delegate == null) {
                this._delegate = this.loadDelegate();
            }
            return this._delegate;
        }

        protected abstract Icon loadDelegate();

        public int getIconHeight() {
            return this.getDelegate().getIconHeight();
        }

        public int getIconWidth() {
            return this.getDelegate().getIconWidth();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.getDelegate().paintIcon(component, graphics, n, n2);
        }

        private LazyLoadIcon() {
        }
    }
}

