/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ideimpl.webupdate.MasterListEntry;
import oracle.ideimpl.webupdate.parser.InputStreamLocator;
import oracle.ideimpl.webupdate.parser.UpdateHandler;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.Key;
import oracle.javatools.xml.esax.spi.ExtensibleSAXParser;
import org.xml.sax.SAXException;

public final class MasterListParser
extends ExtensibleSAXParser {
    static final String NAMESPACE_URI = "http://xmlns.oracle.com/jdeveloper/update/master";
    static final Key KEY_CENTERS_COLL = new Key("centers-coll");
    static final Key KEY_CURRENT_ENTRY = new Key("centers-entry");

    public List parse(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        InputStreamLocator inputStreamLocator = new InputStreamLocator(inputStream);
        this.getContext().putValue(KEY_CENTERS_COLL, new ArrayList());
        this.getContext().registerChildHandler(NAMESPACE_URI, "centers", (ElementHandler)new CentersHandler(null));
        this.parse(inputStreamLocator);
        return Collections.unmodifiableList((List)this.getContext().getValue(KEY_CENTERS_COLL));
    }

    private class CentersHandler
    extends ElementHandler {
        public void handleStart(ElementStartContext elementStartContext) {
            elementStartContext.registerChildHandler(MasterListParser.NAMESPACE_URI, "center", (ElementHandler)new CenterHandler(null));
        }

        private CentersHandler() {
        }

        CentersHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CenterHandler
    extends ElementHandler {
        public void handleStart(ElementStartContext elementStartContext) {
            MasterListEntry masterListEntry = new MasterListEntry();
            String string = elementStartContext.getAttributeValue("protected");
            boolean bl = false;
            if (string != null) {
                bl = Boolean.getBoolean(string);
            }
            masterListEntry.getUpdateCenter().setProtected(bl);
            String string2 = elementStartContext.getAttributeValue("id").trim();
            masterListEntry.getUpdateCenter().setMasterId(string2);
            String string3 = elementStartContext.getAttributeValue("selected");
            boolean bl2 = false;
            if (string3 != null) {
                bl2 = Boolean.getBoolean(string3);
            }
            elementStartContext.putValue(KEY_CURRENT_ENTRY, (Object)masterListEntry);
            Collection collection = (Collection)elementStartContext.getValue(KEY_CENTERS_COLL);
            collection.add(masterListEntry);
            elementStartContext.registerChildHandler(MasterListParser.NAMESPACE_URI, "domain", (ElementHandler)new DomainHandler(null));
            elementStartContext.registerChildHandler(MasterListParser.NAMESPACE_URI, "url", (ElementHandler)new UrlHandler(null));
            elementStartContext.registerChildHandler(MasterListParser.NAMESPACE_URI, "name", (ElementHandler)new NameHandler(null));
        }

        private CenterHandler() {
        }

        CenterHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DomainHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            MasterListEntry masterListEntry = (MasterListEntry)elementEndContext.getValue(KEY_CURRENT_ENTRY);
            masterListEntry.setDomainRegexp(UpdateHandler.getText(elementEndContext));
        }

        private DomainHandler() {
        }

        DomainHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class UrlHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            MasterListEntry masterListEntry = (MasterListEntry)elementEndContext.getValue(KEY_CURRENT_ENTRY);
            masterListEntry.getUpdateCenter().setURL(UpdateHandler.getText(elementEndContext));
        }

        private UrlHandler() {
        }

        UrlHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class NameHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            MasterListEntry masterListEntry = (MasterListEntry)elementEndContext.getValue(KEY_CURRENT_ENTRY);
            masterListEntry.getUpdateCenter().setName(UpdateHandler.getText(elementEndContext));
        }

        private NameHandler() {
        }

        NameHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

