/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import javax.ide.util.Version;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.HandlerException;
import oracle.javatools.xml.esax.Key;

abstract class UpdateHandler
extends ElementHandler {
    private static final Key KEY_UPDATE = new Key("update");
    static final String NAMESPACE = "http://xmlns.oracle.com/jdeveloper/update";
    private static final String TYPE_PATCH = "patch";
    private static final String TYPE_EXT = "extension";
    private ElementHandler _nameHandler;
    private ElementHandler _versionHandler;
    private ElementHandler _authorHandler;
    private ElementHandler _authorUrlHandler;
    private ElementHandler _descriptionHandler;
    private ElementHandler _requirementsHandler;
    private ElementHandler _requiresAgreementHandler;
    private ElementHandler _requiresExtensionHandler;
    private ElementHandler _bundleUrlHandler;
    private ElementHandler _destinationHandler;
    private ElementHandler _postStartupHookHandler;

    void $init$() {
        this._nameHandler = new NameHandler(null);
        this._versionHandler = new VersionHandler(null);
        this._authorHandler = new AuthorHandler(null);
        this._authorUrlHandler = new AuthorUrlHandler(null);
        this._descriptionHandler = new DescriptionHandler(null);
        this._requirementsHandler = new RequirementsHandler(null);
        this._requiresAgreementHandler = new RequiresAgreementHandler(null);
        this._requiresExtensionHandler = new RequiresExtensionHandler(null);
        this._bundleUrlHandler = new BundleUrlHandler(null);
        this._destinationHandler = new DestinationHandler(null);
        this._postStartupHookHandler = new PostStartupHookHandler(null);
    }

    public void handleStart(ElementStartContext elementStartContext) throws HandlerException {
        UpdateInfo updateInfo = new UpdateInfo();
        String string = elementStartContext.getAttributeValue("id");
        if (string == null) {
            elementStartContext.getMessageReporter().error(elementStartContext.getLocator(), "_id attribute of extension element is required.", null);
            return;
        }
        updateInfo.setID(elementStartContext.getAttributeValue("id"));
        String string2 = elementStartContext.getAttributeValue("type");
        if (string2 == null || TYPE_EXT.equals(string2)) {
            updateInfo.setExtension(true);
        } else if (string2 != null) {
            if (TYPE_PATCH.equals(string2)) {
                updateInfo.setExtension(false);
            } else {
                elementStartContext.getMessageReporter().error(elementStartContext.getLocator(), "_type attribute of extension element must be either 'patch' or 'extension'", null);
                return;
            }
        }
        elementStartContext.putValue(KEY_UPDATE, (Object)updateInfo);
        elementStartContext.registerChildHandler(NAMESPACE, "name", this._nameHandler);
        elementStartContext.registerChildHandler(NAMESPACE, "version", this._versionHandler);
        elementStartContext.registerChildHandler(NAMESPACE, "author", this._authorHandler);
        elementStartContext.registerChildHandler(NAMESPACE, "author-url", this._authorUrlHandler);
        elementStartContext.registerChildHandler(NAMESPACE, "description", this._descriptionHandler);
        elementStartContext.registerChildHandler(NAMESPACE, "requirements", this._requirementsHandler);
        elementStartContext.registerChildHandler(NAMESPACE, "bundle-url", this._bundleUrlHandler);
        elementStartContext.registerChildHandler(NAMESPACE, "destination", this._destinationHandler);
        elementStartContext.registerChildHandler(NAMESPACE, "post-startup-hook", this._postStartupHookHandler);
    }

    protected abstract void handleUpdate(ElementContext var1, UpdateInfo var2);

    public void handleEnd(ElementEndContext elementEndContext) {
        this.handleUpdate((ElementContext)elementEndContext, this.getUpdate((ElementContext)elementEndContext));
    }

    private UpdateInfo getUpdate(ElementContext elementContext) {
        return (UpdateInfo)elementContext.getValue(KEY_UPDATE);
    }

    static String getText(ElementEndContext elementEndContext) {
        String string = elementEndContext.getText();
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    UpdateHandler() {
        this.$init$();
    }

    static UpdateInfo mav$getUpdate(UpdateHandler updateHandler, ElementContext elementContext) {
        return updateHandler.getUpdate(elementContext);
    }

    static ElementHandler ra$_requiresExtensionHandler(UpdateHandler updateHandler) {
        return updateHandler._requiresExtensionHandler;
    }

    static ElementHandler ra$_requiresAgreementHandler(UpdateHandler updateHandler) {
        return updateHandler._requiresAgreementHandler;
    }

    private class NameHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            UpdateInfo updateInfo = UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementEndContext);
            updateInfo.setName(UpdateHandler.getText(elementEndContext));
        }

        private NameHandler() {
        }

        NameHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class VersionHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            UpdateInfo updateInfo = UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementEndContext);
            updateInfo.setVersion(new Version(UpdateHandler.getText(elementEndContext)));
        }

        private VersionHandler() {
        }

        VersionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class AuthorHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            UpdateInfo updateInfo = UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementEndContext);
            updateInfo.setAuthor(UpdateHandler.getText(elementEndContext));
        }

        private AuthorHandler() {
        }

        AuthorHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class AuthorUrlHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            UpdateInfo updateInfo = UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementEndContext);
            updateInfo.setAuthorURL(UpdateHandler.getText(elementEndContext));
        }

        private AuthorUrlHandler() {
        }

        AuthorUrlHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DescriptionHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            UpdateInfo updateInfo = UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementEndContext);
            updateInfo.setDescription(UpdateHandler.getText(elementEndContext));
        }

        private DescriptionHandler() {
        }

        DescriptionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class RequirementsHandler
    extends ElementHandler {
        public void handleStart(ElementStartContext elementStartContext) {
            elementStartContext.registerChildHandler(UpdateHandler.NAMESPACE, "requires-extension", UpdateHandler.ra$_requiresExtensionHandler(UpdateHandler.this));
            elementStartContext.registerChildHandler(UpdateHandler.NAMESPACE, "requires-agreement", UpdateHandler.ra$_requiresAgreementHandler(UpdateHandler.this));
        }

        private RequirementsHandler() {
        }

        RequirementsHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class RequiresExtensionHandler
    extends ElementHandler {
        public void handleStart(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("id");
            if (string == null) {
                elementStartContext.getMessageReporter().error(elementStartContext.getLocator(), "_attribute id required for element requires-extension.", null);
                return;
            }
            String string2 = elementStartContext.getAttributeValue("minVersion");
            Version version = string2 == null ? null : new Version(string2);
            String string3 = elementStartContext.getAttributeValue("maxVersion");
            Version version2 = string3 == null ? null : new Version(string3);
            UpdateInfo updateInfo = UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementStartContext);
            updateInfo.addRequiredUpdate(string, version, version2);
        }

        private RequiresExtensionHandler() {
        }

        RequiresExtensionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class RequiresAgreementHandler
    extends ElementHandler {
        public void handleStart(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("url");
            if (string == null) {
                elementStartContext.getMessageReporter().error(elementStartContext.getLocator(), "_attribute url required for element requires-agreement", null);
                return;
            }
            UpdateInfo updateInfo = UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementStartContext);
            if (updateInfo.getClickThroughURL() != null) {
                elementStartContext.getMessageReporter().error(elementStartContext.getLocator(), "_can only have one requires-agreement element for an extension.", null);
                return;
            }
            updateInfo.setClickThroughURL(string);
        }

        private RequiresAgreementHandler() {
        }

        RequiresAgreementHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class BundleUrlHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            UpdateInfo updateInfo = UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementEndContext);
            updateInfo.setDownloadURL(UpdateHandler.getText(elementEndContext));
        }

        private BundleUrlHandler() {
        }

        BundleUrlHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DestinationHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementEndContext).setPreferredInstallLocation(UpdateHandler.getText(elementEndContext));
        }

        private DestinationHandler() {
        }

        DestinationHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PostStartupHookHandler
    extends ElementHandler {
        public void handleEnd(ElementEndContext elementEndContext) {
            UpdateHandler.mav$getUpdate(UpdateHandler.this, (ElementContext)elementEndContext).setPostStartupHookClass(UpdateHandler.getText(elementEndContext));
        }

        private PostStartupHookHandler() {
        }

        PostStartupHookHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

