/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import java.util.Iterator;
import java.util.Set;
import javax.ide.util.Version;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class UpdateXMLBuilder {
    private DocumentBuilder _builder;

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this._builder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            this._builder = documentBuilderFactory.newDocumentBuilder();
        }
        return this._builder;
    }

    public Document createUpdatesDocument() throws ParserConfigurationException {
        Document document = this.getDocumentBuilder().newDocument();
        Element element = document.createElementNS("http://xmlns.oracle.com/jdeveloper/updatecenter", "updates");
        element.setAttribute("version", "1.0");
        document.appendChild(element);
        return document;
    }

    public void appendUpdateBundle(Document document, UpdateBundle updateBundle) {
        Set set = updateBundle.getUpdates();
        if (set.size() == 1) {
            this.appendUpdate(document.getDocumentElement(), (UpdateInfo)set.iterator().next());
        } else {
            Element element = document.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "bundle");
            document.getDocumentElement().appendChild(element);
            this.text(element, "http://xmlns.oracle.com/jdeveloper/update", "name", updateBundle.getName());
            this.text(element, "http://xmlns.oracle.com/jdeveloper/update", "bundle-url", updateBundle.getDownloadUrl());
            this.text(element, "http://xmlns.oracle.com/jdeveloper/update", "destination", updateBundle.getInstallLocation());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.appendUpdate(element, (UpdateInfo)iterator.next());
            }
        }
    }

    private void appendUpdate(Element element, UpdateInfo updateInfo) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "update");
        element2.setAttribute("id", updateInfo.getID());
        element.appendChild(element2);
        this.text(element2, "http://xmlns.oracle.com/jdeveloper/update", "name", updateInfo.getName());
        this.text(element2, "http://xmlns.oracle.com/jdeveloper/update", "version", updateInfo.getVersion().toString());
        this.text(element2, "http://xmlns.oracle.com/jdeveloper/update", "author", updateInfo.getAuthor());
        this.text(element2, "http://xmlns.oracle.com/jdeveloper/update", "author-url", updateInfo.getAuthorURL());
        this.text(element2, "http://xmlns.oracle.com/jdeveloper/update", "description", updateInfo.getDescription());
        if (updateInfo.getPostStartupHookClass() != null) {
            this.text(element2, "http://xmlns.oracle.com/jdeveloper/update", "post-startup-hook", updateInfo.getPostStartupHookClass());
        }
        Element element3 = document.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "requirements");
        element2.appendChild(element3);
        for (String string : updateInfo.getRequiredIds()) {
            Version version = updateInfo.getRequiredMinVersion(string);
            Version version2 = updateInfo.getRequiredMaxVersion(string);
            Element element4 = document.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "requires-extension");
            element4.setAttribute("id", string);
            if (version != null) {
                element4.setAttribute("minVersion", version.toString());
            }
            if (version2 != null) {
                element4.setAttribute("maxVersion", version2.toString());
            }
            element3.appendChild(element4);
        }
        if (updateInfo.getClickThroughURL() != null) {
            Element element5 = document.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "requires-agreement");
            element3.appendChild(element5);
            element5.setAttribute("url", updateInfo.getClickThroughURL());
        }
        if (updateInfo.getPreferredInstallLocation() != null) {
            this.text(element2, "http://xmlns.oracle.com/jdeveloper/update", "destination", updateInfo.getPreferredInstallLocation());
        }
        this.text(element2, "http://xmlns.oracle.com/jdeveloper/update", "bundle-url", updateInfo.getDownloadURL());
    }

    private void text(Element element, String string, String string2, String string3) {
        if (string3 == null) {
            return;
        }
        Element element2 = element.getOwnerDocument().createElementNS(string, string2);
        element.appendChild(element2);
        element2.appendChild(element.getOwnerDocument().createTextNode(string3));
    }
}

