/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

final class CreateDirectory
extends AtomicTask {
    private final File _directory;
    private List _createdDirectories;

    public CreateDirectory(File file) {
        this._directory = file;
    }

    public void perform(TaskContext taskContext) throws TaskFailedException {
        if (this._directory.exists()) {
            if (this._directory.isDirectory()) {
                this._createdDirectories = Collections.EMPTY_LIST;
            } else {
                throw new TaskFailedException(UpdateArb.format(145, this._directory.getPath()));
            }
        }
        this._createdDirectories = new ArrayList();
        if (!this.mkdir(this._directory)) {
            throw new TaskFailedException(UpdateArb.format(145, this._directory.getPath()));
        }
    }

    private boolean mkdir(File file) {
        if (file.exists() && file.isDirectory()) {
            return true;
        }
        File file2 = file.getParentFile();
        if (file2.exists()) {
            if (file.mkdir()) {
                this._createdDirectories.add(file);
                return true;
            }
            return false;
        }
        return this.mkdir(file2);
    }

    public void rollback(TaskContext taskContext) throws TaskFailedException {
        ArrayList arrayList = new ArrayList(this._createdDirectories);
        Collections.reverse(arrayList);
        for (File file : arrayList) {
            if (file.delete()) continue;
            throw new TaskFailedException(UpdateArb.format(146, file.getPath()));
        }
    }
}

