/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.io.IOException;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

public class CreateFile
extends AtomicTask {
    private final File _file;
    private boolean _createdFile;

    public CreateFile(File file) {
        this._file = file;
    }

    public void perform(TaskContext taskContext) throws TaskFailedException {
        if (this._file.exists()) {
            if (this._file.isDirectory()) {
                throw new TaskFailedException("Directory " + this._file + " is in the way.");
            }
            this._createdFile = false;
            return;
        }
        try {
            if (!this._file.createNewFile()) {
                throw new TaskFailedException("Failed to create file " + this._file);
            }
            this._createdFile = true;
        }
        catch (IOException iOException) {
            throw new TaskFailedException("Failed to create file " + this._file);
        }
    }

    public void rollback(TaskContext taskContext) throws TaskFailedException {
        if (this._createdFile && !this._file.delete()) {
            throw new TaskFailedException("Failed to delete file " + this._file);
        }
    }
}

