/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.CreateDirectory;
import oracle.ideimpl.webupdate.task.MoveFile;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;
import oracle.ideimpl.webupdate.task.TaskStack;

public class DeinstallExtensionTask
extends AtomicTask {
    private static final String KEY_EXTENSION_ID = "extensionId";
    private static final String KEY_VERSION = "version";
    private TaskStack _tasks;

    public DeinstallExtensionTask() {
    }

    public DeinstallExtensionTask(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Extension id must not be null");
        }
        Extension extension = ExtensionRegistry.getExtensionRegistry().findExtension(string);
        if (extension == null) {
            throw new IllegalArgumentException("Extension " + string + " does not exist, or is not loaded. ");
        }
        Version version = extension.getVersion();
        this.getProperties().putString(KEY_EXTENSION_ID, string);
        this.getProperties().putString(KEY_VERSION, version.toString());
    }

    public void perform(TaskContext taskContext) throws TaskFailedException {
        this._tasks = new TaskStack();
        taskContext.getProgress().setPercentProgress(0.0);
        String string = this.getProperties().getString(KEY_EXTENSION_ID);
        String string2 = this.getProperties().getString(KEY_VERSION);
        File[] fileArray = new File[]{};
        boolean bl = true;
        File file = new File(taskContext.getDirectories().getUserExtensionsHome());
        if (file.exists() && file.isDirectory()) {
            fileArray = this.findExtensionFiles(file, string);
        }
        if (fileArray.length == 0) {
            bl = false;
            File file2 = new File(taskContext.getDirectories().getGlobalExtensionsHome());
            if (file2.exists() && file2.isDirectory()) {
                fileArray = this.findExtensionFiles(file2, string);
                if (fileArray.length == 0) {
                    taskContext.getProgress().setPercentProgress(1.0);
                    return;
                }
            } else {
                taskContext.getProgress().setPercentProgress(1.0);
                return;
            }
        }
        File file3 = new File(bl ? taskContext.getDirectories().getUserSettingsHome() : taskContext.getDirectories().getGlobalSettingsHome(), "oracle.ideimpl.webupdate.backup");
        this._tasks.performTask(new CreateDirectory(file3), taskContext);
        taskContext.getProgress().setPercentProgress(0.33);
        this.pause();
        String string3 = string + "." + string2;
        File file4 = new File(file3, string3);
        if (file4.exists()) {
            int n = 1;
            while ((file4 = new File(file3, string3 + "_" + String.valueOf(n))).exists()) {
                ++n;
            }
        }
        this._tasks.performTask(new CreateDirectory(file4), taskContext);
        taskContext.getProgress().setPercentProgress(0.66);
        this.pause();
        int n = 0;
        while (n < fileArray.length) {
            File file5 = fileArray[n];
            File file6 = new File(file4, file5.getName());
            this._tasks.performTask(new MoveFile(file5, file6), taskContext);
            ++n;
        }
        taskContext.getProgress().setPercentProgress(1.0);
    }

    private File[] findExtensionFiles(File file, String string) {
        ArrayList<File> arrayList = new ArrayList<File>(2);
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (string.equals(this.getExtensionID(file2))) {
                arrayList.add(file2);
            }
            ++n;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private String getExtensionID(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ("jar".equalsIgnoreCase(string) || DeinstallExtensionTask.isNumber(string)) continue;
            stringBuffer.append(string);
            stringBuffer.append(".");
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private static final boolean isNumber(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void rollback(TaskContext taskContext) throws TaskFailedException {
        if (this._tasks == null) {
            throw new IllegalStateException("Attempt to rollback task before performed.");
        }
        this._tasks.rollbackTasks(taskContext);
    }
}

