/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

public class DeleteFile
extends AtomicTask {
    private final File _fileToDelete;
    private File _backupFile;

    public DeleteFile(File file) {
        this._fileToDelete = file;
    }

    public void perform(TaskContext taskContext) throws TaskFailedException {
        String string = ".DeleteFile";
        File file = new File(this._fileToDelete.getPath() + string);
        int n = 0;
        while (file.exists()) {
            file = new File(this._fileToDelete.getPath() + string + "." + ++n);
        }
        if (!this._fileToDelete.renameTo(file)) {
            throw new TaskFailedException(UpdateArb.format(147, this._fileToDelete.getPath(), file.getPath()));
        }
        this._backupFile = file;
    }

    public void rollback(TaskContext taskContext) throws TaskFailedException {
        if (this._fileToDelete.exists()) {
            throw new TaskFailedException("Unable to restore original file " + this._fileToDelete + " because a new file exists in its place.");
        }
        if (!this._backupFile.renameTo(this._fileToDelete)) {
            throw new TaskFailedException("Failed to restore deleted file " + this._fileToDelete + ": a backup is in " + this._backupFile);
        }
    }

    public void commit(TaskContext taskContext) throws TaskFailedException {
        if (!this._backupFile.delete()) {
            throw new TaskFailedException("Backup file " + this._backupFile + " could not be deleted.");
        }
    }
}

