/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.CreateDirectory;
import oracle.ideimpl.webupdate.task.DeleteFile;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;
import oracle.ideimpl.webupdate.task.TaskStack;
import oracle.ideimpl.webupdate.task.UnzipTask;

public class InstallExtensionTask
extends AtomicTask {
    private static final String KEY_ZIP = "extensionZip";
    private static final String KEY_DESTINATION = "destinationDir";
    private static final String KEY_DELETE_ZIP = "deleteZip";
    private static final String META_INF_PATTERN = "^meta-inf.*";
    private TaskStack _tasks;

    public InstallExtensionTask() {
    }

    public InstallExtensionTask(String string, String string2, boolean bl) {
        this.getProperties().putString(KEY_ZIP, string);
        this.getProperties().putString(KEY_DESTINATION, string2);
        this.getProperties().putBoolean(KEY_DELETE_ZIP, bl);
    }

    public void perform(TaskContext taskContext) throws TaskFailedException {
        this._tasks = new TaskStack();
        String string = this.getProperties().getString(KEY_ZIP);
        String string2 = this.getProperties().getString(KEY_DESTINATION);
        boolean bl = this.getProperties().getBoolean(KEY_DELETE_ZIP);
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new TaskFailedException(UpdateArb.format(148, file.getPath()));
        }
        File file2 = new File(string2);
        this._tasks.performTask(new CreateDirectory(file2), taskContext);
        UnzipTask unzipTask = new UnzipTask(file, file2);
        unzipTask.addSkipPattern(META_INF_PATTERN);
        this._tasks.performTask(unzipTask, taskContext);
        if (bl) {
            this._tasks.performTask(new DeleteFile(file), taskContext);
        }
    }

    public void rollback(TaskContext taskContext) throws TaskFailedException {
        if (this._tasks == null) {
            throw new IllegalStateException("Cannot rollback");
        }
        this._tasks.rollbackTasks(taskContext);
    }

    public void commit(TaskContext taskContext) throws TaskFailedException {
        this._tasks.commitTasks(taskContext);
    }
}

