/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

public class ReadPropertiesFile
extends AtomicTask {
    private final File _file;
    private Properties _properties;

    public ReadPropertiesFile(File file) {
        this._file = file;
    }

    public void perform(TaskContext taskContext) throws TaskFailedException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(this._file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                this._properties = properties;
            }
            catch (IOException iOException) {
                throw new TaskFailedException("Failed to read properties file " + this._file);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    throw new TaskFailedException("Failed to close stream for " + this._file);
                }
            }
        }
    }

    public Properties getLoadedProperties() {
        return this._properties;
    }

    public void rollback(TaskContext taskContext) throws TaskFailedException {
        this._properties = null;
    }
}

