/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.CreateFile;
import oracle.ideimpl.webupdate.task.ReadPropertiesFile;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;
import oracle.ideimpl.webupdate.task.TaskStack;
import oracle.ideimpl.webupdate.task.WritePropertiesFile;

public class ScheduleHookTask
extends AtomicTask {
    private static final String KEY_HOOK_CLASS = "hookClass";
    private static final String KEY_HOOK_REGISTRY_FILE = "hookRegistry";
    private TaskStack _tasks;

    public ScheduleHookTask() {
    }

    public ScheduleHookTask(String string, String string2) {
        this.getProperties().putString(KEY_HOOK_CLASS, string);
        this.getProperties().putString(KEY_HOOK_REGISTRY_FILE, string2);
    }

    public void perform(TaskContext taskContext) throws TaskFailedException {
        this._tasks = new TaskStack();
        String string = this.getProperties().getString(KEY_HOOK_CLASS);
        String string2 = this.getProperties().getString(KEY_HOOK_REGISTRY_FILE);
        File file = new File(string2);
        if (!file.exists()) {
            this._tasks.performTask(new CreateFile(file), taskContext);
        }
        ReadPropertiesFile readPropertiesFile = new ReadPropertiesFile(file);
        this._tasks.performTask(readPropertiesFile, taskContext);
        Properties properties = readPropertiesFile.getLoadedProperties();
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        properties2.put(string, "");
        this._tasks.performTask(new WritePropertiesFile(file, properties, properties2), taskContext);
    }

    public void rollback(TaskContext taskContext) throws TaskFailedException {
        if (this._tasks != null) {
            throw new IllegalStateException("Cannot rollback");
        }
        this._tasks.rollbackTasks(taskContext);
    }

    public void commit(TaskContext taskContext) throws TaskFailedException {
        this._tasks.commitTasks(taskContext);
    }
}

