/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.util.ArrayList;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.InconsistentStateException;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

final class TaskStack {
    private final ArrayList _tasks;

    void $init$() {
        this._tasks = new ArrayList();
    }

    public void performTask(AtomicTask atomicTask, TaskContext taskContext) throws TaskFailedException {
        try {
            this._tasks.add(atomicTask);
            atomicTask.perform(taskContext);
        }
        catch (RuntimeException runtimeException) {
            throw new TaskFailedException("A runtime exception occurred while executing a task.", runtimeException);
        }
    }

    public void rollbackTasks(TaskContext taskContext) throws InconsistentStateException {
        int n = this._tasks.size() - 1;
        while (n >= 0) {
            AtomicTask atomicTask = null;
            try {
                atomicTask = (AtomicTask)this._tasks.get(n);
                atomicTask.rollback(taskContext);
            }
            catch (Exception exception) {
                throw new InconsistentStateException("Failed to rollback task: " + String.valueOf(atomicTask), exception);
            }
            --n;
        }
    }

    public void commitTasks(TaskContext taskContext) throws TaskFailedException {
        for (AtomicTask atomicTask : this._tasks) {
            atomicTask.commit(taskContext);
        }
    }

    TaskStack() {
        this.$init$();
    }
}

