/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.ide.util.Pair;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

final class UnzipTask
extends AtomicTask {
    private static final Logger LOG = Logger.getLogger(UnzipTask.class.getName());
    private final File _zipFile;
    private final File _destinationDir;
    private final ArrayList _backedUpFiles;
    private final ArrayList _createdDirectories;
    private final ArrayList _createdFiles;
    private final ArrayList _skipPatterns;

    void $init$() {
        this._backedUpFiles = new ArrayList();
        this._createdDirectories = new ArrayList();
        this._createdFiles = new ArrayList();
        this._skipPatterns = new ArrayList();
    }

    UnzipTask(File file, File file2) {
        this.$init$();
        this._zipFile = file;
        this._destinationDir = file2;
    }

    void addSkipPattern(String string) {
        this._skipPatterns.add(Pattern.compile(string.toLowerCase()));
    }

    private boolean isSkipped(ZipEntry zipEntry) {
        String string = zipEntry.getName().toLowerCase();
        for (Pattern pattern : this._skipPatterns) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform(TaskContext taskContext) throws TaskFailedException {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(this._zipFile);
        }
        catch (IOException iOException) {
            throw new TaskFailedException(UpdateArb.format(148, this._zipFile.getPath()));
        }
        try {
            int n = 0;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                double d = (double)n / (double)zipFile.size();
                taskContext.getProgress().setPercentProgress(d);
                ++n;
                this.pause();
                if (this.isSkipped(zipEntry)) continue;
                File file = new File(this._destinationDir + File.separator + zipEntry.getName());
                if (file.exists() && !file.isDirectory()) {
                    if (!taskContext.confirmOverwrite(file)) {
                        throw new TaskFailedException(UpdateArb.getString(150));
                    }
                    File file2 = new File(file + ".backup");
                    while (file2.exists()) {
                        int n2 = (int)(Math.random() * 99999.0);
                        file2 = new File(file + ".backup." + n2);
                    }
                    if (!file.renameTo(file2)) throw new TaskFailedException(UpdateArb.format(151, file.getPath(), file2.getPath()));
                    this._backedUpFiles.add(new Pair(file, file2));
                } else if (!file.exists() && zipEntry.isDirectory() && !this.mkdirs(file)) {
                    throw new TaskFailedException(UpdateArb.format(145, file.getPath()));
                }
                if (zipEntry.isDirectory()) continue;
                if (!this.mkdirs(file.getParentFile())) {
                    throw new TaskFailedException(UpdateArb.format(145, file.getParentFile().getPath()));
                }
                try {
                    if (!file.createNewFile()) throw new IOException("createNewFile() returned false.");
                    this._createdFiles.add(file);
                }
                catch (IOException iOException) {
                    throw new TaskFailedException(UpdateArb.format(152, file.getPath()), iOException);
                }
                FileOutputStream fileOutputStream = null;
                try {
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        this.copy(zipFile.getInputStream(zipEntry), fileOutputStream);
                    }
                    catch (IOException iOException) {
                        throw new TaskFailedException(UpdateArb.format(153, file.getPath()), iOException);
                    }
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
            taskContext.getProgress().setPercentProgress(1.0);
            LOG.log(Level.INFO, "Extracted " + this._zipFile + " to " + this._destinationDir);
            return;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    private boolean mkdirs(File file) {
        boolean bl;
        if (file.isDirectory()) {
            return true;
        }
        File file2 = file.getParentFile();
        if (!file2.exists() && !(bl = this.mkdirs(file2))) {
            return false;
        }
        if (file.mkdir()) {
            this._createdDirectories.add(file);
            return true;
        }
        return false;
    }

    public void rollback(TaskContext taskContext) throws TaskFailedException {
        for (File file : this._createdFiles) {
            if (file.delete()) continue;
            throw new TaskFailedException(UpdateArb.format(146, file.getPath()));
        }
        Collections.reverse(this._createdDirectories);
        for (File file : this._createdDirectories) {
            if (file.delete()) continue;
            throw new TaskFailedException(UpdateArb.format(146, file.getPath()));
        }
        for (Pair pair : this._backedUpFiles) {
            File file = (File)pair.getFirst();
            File file2 = (File)pair.getSecond();
            if (file2.renameTo(file)) continue;
            throw new TaskFailedException(UpdateArb.format(154, file2.getPath(), file.getPath()));
        }
    }
}

