/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

public class WritePropertiesFile
extends AtomicTask {
    private final File _file;
    private final Properties _oldProperties;
    private final Properties _newProperties;
    private boolean _wrote;

    public WritePropertiesFile(File file, Properties properties, Properties properties2) {
        this._file = file;
        this._oldProperties = properties;
        this._newProperties = properties2;
    }

    public void perform(TaskContext taskContext) throws TaskFailedException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(this._file);
                this._newProperties.store(fileOutputStream, "");
                this._wrote = true;
            }
            catch (IOException iOException) {
                throw new TaskFailedException("Failed to write properties file " + this._file);
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    throw new TaskFailedException("Failed to write properties file " + this._file);
                }
            }
        }
    }

    public void rollback(TaskContext taskContext) throws TaskFailedException {
        if (this._wrote) {
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(this._file);
                    this._oldProperties.store(fileOutputStream, "");
                    this._wrote = false;
                }
                catch (IOException iOException) {
                    throw new TaskFailedException("Failed to write properties file " + this._file);
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new TaskFailedException("Failed to write properties file " + this._file);
                    }
                }
            }
        }
    }
}

