/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.ideimpl.webupdate.wizard.NiceListActionEvent;
import oracle.ideimpl.webupdate.wizard.NiceListActionListener;
import oracle.ideimpl.webupdate.wizard.NiceListRenderer;

public class NiceList
extends JList {
    private final Collection _listeners = new ArrayList();

    public NiceList() {
        Listener listener = new Listener(null);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addKeyListener(listener);
    }

    public void addListActionListener(NiceListActionListener niceListActionListener) {
        this._listeners.add(niceListActionListener);
    }

    public void removeListActionListener(NiceListActionListener niceListActionListener) {
        this._listeners.remove(niceListActionListener);
    }

    private void fireListActionEvent(NiceListActionEvent niceListActionEvent) {
        if (!this._listeners.isEmpty()) {
            NiceListActionListener[] niceListActionListenerArray = this._listeners.toArray(new NiceListActionListener[this._listeners.size()]);
            int n = 0;
            while (n < niceListActionListenerArray.length) {
                niceListActionListenerArray[n].listActionPerformed(niceListActionEvent);
                ++n;
            }
        }
    }

    private void fireCheckBoxAction(int n) {
        if (!this._listeners.isEmpty()) {
            this.fireListActionEvent(new NiceListActionEvent(this, 0, n));
        }
    }

    private void fireHyperLinkAction(int n) {
        if (!this._listeners.isEmpty()) {
            this.fireListActionEvent(new NiceListActionEvent(this, 1, n));
        }
    }

    static void mav$fireCheckBoxAction(NiceList niceList, int n) {
        niceList.fireCheckBoxAction(n);
    }

    static void mav$fireHyperLinkAction(NiceList niceList, int n) {
        niceList.fireHyperLinkAction(n);
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener,
    KeyListener {
        private int _lastCheckBoxHitRow;
        private int _lastHyperlinkHitRow;

        void $init$() {
            this._lastCheckBoxHitRow = -1;
            this._lastHyperlinkHitRow = -1;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ListCellRenderer listCellRenderer = NiceList.this.getCellRenderer();
            if (listCellRenderer instanceof NiceListRenderer && mouseEvent.getButton() == 1) {
                int n;
                NiceListRenderer niceListRenderer = (NiceListRenderer)listCellRenderer;
                int n2 = niceListRenderer.testCheckBoxHit(NiceList.this, mouseEvent.getPoint());
                if (n2 >= 0) {
                    this._lastCheckBoxHitRow = n2;
                }
                if ((n = niceListRenderer.testHyperLinkHit(NiceList.this, mouseEvent.getPoint())) >= 0) {
                    this._lastHyperlinkHitRow = n;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ListCellRenderer listCellRenderer = NiceList.this.getCellRenderer();
            if (listCellRenderer instanceof NiceListRenderer) {
                if (mouseEvent.getButton() == 1) {
                    int n;
                    int n2;
                    NiceListRenderer niceListRenderer = (NiceListRenderer)listCellRenderer;
                    if (this._lastCheckBoxHitRow >= 0 && (n2 = niceListRenderer.testCheckBoxHit(NiceList.this, mouseEvent.getPoint())) == this._lastCheckBoxHitRow) {
                        NiceList.mav$fireCheckBoxAction(NiceList.this, n2);
                    }
                    if (this._lastHyperlinkHitRow >= 0 && (n = niceListRenderer.testHyperLinkHit(NiceList.this, mouseEvent.getPoint())) == this._lastHyperlinkHitRow) {
                        NiceList.mav$fireHyperLinkAction(NiceList.this, n);
                    }
                }
                this._lastCheckBoxHitRow = -1;
                this._lastHyperlinkHitRow = -1;
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            int[] nArray;
            if (keyEvent.getKeyCode() == 32 && (nArray = NiceList.this.getSelectedIndices()) != null && nArray.length > 0) {
                int n = 0;
                while (n < nArray.length) {
                    int n2 = nArray[n];
                    NiceList.mav$fireCheckBoxAction(NiceList.this, n2);
                    ++n;
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            NiceListRenderer niceListRenderer = (NiceListRenderer)NiceList.this.getCellRenderer();
            int n = niceListRenderer.testHyperLinkHit(NiceList.this, mouseEvent.getPoint());
            if (n >= 0) {
                NiceList.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                NiceList.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        private Listener() {
            this.$init$();
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

