/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import oracle.ide.IdeUIManager;
import oracle.javatools.controls.HyperlinkButton;

public abstract class NiceListRenderer
extends JPanel
implements ListCellRenderer {
    private final JCheckBox _checkBox;
    private final JLabel _titleLabel;
    private final JLabel _descriptionLabel;
    private final JLabel _descriptionLabel2;
    private final JPanel _indicatorsPanel;
    private final JLabel _indicatorLabel;
    private final HyperlinkButton _hyperlink;
    private boolean _selected;
    private static final Color BACKGROUND_COLOR = new Color(251, 251, 251);
    private boolean _twoLineDescription;
    private AccessibleContext _accessibleContext;

    void $init$() {
        this._checkBox = new JCheckBox();
        this._titleLabel = new JLabel();
        this._descriptionLabel = new JLabel();
        this._descriptionLabel2 = new JLabel();
        this._indicatorsPanel = new JPanel();
        this._indicatorLabel = new JLabel();
        this._hyperlink = new HyperlinkButton();
        this._twoLineDescription = false;
    }

    public NiceListRenderer() {
        this.$init$();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this._checkBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this._titleLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this._indicatorsPanel, gridBagConstraints);
        this._indicatorsPanel.setOpaque(false);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.add((Component)this._descriptionLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.add((Component)this._hyperlink, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.add((Component)this._descriptionLabel2, gridBagConstraints);
        this._descriptionLabel2.setVisible(this._twoLineDescription);
        this._titleLabel.setFont(this._titleLabel.getFont().deriveFont(1));
        this._checkBox.setOpaque(false);
        this._checkBox.setMargin(new Insets(0, 0, 0, 0));
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(200, 200, 200)));
        this.setOpaque(false);
        this.updateUI();
        this._indicatorsPanel.setLayout(new BoxLayout(this._indicatorsPanel, 0));
        this._indicatorsPanel.add(this._indicatorLabel);
    }

    public void setTwoLineDescription(boolean bl) {
        this._twoLineDescription = bl;
        this._descriptionLabel2.setVisible(bl);
        this.invalidate();
        this.validate();
    }

    public int testCheckBoxHit(JList jList, Point point) {
        return this.getRendererRow(jList, point, this._checkBox);
    }

    public int testHyperLinkHit(JList jList, Point point) {
        return this.getRendererRow(jList, point, (Component)this._hyperlink);
    }

    private int getRendererRow(JList jList, Point point, Component component) {
        int n = jList.locationToIndex(point);
        if (n >= 0) {
            Point point2 = jList.indexToLocation(n);
            Point point3 = new Point(point.x - point2.x, point.y - point2.y);
            Component component2 = this.getListCellRendererComponent(jList, jList.getModel().getElementAt(n), n, false, true);
            if (component.getBounds().contains(point3)) {
                return n;
            }
        }
        return -1;
    }

    public void paintComponent(Graphics graphics) {
        if (this._selected) {
            GradientPaint gradientPaint = new GradientPaint((float)this.getWidth() / 2.0f, 0.0f, IdeUIManager.getActiveTitleGradientLightColor(), (float)this.getWidth() / 2.0f, this.getHeight(), IdeUIManager.getActiveTitleGradientDarkColor());
            ((Graphics2D)graphics).setPaint(gradientPaint);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(graphics);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        boolean bl3 = this._selected = jList.isEnabled() && bl;
        Color color = jList.isEnabled() ? (this._selected ? IdeUIManager.getActiveTitleForegroundColor() : IdeUIManager.getInactiveTitleForegroundColor()) : UIManager.getColor("textInactiveText");
        this._titleLabel.setForeground(color);
        this._descriptionLabel.setForeground(color);
        this._titleLabel.setText(this.getTitle(object));
        String string = this.getDescription(object);
        this._descriptionLabel.setText(string == null || string.length() == 0 ? " " : string);
        this._descriptionLabel2.setText(this.getSecondDescription(object));
        this._checkBox.setSelected(this.isItemSelected(object));
        this._checkBox.setEnabled(jList.isEnabled());
        this._hyperlink.setText(this.getHyperLinkText(object));
        Icon icon = this.getIndicator(object);
        this._indicatorLabel.setIcon(icon);
        if (jList.isEnabled()) {
            this.setBackground(this.getBackgroundColor(object));
        } else {
            this.setBackground(UIManager.getColor("control"));
        }
        Container container = jList.getParent();
        int n2 = container != null && container instanceof JViewport ? ((JViewport)container).getExtentSize().width : jList.getWidth();
        this.setPreferredSize(new Dimension(n2, this.getPreferredSize().height));
        return this;
    }

    protected Color getBackgroundColor(Object object) {
        return BACKGROUND_COLOR;
    }

    protected abstract String getTitle(Object var1);

    protected abstract String getDescription(Object var1);

    protected String getSecondDescription(Object object) {
        return null;
    }

    protected abstract boolean isItemSelected(Object var1);

    protected String getHyperLinkText(Object object) {
        return "";
    }

    protected Icon getIndicator(Object object) {
        return null;
    }

    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new AccessibleNiceListRenderer(null);
        }
        return this._accessibleContext;
    }

    static JCheckBox ra$_checkBox(NiceListRenderer niceListRenderer) {
        return niceListRenderer._checkBox;
    }

    static JLabel ra$_titleLabel(NiceListRenderer niceListRenderer) {
        return niceListRenderer._titleLabel;
    }

    static JLabel ra$_descriptionLabel(NiceListRenderer niceListRenderer) {
        return niceListRenderer._descriptionLabel;
    }

    static JLabel ra$_descriptionLabel2(NiceListRenderer niceListRenderer) {
        return niceListRenderer._descriptionLabel2;
    }

    private class AccessibleNiceListRenderer
    extends JComponent.AccessibleJComponent {
        public String getAccessibleName() {
            return NiceListRenderer.ra$_titleLabel(NiceListRenderer.this).getText() + " " + NiceListRenderer.ra$_descriptionLabel(NiceListRenderer.this).getText() + " " + NiceListRenderer.ra$_descriptionLabel2(NiceListRenderer.this).getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (NiceListRenderer.this.isFocusOwner()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (NiceListRenderer.ra$_checkBox(NiceListRenderer.this).isSelected()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        private AccessibleNiceListRenderer() {
            super(NiceListRenderer.this);
        }

        AccessibleNiceListRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

