/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.URLHyperlinkButton;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.UpdateInfo;

final class UpdateInfoPanel
extends JPanel {
    private final JLabel _updateName;
    private final JLabel _creatorName;
    private final URLHyperlinkButton _creatorUrl;
    private final JLabel _descriptionLabel;
    private final JTextArea _descriptionArea;
    private final JLabel _infoLabel;
    private UpdateInfo _update;

    void $init$() {
        this._updateName = new JLabel();
        this._creatorName = new JLabel();
        this._creatorUrl = new URLHyperlinkButton();
        this._descriptionLabel = new JLabel();
        this._descriptionArea = new JTextArea();
        this._infoLabel = new JLabel();
    }

    UpdateInfoPanel() {
        this.$init$();
        this._descriptionArea.setRows(5);
        this._descriptionArea.setColumns(40);
        this._descriptionArea.setEditable(false);
        this._descriptionArea.setOpaque(false);
        this._descriptionArea.setLineWrap(true);
        this._descriptionArea.setWrapStyleWord(true);
        this.resControls();
        this.layoutControls();
    }

    private void resControls() {
        ResourceUtils.resLabel(this._descriptionLabel, this._descriptionArea, UpdateArb.getString(123));
        ResourceUtils.resButton((AbstractButton)((Object)this._creatorUrl), UpdateArb.getString(124));
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._updateName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._creatorName, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)((Object)this._creatorUrl), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._descriptionLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JScrollPane(this._descriptionArea), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this._infoLabel, gridBagConstraints);
    }

    public void setUpdate(UpdateInfo updateInfo) {
        this._update = updateInfo;
        this._updateName.setText(UpdateArb.format(125, updateInfo.getName(), updateInfo.getVersion()));
        this._creatorUrl.setVisible((updateInfo.getAuthorURL() == null || updateInfo.getAuthorURL().trim().length() == 0 || "null".equals(updateInfo.getAuthorURL())) ^ true);
        if (updateInfo.getAuthorURL() != null) {
            this._creatorUrl.setURL(URLFactory.newURL(updateInfo.getAuthorURL()));
        }
        this._creatorName.setText(UpdateArb.format(126, updateInfo.getAuthor()));
        if (updateInfo.isExtension()) {
            if (updateInfo.isNew()) {
                this._infoLabel.setText(UpdateArb.getString(128));
            } else {
                Extension extension = ExtensionRegistry.getExtensionRegistry().findExtension(updateInfo.getID());
                this._infoLabel.setText(UpdateArb.format(129, extension.getName(), extension.getVersion()));
            }
        } else {
            this._infoLabel.setText(UpdateArb.getString(127));
        }
        this._descriptionArea.setText(updateInfo.getDescription());
    }

    public void runDialog(Component component, UpdateInfo updateInfo) {
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)UpdateArb.format(130, updateInfo.getName()), (int)1);
        jEWTDialog.setContent((Component)this);
        jEWTDialog.setOKButtonText(UpdateArb.getString(131));
        jEWTDialog.setInitialFocus((Component)this._descriptionArea);
        this.setUpdate(updateInfo);
        jEWTDialog.runDialog();
    }
}

