/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.dialogs.ExceptionDialog;

final class UpdateLicensePage
extends UpdateWizardPage {
    private final JMultiLineLabel _hintText;
    private final JLabel _title;
    private final JEditorPane _licensePane;
    private final JScrollPane _licenseScroll;
    private final JButton _agree;
    private List _updates;
    private int _listPos;
    private boolean _errorOccurred;

    void $init$() {
        this._hintText = new JMultiLineLabel();
        this._title = new JLabel();
        this._licensePane = new JEditorPane();
        this._licenseScroll = new JScrollPane();
        this._agree = new JButton();
        this._errorOccurred = false;
    }

    UpdateLicensePage() {
        this.$init$();
        this.resControls();
        this.layoutControls();
        this.installListeners();
        this._licenseScroll.getViewport().add(this._licensePane);
        this._licensePane.setEditable(false);
    }

    private void resControls() {
        this._hintText.setText(UpdateArb.getString(60));
        ResourceUtils.resLabel(this._title, this._licensePane, UpdateArb.getString(61));
        ResourceUtils.resButton(this._agree, UpdateArb.getString(64));
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_HINT;
        this.add((Component)((Object)this._hintText), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        this.add((Component)this._title, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this._licenseScroll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this._agree, gridBagConstraints);
    }

    private void installListeners() {
        this._agree.addActionListener(new Listener(null));
    }

    public Component getInitialFocus() {
        return this._agree;
    }

    protected void pageSelected(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardUpdateExpectedTransition(this.getExitTransition());
        this._agree.setEnabled(false);
        this._errorOccurred = false;
        if (traversableContext.getDirection() == 1) {
            try {
                this._hintText.setText(UpdateArb.getString(60));
                this._licenseScroll.setVisible(true);
                this._title.setVisible(true);
                this._agree.setVisible(true);
                this._updates = this.getModel(traversableContext).getUpdatesRequiringAgreement();
                this.selectUpdate(0);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                ExceptionDialog.showExceptionDialog((Component)this, (Throwable)throwable);
                this.error(UpdateArb.format(168, throwable instanceof NullPointerException ? UpdateArb.getString(170) : throwable.getLocalizedMessage()));
                this._errorOccurred = true;
            }
            this.completeValueChanged();
        }
    }

    private void selectUpdate(int n) {
        URL uRL;
        String string;
        int n2;
        String string2;
        this._agree.setEnabled(false);
        if (n >= this._updates.size()) {
            this.completeValueChanged();
            this._hintText.setText(UpdateArb.getString(65));
            this._licenseScroll.setVisible(false);
            this._title.setVisible(false);
            this._agree.setVisible(false);
            this.invalidate();
            this.validate();
            return;
        }
        this._listPos = n;
        UpdateInfo updateInfo = (UpdateInfo)this._updates.get(n);
        if (this._updates.size() == 1) {
            ResourceUtils.resLabel(this._title, this._licensePane, UpdateArb.format(62, new Object[]{updateInfo.getName(), updateInfo.getVersion()}));
        } else {
            ResourceUtils.resLabel(this._title, this._licensePane, UpdateArb.format(63, new Object[]{updateInfo.getName(), updateInfo.getVersion(), String.valueOf(n + 1), String.valueOf(this._updates.size())}));
        }
        if (this.getModel(this.getTraversableContext()).getLocalBundle() != null && updateInfo.getClickThroughURL() != null && updateInfo.getClickThroughURL().indexOf(58) == -1) {
            try {
                String string3 = this.getModel(this.getTraversableContext()).getLocalBundle().getContent(updateInfo.getClickThroughURL());
                if (updateInfo.getClickThroughURL().toLowerCase().indexOf("htm") == -1) {
                    this._licensePane.setContentType("text/plain");
                } else {
                    this._licensePane.setContentType("text/html");
                }
                this._licensePane.setText(string3);
                this._licensePane.setCaretPosition(0);
                if (this._licensePane.getText().trim().length() == 0) {
                    this.error(updateInfo, UpdateArb.getString(169));
                } else {
                    this._agree.setEnabled(true);
                }
                return;
            }
            catch (Exception exception) {
                this.error(updateInfo, UpdateArb.format(68, updateInfo.getClickThroughURL()));
            }
        }
        if ((string2 = updateInfo.getClickThroughURL()).indexOf(58) == -1 && updateInfo.getSourceCenter() != null && (n2 = (string = updateInfo.getSourceCenter().getURL()).lastIndexOf(47)) > 1) {
            string2 = string.substring(0, n2 + 1) + string2;
        }
        if ((uRL = URLFactory.newURL(string2)) == null) {
            this.error(updateInfo, UpdateArb.format(67, updateInfo.getClickThroughURL()));
            return;
        }
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                int n3 = httpURLConnection.getResponseCode();
                if (n3 < 200 || n3 > 299) {
                    if (n3 == 404) {
                        this.error(updateInfo, UpdateArb.format(68, uRL));
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                        return;
                    }
                    this.error(updateInfo, UpdateArb.format(69, String.valueOf(n3), uRL));
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    return;
                }
                this._licensePane.setPage(uRL);
                this._agree.setEnabled(true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.error(updateInfo, iOException.getMessage());
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public Object getExitTransition() {
        UpdateWizardModel updateWizardModel = this.getModel(this.getTraversableContext());
        UpdatePageConditions updatePageConditions = updateWizardModel.getConditions();
        if (updatePageConditions.isSingleUser()) {
            if (updatePageConditions.isLocal()) {
                return "licenseToSummary";
            }
            return "licenseToDownload";
        }
        return "licenseToDlLocation";
    }

    public boolean isComplete() {
        if (this._errorOccurred) {
            return false;
        }
        return this.getModel(this.getTraversableContext()).getUpdatesRequiringAgreement().isEmpty();
    }

    private void error(String string) {
        this.error(null, string);
    }

    private void error(UpdateInfo updateInfo, String string) {
        if (updateInfo != null) {
            this._hintText.setText(UpdateArb.format(66, updateInfo.getName(), string));
        } else {
            this._hintText.setText(string);
        }
        this._licenseScroll.setVisible(false);
        this._title.setVisible(false);
        this._agree.setVisible(false);
    }

    static List ra$_updates(UpdateLicensePage updateLicensePage) {
        return updateLicensePage._updates;
    }

    static int ra$_listPos(UpdateLicensePage updateLicensePage) {
        return updateLicensePage._listPos;
    }

    static void mav$selectUpdate(UpdateLicensePage updateLicensePage, int n) {
        updateLicensePage.selectUpdate(n);
    }

    private class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            UpdateInfo updateInfo = (UpdateInfo)UpdateLicensePage.ra$_updates(UpdateLicensePage.this).get(UpdateLicensePage.ra$_listPos(UpdateLicensePage.this));
            UpdateLicensePage.this.getModel(UpdateLicensePage.this.getTraversableContext()).setLicenseAgreed(updateInfo, true);
            UpdateLicensePage.mav$selectUpdate(UpdateLicensePage.this, UpdateLicensePage.ra$_listPos(UpdateLicensePage.this) + 1);
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

