/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.CheckMasterListRunnable;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.NotABundleException;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.wizard.NiceList;
import oracle.ideimpl.webupdate.wizard.NiceListActionEvent;
import oracle.ideimpl.webupdate.wizard.NiceListActionListener;
import oracle.ideimpl.webupdate.wizard.NiceListRenderer;
import oracle.ideimpl.webupdate.wizard.UpdateCenterPanel;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.resource.CommonIconsUtils;

final class UpdateSourcePage
extends UpdateWizardPage {
    private final JMultiLineLabel _lbHint;
    private final JRadioButton _rbUpdateCenter;
    private final NiceList _lstUpdateCenters;
    private final JButton _btnAddCenter;
    private final JButton _btnRemoveCenter;
    private final JButton _btnEditCenter;
    private final JRadioButton _rbLocalFile;
    private final JLabel _lbFileName;
    private final URLTextField _tfLocalFileName;
    private final JButton _btnBrowse;
    private final JPanel _panProgress;
    private final JProgressBar _pbUpdates;
    private final JLabel _lbProgress;
    private final JLabel _lbError;
    private final HyperlinkButton _hlError;
    private final GridBagLayout _layout;
    private SimpleListModel _listModel;
    private boolean _checkedMasterList;
    private boolean _firstTime;
    private boolean _firstTimeForAutoupdate;
    private CheckMasterListRunnable _masterListChecker;
    private ActionListener _errorDetailsListener;
    private LocalUpdateBundle _localBundle;
    private boolean _isSaved;

    void $init$() {
        this._lbHint = new JMultiLineLabel();
        this._rbUpdateCenter = new JRadioButton();
        this._lstUpdateCenters = new NiceList();
        this._btnAddCenter = new JButton();
        this._btnRemoveCenter = new JButton();
        this._btnEditCenter = new JButton();
        this._rbLocalFile = new JRadioButton();
        this._lbFileName = new JLabel();
        this._tfLocalFileName = new 5();
        this._btnBrowse = new JButton();
        this._panProgress = new JPanel();
        this._pbUpdates = new JProgressBar();
        this._lbProgress = new JLabel();
        this._lbError = new JLabel();
        this._hlError = new HyperlinkButton();
        this._layout = new GridBagLayout();
        this._checkedMasterList = false;
        this._firstTime = true;
        this._firstTimeForAutoupdate = true;
        this._masterListChecker = null;
        this._isSaved = false;
    }

    UpdateSourcePage() {
        this.$init$();
        this.resControls();
        this.layoutControls();
        this.installListeners();
        4 var1_1 = new 4();
        this._lstUpdateCenters.setCellRenderer(var1_1);
    }

    private void resControls() {
        this._lbHint.setText(UpdateArb.getString(96));
        ResourceUtils.resButton(this._rbUpdateCenter, UpdateArb.getString(97));
        ResourceUtils.resButton(this._btnAddCenter, UpdateArb.getString(98));
        ResourceUtils.resButton(this._btnEditCenter, UpdateArb.getString(100));
        ResourceUtils.resButton(this._btnRemoveCenter, UpdateArb.getString(99));
        ResourceUtils.resButton(this._rbLocalFile, UpdateArb.getString(101));
        ResourceUtils.resLabel(this._lbFileName, (Component)((Object)this._tfLocalFileName), UpdateArb.getString(102));
        ResourceUtils.resButton(this._btnBrowse, UpdateArb.getString(103));
        this._pbUpdates.setIndeterminate(true);
        this._tfLocalFileName.setDirectoryOnly(false);
        this._tfLocalFileName.setChooserInit(new 3());
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_HINT;
        this.add((Component)((Object)this._lbHint), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        this.add((Component)this._rbUpdateCenter, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 24, 5, 0);
        this.add((Component)new JScrollPane(this._lstUpdateCenters), gridBagConstraints);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setOrientation(1);
        buttonBar.setAlignment(1);
        buttonBar.add((Component)this._btnAddCenter);
        buttonBar.add((Component)this._btnRemoveCenter);
        buttonBar.add((Component)this._btnEditCenter);
        gridBagConstraints.gridx += 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)buttonBar, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 5, 0);
        this._panProgress.setLayout(new BorderLayout(5, 0));
        this._panProgress.setVisible(false);
        this.add((Component)this._panProgress, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        this.add((Component)this._rbLocalFile, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 24, 0, 12);
        this.add((Component)this._lbFileName, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_ZERO;
        this.add((Component)((Object)this._tfLocalFileName), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this._btnBrowse, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbUpdateCenter);
        buttonGroup.add(this._rbLocalFile);
    }

    private void installListeners() {
        Listener listener = new Listener(null);
        this._rbUpdateCenter.addActionListener(listener);
        this._rbLocalFile.addActionListener(listener);
        this._btnBrowse.addActionListener(listener);
        this._btnAddCenter.addActionListener(listener);
        this._btnEditCenter.addActionListener(listener);
        this._btnRemoveCenter.addActionListener(listener);
        this._tfLocalFileName.getDocument().addDocumentListener(listener);
        this._lstUpdateCenters.getSelectionModel().addListSelectionListener(listener);
        this._lstUpdateCenters.addListActionListener(listener);
        this._lstUpdateCenters.addKeyListener(listener);
        this._rbUpdateCenter.setSelected(true);
        this.updateEnabledControls();
    }

    public boolean isComplete() {
        if (this._rbUpdateCenter.isSelected()) {
            if (this._masterListChecker != null && this._masterListChecker.isRunning()) {
                return false;
            }
            int n = 0;
            while (n < this._lstUpdateCenters.getModel().getSize()) {
                UpdateCenter updateCenter = (UpdateCenter)this._lstUpdateCenters.getModel().getElementAt(n);
                if (updateCenter.isEnabled()) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return this._tfLocalFileName.getText().trim().length() > 0;
    }

    public Component getInitialFocus() {
        return this._rbUpdateCenter;
    }

    public void pageSelected(TraversableContext traversableContext) {
        this._isSaved = false;
        if (this._firstTimeForAutoupdate && this.getModel(traversableContext).isSourceSkipped()) {
            SwingUtilities.invokeLater(new 2());
            this._firstTimeForAutoupdate = false;
            return;
        }
        if (this._firstTime) {
            this._listModel = new SimpleListModel(this.getModel(traversableContext).getAllUpdateCenters());
            this._lstUpdateCenters.setModel(this._listModel);
            this._firstTime = false;
        }
        if (!this._checkedMasterList) {
            this.checkMasterList(traversableContext);
            this._checkedMasterList = true;
        }
    }

    private void checkMasterList(TraversableContext traversableContext) {
        this._masterListChecker = new 1(this, this.getModel(traversableContext).getUpdateManager().getMasterServerURL(), traversableContext);
        ProgressMonitor progressMonitor = new ProgressMonitor(null);
        this._masterListChecker.setMonitor(progressMonitor);
        Thread thread = new Thread((Runnable)this._masterListChecker, "Update Master List Checker");
        thread.start();
    }

    private boolean proxyPrompt() {
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        ProxySettingsPanel proxySettingsPanel = new ProxySettingsPanel();
        proxySettingsPanel.setProxyOptions(proxyOptions);
        MessagePanel messagePanel = new MessagePanel();
        messagePanel.setMessageType(4);
        messagePanel.setMessageText(UpdateArb.getString(171));
        messagePanel.addMessageComponent((Component)proxySettingsPanel);
        HelpUtils.setHelpID((JComponent)messagePanel, (String)"f1_idewideupdatetimeout_html");
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)this, (String)UpdateArb.getString(172), (int)7);
        jEWTDialog.setContent((Component)messagePanel);
        try {
            if (jEWTDialog.runDialog()) {
                ProxyOptions.setProxyOptions(proxySettingsPanel.getProxyOptions());
                boolean bl = true;
                jEWTDialog.dispose();
                return bl;
            }
            boolean bl = false;
            jEWTDialog.dispose();
            return bl;
        }
        catch (Throwable throwable) {
            jEWTDialog.dispose();
            throw throwable;
        }
    }

    private void masterListUpdateError(TraversableContext traversableContext, Throwable throwable) {
        if (this.proxyPrompt()) {
            this.checkMasterList(traversableContext);
            return;
        }
        this._panProgress.removeAll();
        this._panProgress.add((Component)this._lbError, "West");
        this._panProgress.add((Component)this._hlError, "East");
        this._lbError.setIcon(CommonIconsUtils.getWarningIcon());
        this._lbError.setText(UpdateArb.getString(111));
        this._hlError.setText(UpdateArb.getString(112));
        if (this._errorDetailsListener != null) {
            this._hlError.removeActionListener(this._errorDetailsListener);
        }
        this._errorDetailsListener = new ErrorDetailsListener(throwable);
        this._hlError.addActionListener(this._errorDetailsListener);
        this._panProgress.invalidate();
        this._panProgress.validate();
        this._panProgress.setVisible(true);
    }

    private void processMasterList(TraversableContext traversableContext, List list) {
        UpdateHook updateHook = (UpdateHook)ExtensionRegistry.getExtensionRegistry().getHook(UpdateHook.ELEMENT);
        list.addAll(updateHook.getUpdateCenters());
        for (UpdateCenter updateCenter : list) {
            if (updateCenter.getMasterId() == null) continue;
            UpdateCenter updateCenter2 = this.findCenterByMasterId(updateCenter.getMasterId(), this.getModel(traversableContext).getAllUpdateCenters());
            if (updateCenter2 == null) {
                updateCenter.setEnabled(true);
                this._listModel.addElement((Object)updateCenter);
                continue;
            }
            boolean bl = false;
            if (!updateCenter2.getURL().equals(updateCenter.getURL())) {
                updateCenter2.setURL(updateCenter.getURL());
                bl = true;
            }
            if (!updateCenter2.getName().equals(updateCenter.getName())) {
                updateCenter2.setName(updateCenter.getName());
                bl = true;
            }
            if (updateCenter2.isProtected() != updateCenter.isProtected()) {
                updateCenter2.setProtected(updateCenter.isProtected());
                bl = true;
            }
            if (!bl) continue;
            int n = this.getModel(traversableContext).getAllUpdateCenters().indexOf(updateCenter2);
            this._listModel.changed(n);
        }
        ArrayList<UpdateCenter> arrayList = new ArrayList<UpdateCenter>();
        for (UpdateCenter updateCenter : this.getModel(traversableContext).getAllUpdateCenters()) {
            UpdateCenter updateCenter3;
            if (updateCenter.getMasterId() == null || (updateCenter3 = this.findCenterByMasterId(updateCenter.getMasterId(), list)) != null) continue;
            arrayList.add(updateCenter);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this._listModel.removeElement(iterator.next());
        }
    }

    private UpdateCenter findCenterByMasterId(String string, List list) {
        for (UpdateCenter updateCenter : list) {
            if (!string.equals(updateCenter.getMasterId())) continue;
            return updateCenter;
        }
        return null;
    }

    private boolean haveLicenseAgreement(UpdateBundle updateBundle) {
        if (updateBundle == null) {
            return false;
        }
        for (UpdateInfo updateInfo : updateBundle.getUpdates()) {
            if (updateInfo.getClickThroughURL() == null) continue;
            return true;
        }
        return false;
    }

    public Object getExitTransition() {
        try {
            this.doSave(this.getTraversableContext());
            UpdateWizardModel updateWizardModel = this.getModel(this.getTraversableContext());
            UpdatePageConditions updatePageConditions = new UpdatePageConditions(this._rbLocalFile.isSelected(), this._rbLocalFile.isSelected() && updateWizardModel.getLocalBundle() != null && this.haveLicenseAgreement(updateWizardModel.getLocalBundle().getBundle()), this._rbLocalFile.isSelected() ? updateWizardModel.getLocalBundle().getBundle().getUpdates() : Collections.EMPTY_SET);
            if (updatePageConditions.isLocal()) {
                if (updatePageConditions.isLicense()) {
                    this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition("sourceToLicence");
                    String string = "sourceToLicence";
                    return string;
                }
                if (updatePageConditions.isSingleUser()) {
                    this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition("sourceToSummary");
                    String string = "sourceToSummary";
                    return string;
                }
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition("sourceToDlLocation");
                String string = "sourceToDlLocation";
                return string;
            }
            Object var7_6 = null;
            return var7_6;
        }
        catch (TraversalException traversalException) {
            Object var8_8 = null;
            return var8_8;
        }
    }

    private void doSave(TraversableContext traversableContext) throws TraversalException {
        if (!this._isSaved) {
            if (!this.doValidation(traversableContext)) {
                throw new TraversalException(null);
            }
            this.save(traversableContext);
            this._isSaved = true;
        }
    }

    public final void onExit(TraversableContext traversableContext) throws TraversalException {
        this.doSave(traversableContext);
        this.pageDeselected(traversableContext);
    }

    public void save(TraversableContext traversableContext) {
        try {
            UpdateManager.getInstance().setUpdateCenters(this.getModel(traversableContext).getAllUpdateCenters());
        }
        catch (IOException iOException) {
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)iOException);
        }
        if (this._rbLocalFile.isSelected()) {
            this.getModel(traversableContext).setLocalBundle(this._localBundle);
        } else {
            this.getModel(traversableContext).setLocalBundle(null);
        }
    }

    public boolean doValidation(TraversableContext traversableContext) {
        if (this._rbLocalFile.isSelected()) {
            return this.validateLocalBundle();
        }
        return true;
    }

    private boolean validateLocalBundle() {
        URL uRL = this._tfLocalFileName.getURL();
        if (uRL != null && "file".equals(uRL.getProtocol())) {
            File file = new File(URLFileSystem.getPlatformPathName(uRL));
            try {
                this._localBundle = LocalUpdateBundle.createInstance(file);
                if (this._localBundle.getBundle().getUpdates().size() == 0) {
                    MessageDialog.error((Component)this, (Object)UpdateArb.getString(156), (String)UpdateArb.getString(155), null);
                    boolean bl = false;
                    return bl;
                }
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                for (UpdateInfo updateInfo : this._localBundle.getBundle().getUpdates()) {
                    if (!updateInfo.isNew()) {
                        Version version = extensionRegistry.findExtension(updateInfo.getID()).getVersion();
                        Version version2 = updateInfo.getVersion();
                        int n = version2.compareTo((Object)version);
                        if (n == 0) {
                            MessageDialog.error((Component)this, (Object)UpdateArb.format(158, version2.toString(), updateInfo.getName()), (String)UpdateArb.getString(157), null);
                            boolean bl = false;
                            return bl;
                        }
                        if (n < 0) {
                            MessageDialog.error((Component)this, (Object)UpdateArb.format(160, version2.toString(), updateInfo.getName(), version.toString()), (String)UpdateArb.getString(159), null);
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (this.validateUpdateDependencies(updateInfo)) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (NotABundleException notABundleException) {
                MessageDialog.error((Component)this, (Object)notABundleException.getMessage(), (String)UpdateArb.getString(137), null);
                boolean bl = false;
                return bl;
            }
        }
        MessageDialog.error((Component)this, (Object)UpdateArb.getString(138), (String)UpdateArb.getString(139), null);
        return false;
    }

    private boolean validateUpdateDependencies(UpdateInfo updateInfo) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        Collection collection = updateInfo.getRequiredIds();
        for (String string : collection) {
            Extension extension = extensionRegistry.findExtension(string);
            if (extension == null) {
                MessageDialog.error((Component)this, (Object)UpdateArb.format(135, updateInfo.getName()), (String)UpdateArb.getString(136), null);
                return false;
            }
            boolean bl = CheckUpdatesRunnable.testCompatibleVersion(updateInfo, string, extension.getVersion());
            if (bl) continue;
            MessageDialog.error((Component)this, (Object)UpdateArb.format(135, updateInfo.getName()), (String)UpdateArb.getString(136), null);
            return false;
        }
        return true;
    }

    private void addUpdateCenter() {
        UpdateCenter updateCenter = UpdateCenterPanel.runCreateDialog(this);
        if (updateCenter != null) {
            updateCenter.setEnabled(true);
            this._listModel.addElement((Object)updateCenter);
            this._lstUpdateCenters.setSelectedIndex(this._listModel.getSize() - 1);
            this._lstUpdateCenters.ensureIndexIsVisible(this._listModel.getSize() - 1);
            this.completeValueChanged();
        }
    }

    private void removeUpdateCenter() {
        int[] nArray = this._lstUpdateCenters.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            int n = nArray[0];
            this._listModel.removeIndices(nArray);
            if (this._listModel.getSize() > n) {
                this._lstUpdateCenters.setSelectedIndex(n);
            } else if (this._listModel.getSize() > 0) {
                this._lstUpdateCenters.setSelectedIndex(this._listModel.getSize() - 1);
            }
        }
    }

    private void editUpdateCenter() {
        UpdateCenter updateCenter = (UpdateCenter)this._lstUpdateCenters.getSelectedValue();
        if (UpdateCenterPanel.runEditDialog(this, updateCenter)) {
            int n = this._lstUpdateCenters.getSelectedIndex();
            this._listModel.changed(n);
        }
    }

    private void updateEnabledControls() {
        boolean bl = this._rbUpdateCenter.isSelected();
        if (this.getTraversableContext() != null) {
            if (bl) {
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition("sourceToUpdates");
            } else {
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition("sourceToLicence");
            }
        }
        this._lstUpdateCenters.setEnabled(bl);
        this._lstUpdateCenters.setBackground(bl ? UIManager.getColor("window") : UIManager.getColor("control"));
        Object[] objectArray = this._lstUpdateCenters.getSelectedValues();
        this._btnAddCenter.setEnabled(bl);
        if (!bl || objectArray == null || objectArray.length == 0) {
            this._btnEditCenter.setEnabled(false);
            this._btnRemoveCenter.setEnabled(false);
        } else {
            if (objectArray.length == 1) {
                UpdateCenter updateCenter = (UpdateCenter)objectArray[0];
                this._btnEditCenter.setEnabled(updateCenter.isFromMasterList() ^ true);
            }
            boolean bl2 = true;
            int n = 0;
            while (n < objectArray.length) {
                UpdateCenter updateCenter = (UpdateCenter)objectArray[n];
                if (updateCenter.isFromMasterList()) {
                    bl2 = false;
                    break;
                }
                ++n;
            }
            this._btnRemoveCenter.setEnabled(bl2);
        }
        this._lbFileName.setEnabled(bl ^ true);
        this._tfLocalFileName.setEnabled(bl ^ true);
        this._btnBrowse.setEnabled(bl ^ true);
    }

    private void toggleCenterEnabled(int n) {
        UpdateCenter updateCenter = (UpdateCenter)this._lstUpdateCenters.getModel().getElementAt(n);
        updateCenter.setEnabled(updateCenter.isEnabled() ^ true);
        this._listModel.changed(n);
        this.completeValueChanged();
    }

    static void wa$_masterListChecker(UpdateSourcePage updateSourcePage, CheckMasterListRunnable checkMasterListRunnable) {
        updateSourcePage._masterListChecker = checkMasterListRunnable;
    }

    static void mav$masterListUpdateError(UpdateSourcePage updateSourcePage, TraversableContext traversableContext, Throwable throwable) {
        updateSourcePage.masterListUpdateError(traversableContext, throwable);
    }

    static void mav$processMasterList(UpdateSourcePage updateSourcePage, TraversableContext traversableContext, List list) {
        updateSourcePage.processMasterList(traversableContext, list);
    }

    static void mav$toggleCenterEnabled(UpdateSourcePage updateSourcePage, int n) {
        updateSourcePage.toggleCenterEnabled(n);
    }

    static JButton ra$_btnRemoveCenter(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._btnRemoveCenter;
    }

    static void mav$removeUpdateCenter(UpdateSourcePage updateSourcePage) {
        updateSourcePage.removeUpdateCenter();
    }

    static void mav$updateEnabledControls(UpdateSourcePage updateSourcePage) {
        updateSourcePage.updateEnabledControls();
    }

    static JButton ra$_btnAddCenter(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._btnAddCenter;
    }

    static void mav$addUpdateCenter(UpdateSourcePage updateSourcePage) {
        updateSourcePage.addUpdateCenter();
    }

    static JButton ra$_btnEditCenter(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._btnEditCenter;
    }

    static void mav$editUpdateCenter(UpdateSourcePage updateSourcePage) {
        updateSourcePage.editUpdateCenter();
    }

    static JButton ra$_btnBrowse(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._btnBrowse;
    }

    static URLTextField ra$_tfLocalFileName(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._tfLocalFileName;
    }

    static JLabel ra$_lbProgress(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._lbProgress;
    }

    static JPanel ra$_panProgress(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._panProgress;
    }

    static JProgressBar ra$_pbUpdates(UpdateSourcePage updateSourcePage) {
        return updateSourcePage._pbUpdates;
    }

    final class 5
    extends URLTextField {
        protected URLChooser createChooser(URL uRL) {
            URLChooser uRLChooser = super.createChooser(uRL);
            uRLChooser.setShowJarsAsDirs(false);
            return uRLChooser;
        }
    }

    final class 4
    extends NiceListRenderer {
        public String getTitle(Object object) {
            return ((UpdateCenter)object).getName();
        }

        public String getDescription(Object object) {
            return URLFileSystem.getPlatformPathName(URLFactory.newURL(((UpdateCenter)object).getURL()));
        }

        public boolean isItemSelected(Object object) {
            return ((UpdateCenter)object).isEnabled();
        }
    }

    final class 3
    implements URLChooserInit {
        public void initURLChooser(URLChooser uRLChooser) {
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
            WildcardURLFilter wildcardURLFilter = new WildcardURLFilter("*.zip", false, UpdateArb.getString(116));
            uRLChooser.addChooseableURLFilter(wildcardURLFilter);
            uRLChooser.setURLFilter(wildcardURLFilter);
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            UpdateSourcePage.this.getTraversableContext().getWizardCallbacks().nextPage();
        }
    }

    final class oracle.ideimpl.webupdate.wizard.UpdateSourcePage$1
    extends CheckMasterListRunnable {
        private final /* synthetic */ TraversableContext v$context;
        final /* synthetic */ UpdateSourcePage this$0;

        protected void failed(Throwable throwable) {
            EventQueue.invokeLater(new 2(this, throwable));
        }

        protected void finished(List list) {
            EventQueue.invokeLater(new 1(this, list));
        }

        public oracle.ideimpl.webupdate.wizard.UpdateSourcePage$1(UpdateSourcePage updateSourcePage, String string, TraversableContext traversableContext) {
            this.v$context = traversableContext;
            this.this$0 = updateSourcePage;
            super(string);
        }

        static TraversableContext ra$v$context(oracle.ideimpl.webupdate.wizard.UpdateSourcePage$1 var0) {
            return var0.v$context;
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ Throwable v$t;
            final /* synthetic */ oracle.ideimpl.webupdate.wizard.UpdateSourcePage$1 this$0;

            public void run() {
                UpdateSourcePage.wa$_masterListChecker(this.this$0.this$0, null);
                UpdateSourcePage.mav$masterListUpdateError(this.this$0.this$0, oracle.ideimpl.webupdate.wizard.UpdateSourcePage$1.ra$v$context(this.this$0), this.v$t);
                this.this$0.this$0.completeValueChanged();
            }

            public 2(oracle.ideimpl.webupdate.wizard.UpdateSourcePage$1 var1_1, Throwable throwable) {
                this.v$t = throwable;
                this.this$0 = var1_1;
            }
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ List v$l;
            final /* synthetic */ oracle.ideimpl.webupdate.wizard.UpdateSourcePage$1 this$0;

            public void run() {
                UpdateSourcePage.wa$_masterListChecker(this.this$0.this$0, null);
                UpdateSourcePage.mav$processMasterList(this.this$0.this$0, oracle.ideimpl.webupdate.wizard.UpdateSourcePage$1.ra$v$context(this.this$0), this.v$l);
                this.this$0.this$0.completeValueChanged();
            }

            public 1(oracle.ideimpl.webupdate.wizard.UpdateSourcePage$1 var1_1, List list) {
                this.v$l = list;
                this.this$0 = var1_1;
            }
        }
    }

    private class Listener
    implements NiceListActionListener,
    KeyListener,
    ListSelectionListener,
    ActionListener,
    DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            UpdateSourcePage.this.completeValueChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            UpdateSourcePage.this.completeValueChanged();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            UpdateSourcePage.this.completeValueChanged();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == UpdateSourcePage.ra$_btnAddCenter(UpdateSourcePage.this)) {
                UpdateSourcePage.mav$addUpdateCenter(UpdateSourcePage.this);
            } else if (object == UpdateSourcePage.ra$_btnRemoveCenter(UpdateSourcePage.this)) {
                UpdateSourcePage.mav$removeUpdateCenter(UpdateSourcePage.this);
            } else if (object == UpdateSourcePage.ra$_btnEditCenter(UpdateSourcePage.this)) {
                UpdateSourcePage.mav$editUpdateCenter(UpdateSourcePage.this);
            } else if (object == UpdateSourcePage.ra$_btnBrowse(UpdateSourcePage.this)) {
                UpdateSourcePage.ra$_tfLocalFileName(UpdateSourcePage.this).actionPerformed(actionEvent);
            }
            UpdateSourcePage.this.completeValueChanged();
            UpdateSourcePage.mav$updateEnabledControls(UpdateSourcePage.this);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            UpdateSourcePage.mav$updateEnabledControls(UpdateSourcePage.this);
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                if (UpdateSourcePage.ra$_btnRemoveCenter(UpdateSourcePage.this).isEnabled()) {
                    UpdateSourcePage.mav$removeUpdateCenter(UpdateSourcePage.this);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        public void listActionPerformed(NiceListActionEvent niceListActionEvent) {
            if (niceListActionEvent.getType() == 0) {
                UpdateSourcePage.mav$toggleCenterEnabled(UpdateSourcePage.this, niceListActionEvent.getRow());
            }
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ProgressMonitor
    implements UpdateCenterMonitor {
        public void setMessage(String string) {
            EventQueue.invokeLater(new 3(this, string));
        }

        public void setMaximum(int n) {
        }

        public void setProgress(int n) {
        }

        public void start() {
            EventQueue.invokeLater(new 2());
        }

        public void finish() {
            EventQueue.invokeLater(new 1());
        }

        public boolean isStopped() {
            return false;
        }

        private ProgressMonitor() {
        }

        ProgressMonitor(1 var2_2) {
            this();
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ String v$message;
            final /* synthetic */ ProgressMonitor this$0;

            public void run() {
                UpdateSourcePage.ra$_lbProgress(this.this$0.UpdateSourcePage.this).setText(this.v$message);
                UpdateSourcePage.ra$_panProgress(this.this$0.UpdateSourcePage.this).invalidate();
                UpdateSourcePage.ra$_panProgress(this.this$0.UpdateSourcePage.this).validate();
            }

            public 3(ProgressMonitor progressMonitor, String string) {
                this.v$message = string;
                this.this$0 = progressMonitor;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).add((Component)UpdateSourcePage.ra$_lbProgress(UpdateSourcePage.this), "West");
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).add((Component)UpdateSourcePage.ra$_pbUpdates(UpdateSourcePage.this), "Center");
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).setVisible(true);
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).invalidate();
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).validate();
            }
        }

        final class 1
        implements Runnable {
            public void run() {
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).setVisible(false);
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).invalidate();
                UpdateSourcePage.ra$_panProgress(UpdateSourcePage.this).validate();
            }
        }
    }

    private class ErrorDetailsListener
    implements ActionListener {
        private final Throwable _throwable;

        ErrorDetailsListener(Throwable throwable) {
            this._throwable = throwable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExceptionDialog.showExceptionDialog((Component)UpdateSourcePage.this, (Throwable)this._throwable, (String)UpdateArb.getString(109), (String)UpdateArb.format(110, Ide.getProgramShortName()), null);
        }
    }
}

