/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.task.DeinstallExtensionTask;
import oracle.ideimpl.webupdate.task.InstallExtensionTask;
import oracle.ideimpl.webupdate.task.ScheduleHookTask;
import oracle.ideimpl.webupdate.task.TaskList;
import oracle.ideimpl.webupdate.wizard.DownloadLocationPage;
import oracle.ideimpl.webupdate.wizard.DownloadPage;
import oracle.ideimpl.webupdate.wizard.SummaryPage;
import oracle.ideimpl.webupdate.wizard.UpdateLicensePage;
import oracle.ideimpl.webupdate.wizard.UpdatePage;
import oracle.ideimpl.webupdate.wizard.UpdateSourcePage;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.javatools.dialogs.ExceptionDialog;

public final class UpdateWizard {
    static final String STATE_WELCOME = "welcome";
    static final String STATE_SOURCE = "source";
    static final String STATE_UPDATE = "update";
    static final String STATE_LICENSE = "license";
    static final String STATE_DOWNLOAD_LOCATION = "downloadLocation";
    static final String STATE_DOWNLOAD = "download";
    static final String STATE_SUMMARY = "summary";
    static final String KEY_MODEL = "updateWizardModel";
    static final String TRANS_UPDATES_TO_DOWNLOAD = "updatesToDownload";
    static final String TRANS_UPDATES_TO_DL_LOC = "updatesToDlLocation";
    static final String TRANS_UPDATES_TO_LICENSE = "updatesToLicense";
    static final String TRANS_UPDATES_TO_SUMMARY = "updatesToSummary";
    static final String TRANS_LICENSE_TO_DL_LOC = "licenseToDlLocation";
    static final String TRANS_LICENSE_TO_DOWNLOAD = "licenseToDownload";
    static final String TRANS_LICENSE_TO_SUMMARY = "licenseToSummary";
    static final String TRANS_SOURCE_TO_LICENSE = "sourceToLicence";
    static final String TRANS_SOURCE_TO_DL_LOC = "sourceToDlLocation";
    static final String TRANS_SOURCE_TO_SUMMARY = "sourceToSummary";
    static final String TRANS_SOURCE_TO_UPDATES = "sourceToUpdates";
    static final String TRANS_DL_LOC_TO_SUMMARY = "dlLocationToSummary";
    private String m_welcomeHint;
    private final ImageIcon WIZARD_IMAGE;
    private UpdateManager m_updateManager;
    private UpdateWizardModel m_model;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = UpdateWizard.class.desiredAssertionStatus() ^ true;
    }

    void $init$() {
        this.WIZARD_IMAGE = (ImageIcon)UpdateArb.getIcon(2);
    }

    public UpdateWizard(UpdateManager updateManager) {
        this.$init$();
        this.m_welcomeHint = null;
        this.m_updateManager = updateManager;
    }

    public boolean runWizard(Component component, Context context) {
        UpdateManager.getInstance().getAutomaticCheckForUpdates().uninstallNotificationIcon();
        if (UpdateManager.getInstance().getDeferredUpdatesFile().exists() && !MessageDialog.confirm(component, UpdateArb.format(76, Ide.getProgramShortName()), UpdateArb.getString(75), null)) {
            return false;
        }
        List list = context == null ? null : (List)context.getProperty("autoCfuMasterList");
        boolean bl = !UpdateManager.getInstance().isSingleUserMode() && UpdateManager.getInstance().isGlobalExtensionInstallationAllowed();
        FSMBuilder fSMBuilder = new FSMBuilder();
        if (list == null) {
            Step step = WelcomePanel.newStep(UpdateArb.getString(3), UpdateArb.getString(4), UpdateArb.format(7, Ide.getProgramName()), UpdateWizard.class.getName() + "1013", "f1_idewideupdatewelcome_html");
            fSMBuilder.newStartState(step, STATE_SOURCE);
        }
        Step step = new Step(UpdateArb.getString(95), UpdateSourcePage.class, "f1_idewideupdatesource_html");
        if (list != null) {
            fSMBuilder.newStartState(step, STATE_UPDATE);
        } else {
            fSMBuilder.newState(STATE_SOURCE, step, STATE_UPDATE);
        }
        fSMBuilder.addStateTrans(TRANS_SOURCE_TO_DL_LOC, STATE_DOWNLOAD_LOCATION);
        fSMBuilder.addStateTrans(TRANS_SOURCE_TO_LICENSE, STATE_LICENSE);
        fSMBuilder.addStateTrans(TRANS_SOURCE_TO_SUMMARY, STATE_SUMMARY);
        fSMBuilder.addStateTrans(TRANS_SOURCE_TO_UPDATES, STATE_UPDATE);
        step = new Step(UpdateArb.getString(8), UpdatePage.class, "f1_idewideupdateupdates_html");
        fSMBuilder.newState(STATE_UPDATE, step, bl ? STATE_DOWNLOAD_LOCATION : STATE_DOWNLOAD);
        fSMBuilder.addStateTrans(TRANS_UPDATES_TO_DL_LOC, STATE_DOWNLOAD_LOCATION);
        fSMBuilder.addStateTrans(TRANS_UPDATES_TO_DOWNLOAD, STATE_DOWNLOAD);
        fSMBuilder.addStateTrans(TRANS_UPDATES_TO_LICENSE, STATE_LICENSE);
        fSMBuilder.addStateTrans(TRANS_UPDATES_TO_SUMMARY, STATE_SUMMARY);
        step = new Step(UpdateArb.getString(140), UpdateLicensePage.class, "f1_idewideupdatelicense_html");
        fSMBuilder.newState(STATE_LICENSE, step, bl ? STATE_DOWNLOAD_LOCATION : STATE_DOWNLOAD);
        fSMBuilder.addStateTrans(TRANS_LICENSE_TO_DL_LOC, STATE_DOWNLOAD_LOCATION);
        fSMBuilder.addStateTrans(TRANS_LICENSE_TO_DOWNLOAD, STATE_DOWNLOAD);
        fSMBuilder.addStateTrans(TRANS_LICENSE_TO_SUMMARY, STATE_SUMMARY);
        step = new Step(UpdateArb.getString(20), DownloadLocationPage.class, "f1_idewideupdatedownloadlocation_html");
        fSMBuilder.newState(STATE_DOWNLOAD_LOCATION, step, STATE_DOWNLOAD);
        fSMBuilder.addStateTrans(TRANS_DL_LOC_TO_SUMMARY, STATE_SUMMARY);
        step = new Step(UpdateArb.getString(25), DownloadPage.class, "f1_idewideupdatedownload_html");
        fSMBuilder.newState(STATE_DOWNLOAD, step, STATE_SUMMARY);
        step = new Step(UpdateArb.getString(35), SummaryPage.class, "f1_idewideupdatesummary_html");
        fSMBuilder.newFinalState(STATE_SUMMARY, step);
        try {
            WizardDialog wizardDialog;
            FSM fSM = fSMBuilder.getFSM();
            Namespace namespace = new Namespace();
            this.m_model = new UpdateWizardModel(this.getUpdateManager());
            if (list != null) {
                this.m_model.setForcedCenters(list);
            }
            namespace.put(KEY_MODEL, (Object)this.m_model);
            FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
            fSMWizard.setWelcomePageAdded(list == null);
            fSMWizard.setFinishPageAdded(true);
            fSMWizard.setWizardTitle(UpdateArb.getString(3));
            fSMWizard.setShowStepNumber(true);
            fSMWizard.updateImage(this.WIZARD_IMAGE.getImage());
            Dialog dialog = DialogUtil.getAncestorDialog(component);
            if (dialog != null) {
                wizardDialog = fSMWizard.getDialog(dialog);
            } else {
                Frame frame = DialogUtil.getAncestorFrame(component);
                wizardDialog = fSMWizard.getDialog(frame);
            }
            fSMWizard.addCommitListener(new 1());
            boolean bl2 = WizardLauncher.runDialog((JDialog)wizardDialog);
            return bl2;
        }
        catch (FSMInvalidException fSMInvalidException) {
            fSMInvalidException.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unexpected FSMInvalidException");
            }
            return false;
        }
    }

    private File getInstallHookFile() {
        String string = Ide.getOracleHomeDirectory();
        return new File(string, "installhooks.properties");
    }

    private void commit() {
        TaskList taskList = new TaskList();
        if (this.getModel().getLocalBundle() != null) {
            LocalUpdateBundle localUpdateBundle = this.getModel().getLocalBundle();
            this.seedInstaller(taskList, localUpdateBundle.getBundle(), localUpdateBundle.getBundleFile());
        } else {
            Map map = this.getModel().getDownloadedUpdates();
            if (map == null) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                UpdateBundle updateBundle = (UpdateBundle)entry.getKey();
                File file = (File)entry.getValue();
                this.seedInstaller(taskList, updateBundle, file);
            }
            taskList.addAll(arrayList);
            taskList.addAll(arrayList2);
        }
        File file = UpdateManager.getInstance().getDeferredUpdatesFile();
        try {
            taskList.save(URLFactory.newFileURL(file));
        }
        catch (IOException iOException) {
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)iOException);
        }
        try {
            UpdateManager.getInstance().setUpdateCenters(this.getModel().getAllUpdateCenters());
        }
        catch (IOException iOException) {
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)iOException);
        }
    }

    private void seedInstaller(TaskList taskList, UpdateBundle updateBundle, File file) {
        for (UpdateInfo updateInfo : updateBundle.getUpdates()) {
            Extension extension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(updateInfo.getID());
            if (extension == null) continue;
            taskList.add(new DeinstallExtensionTask(updateInfo.getID()));
        }
        File file2 = this.getDestinationDir(updateBundle);
        taskList.add(new InstallExtensionTask(file.getPath(), file2.getPath(), false));
        for (UpdateInfo updateInfo : updateBundle.getUpdates()) {
            String string = updateInfo.getPostStartupHookClass();
            if (string == null || (string = string.trim()).length() <= 0) continue;
            taskList.add(new ScheduleHookTask(string, this.getInstallHookFile().getPath()));
        }
    }

    private File getDestinationDir(UpdateBundle updateBundle) {
        if (updateBundle.getInstallLocation() != null && "${oracle.home}".equals(updateBundle.getInstallLocation())) {
            return new File(Ide.getOracleHomeDirectory());
        }
        Extension extension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(((UpdateInfo)updateBundle.getUpdates().iterator().next()).getID());
        if (extension == null) {
            return new File(this.getModel().isInstallForEveryone() ? UpdateManager.getInstance().getDirectories().getGlobalExtensionsHome() : UpdateManager.getInstance().getDirectories().getUserExtensionsHome());
        }
        ExtensionRegistry extensionRegistry = (ExtensionRegistry)javax.ide.extension.ExtensionRegistry.getExtensionRegistry();
        if (extensionRegistry.isUserExtension(extension.getID())) {
            return new File(UpdateManager.getInstance().getDirectories().getUserExtensionsHome());
        }
        return new File(UpdateManager.getInstance().getDirectories().getGlobalExtensionsHome());
    }

    UpdateWizardModel getModel() {
        return this.m_model;
    }

    private UpdateManager getUpdateManager() {
        return this.m_updateManager;
    }

    static void mav$commit(UpdateWizard updateWizard) {
        updateWizard.commit();
    }

    public final class 1
    implements CommitListener {
        public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
        }

        public void commit(ApplyEvent applyEvent) throws TraversalException {
            UpdateWizard.mav$commit(UpdateWizard.this);
        }

        public void rollback(ApplyEvent applyEvent) {
        }

        public void cancel(ApplyEvent applyEvent) {
            UpdateWizard.this.getModel().setWizardCancelled(true);
        }
    }
}

