/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;

final class UpdateWizardModel {
    private final UpdateManager _manager;
    private LocalUpdateBundle _localBundle;
    private List _allCenters;
    private Collection _selectedUpdates;
    private Map _agreedLicenses;
    private boolean _installForEveryone;
    private Map _downloadedUpdates;
    private boolean _skipSource;
    private volatile boolean _wizardIsCancelled;
    public static final String PROP_WIZARD_CANCELLED = "wizardCancelled";
    private final PropertyChangeSupport _changeSupport;

    void $init$() {
        this._agreedLicenses = new HashMap();
        this._installForEveryone = false;
        this._skipSource = false;
        this._changeSupport = new PropertyChangeSupport(this);
    }

    public UpdateWizardModel(UpdateManager updateManager) {
        this.$init$();
        this._manager = updateManager;
    }

    UpdatePageConditions getConditions() {
        return new UpdatePageConditions(this.isLocal(), this.isLicense(), this.getSelectedUpdates());
    }

    public void setForcedCenters(List list) {
        this._skipSource = true;
        this._allCenters = list;
    }

    public boolean isSourceSkipped() {
        return this._skipSource;
    }

    private boolean isLocal() {
        return this._localBundle != null;
    }

    private boolean isLicense() {
        return this.getUpdatesRequiringAgreement().isEmpty() ^ true;
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this._changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this._changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void setDownloadedUpdates(Map map) {
        this._downloadedUpdates = map;
    }

    public synchronized Map getDownloadedUpdates() {
        return this._downloadedUpdates;
    }

    public synchronized UpdateManager getUpdateManager() {
        return this._manager;
    }

    public synchronized List getAllUpdateCenters() {
        if (this._allCenters == null) {
            this._allCenters = new ArrayList();
            int n = 0;
            while (n < this.getUpdateManager().getUpdateCenters().length) {
                this._allCenters.add(this.getUpdateManager().getUpdateCenters()[n].createClone());
                ++n;
            }
        }
        return this._allCenters;
    }

    public synchronized void setLocalBundle(LocalUpdateBundle localUpdateBundle) {
        this._localBundle = localUpdateBundle;
    }

    public synchronized LocalUpdateBundle getLocalBundle() {
        return this._localBundle;
    }

    public synchronized List getSelectedCenters() {
        ArrayList<UpdateCenter> arrayList = new ArrayList<UpdateCenter>(this._allCenters.size());
        for (UpdateCenter updateCenter : this._allCenters) {
            if (!updateCenter.isEnabled()) continue;
            arrayList.add(updateCenter);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public synchronized void setSelectedUpdates(Collection collection) {
        this._selectedUpdates = collection;
    }

    public synchronized Collection getSelectedUpdates() {
        if (this._localBundle != null) {
            return Collections.unmodifiableCollection(this._localBundle.getBundle().getUpdates());
        }
        return this._selectedUpdates;
    }

    public synchronized boolean isLicenseAgreed(UpdateInfo updateInfo) {
        if (updateInfo.getClickThroughURL() == null) {
            return true;
        }
        Boolean bl = (Boolean)this._agreedLicenses.get(updateInfo.getID());
        return bl == null ? false : bl;
    }

    public synchronized void setLicenseAgreed(UpdateInfo updateInfo, boolean bl) {
        this._agreedLicenses.put(updateInfo.getID(), bl);
    }

    public synchronized List getUpdatesRequiringAgreement() {
        ArrayList<UpdateInfo> arrayList = new ArrayList<UpdateInfo>();
        for (UpdateInfo updateInfo : this.getSelectedUpdates()) {
            if (this.isLicenseAgreed(updateInfo)) continue;
            arrayList.add(updateInfo);
        }
        return arrayList;
    }

    public synchronized void setInstallForEveryone(boolean bl) {
        this._installForEveryone = bl;
    }

    public synchronized boolean isInstallForEveryone() {
        return this._installForEveryone;
    }

    public boolean isWizardCancelled() {
        return this._wizardIsCancelled;
    }

    public void setWizardCancelled(boolean bl) {
        boolean bl2 = this._wizardIsCancelled;
        this._wizardIsCancelled = bl;
        this._changeSupport.firePropertyChange(PROP_WIZARD_CANCELLED, bl2, bl);
    }
}

