/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.UpdateArb;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.wizard.NiceList;
import oracle.ideimpl.webupdate.wizard.NiceListActionEvent;
import oracle.ideimpl.webupdate.wizard.NiceListActionListener;
import oracle.ideimpl.webupdate.wizard.NiceListRenderer;
import oracle.ideimpl.webupdate.wizard.UpdateInfoPanel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.resource.CommonIconsUtils;
import org.xml.sax.SAXParseException;

public class UpdatesPanel
extends JPanel {
    private final GridBagLayout _layout;
    private final JLabel _updatesLabel;
    private final JCheckBox _onlyUpgrades;
    private final NiceList _updatesList;
    private final SimpleListModel _filteredListModel;
    private final SimpleListModel _allListModel;
    private final Map _itemsByUpdateInfo;
    private final JPanel _progressPanel;
    private final JLabel _progressMessage;
    private final JButton _progressStop;
    private final JProgressBar _progressBar;
    private final HyperlinkButton _statusLink;
    private final ButtonBar _selectButtonBar;
    private final JButton _selectAllButton;
    private final JButton _deselectAllButton;
    private CheckUpdatesRunnable _checkRunnable;
    private Thread _checkRunnableThread;
    private ActionListener _statusLinkListener;
    private boolean _stoppedCheck;
    private boolean _checkedForUpdates;

    void $init$() {
        this._layout = new GridBagLayout();
        this._updatesLabel = new JLabel();
        this._onlyUpgrades = new JCheckBox();
        this._updatesList = new NiceList();
        this._filteredListModel = new SimpleListModel();
        this._allListModel = new SimpleListModel();
        this._itemsByUpdateInfo = new HashMap();
        this._progressPanel = new JPanel();
        this._progressMessage = new JLabel();
        this._progressStop = new JButton();
        this._progressBar = new JProgressBar();
        this._statusLink = new HyperlinkButton();
        this._selectButtonBar = new ButtonBar();
        this._selectAllButton = new JButton();
        this._deselectAllButton = new JButton();
        this._stoppedCheck = false;
        this._checkedForUpdates = false;
    }

    public UpdatesPanel() {
        this.$init$();
        this.resControls();
        this.layoutControls();
        this.installListeners();
        4 var1_1 = new 4();
        var1_1.setTwoLineDescription(true);
        this._updatesList.setCellRenderer(var1_1);
        this._updatesList.setModel(this._allListModel);
        this._onlyUpgrades.setSelected(false);
        this._updatesList.setSelectionMode(0);
    }

    boolean isCheckedForUpdates() {
        return this._checkedForUpdates;
    }

    boolean hasUpdates() {
        return this._allListModel.getSize() != 0;
    }

    private synchronized void setStopped(boolean bl) {
        this._stoppedCheck = bl;
        this._progressStop.setEnabled(bl ^ true);
    }

    private synchronized boolean isStopped() {
        return this._stoppedCheck;
    }

    private SimpleListModel getListModel() {
        return (SimpleListModel)this._updatesList.getModel();
    }

    private void installListeners() {
        Listener listener = new Listener(null);
        this._updatesList.addListActionListener(listener);
        this._onlyUpgrades.addActionListener(listener);
        this._selectAllButton.addActionListener(listener);
        this._deselectAllButton.addActionListener(listener);
        this._progressStop.addActionListener(listener);
        3 var2_2 = new 3();
        this._filteredListModel.addListDataListener((ListDataListener)var2_2);
        this._allListModel.addListDataListener((ListDataListener)var2_2);
    }

    private void resControls() {
        this._statusLink.setText(UpdateArb.getString(112));
        ResourceUtils.resLabel(this._updatesLabel, this._updatesList, UpdateArb.getString(11));
        ResourceUtils.resButton(this._onlyUpgrades, UpdateArb.getString(12));
        ResourceUtils.resButton(this._progressStop, UpdateArb.getString(13));
        ResourceUtils.resButton(this._selectAllButton, UpdateArb.getString(18));
        ResourceUtils.resButton(this._deselectAllButton, UpdateArb.getString(19));
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        this.add((Component)this._updatesLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_GAP_BELOW;
        this.add((Component)this._onlyUpgrades, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_ZERO;
        JScrollPane jScrollPane = new JScrollPane(this._updatesList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this._selectButtonBar, gridBagConstraints);
        this._selectButtonBar.setAlignment(4);
        this._selectButtonBar.add((Component)this._selectAllButton);
        this._selectButtonBar.add((Component)this._deselectAllButton);
        ++gridBagConstraints.gridy;
        this.add((Component)this._progressPanel, gridBagConstraints);
        this._progressPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = UpdateWizardPage.INSETS_ZERO;
        gridBagConstraints.anchor = 17;
        this._progressPanel.add((Component)this._progressMessage, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._progressPanel.add((Component)this._progressBar, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        this._progressPanel.add((Component)this._progressStop, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this._progressPanel.add((Component)this._statusLink, gridBagConstraints);
    }

    private void showUpdateInformation(UpdateItem updateItem) {
        new UpdateInfoPanel().runDialog(this, updateItem.getUpdate());
    }

    public Component getInitialFocus() {
        return this._updatesList;
    }

    private void populateUpdates(Collection arrayList) {
        this._onlyUpgrades.setEnabled(arrayList.isEmpty() ^ true);
        if (arrayList.isEmpty()) {
            this.showStatusMessage(CommonIconsUtils.getWarningIcon(), UpdateArb.getString(17), null);
            return;
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        Collections.sort(arrayList2);
        arrayList = arrayList2;
        for (UpdateInfo updateInfo : arrayList) {
            UpdateItem updateItem = new UpdateItem(updateInfo);
            updateItem.setSelected(false);
            this._itemsByUpdateInfo.put(updateInfo, updateItem);
            this._allListModel.addElement((Object)updateItem);
            if (updateInfo.isNew()) continue;
            this._filteredListModel.addElement((Object)updateItem);
        }
    }

    protected void completeValueChanged() {
    }

    private void updateSelectAllButtons() {
        boolean bl = this.getListModel().getSize() == 0;
        this._selectAllButton.setEnabled(bl ^ true);
        this._deselectAllButton.setEnabled(bl ^ true);
    }

    public void populate(UpdateWizardModel updateWizardModel) {
        this._checkedForUpdates = false;
        this.setStopped(false);
        this._allListModel.removeAll();
        this._filteredListModel.removeAll();
        this._itemsByUpdateInfo.clear();
        this._onlyUpgrades.setEnabled(false);
        this._updatesList.setModel(this._onlyUpgrades.isSelected() ? this._filteredListModel : this._allListModel);
        this._selectAllButton.setEnabled(false);
        this._deselectAllButton.setEnabled(false);
        if (updateWizardModel.getLocalBundle() == null) {
            this._checkRunnable = new 2(updateWizardModel.getSelectedCenters());
            1 var2_2 = new 1();
            this._checkRunnable.setMonitor(var2_2);
            Thread thread = new Thread((Runnable)this._checkRunnable, "Check for updates");
            thread.start();
        } else {
            this._progressPanel.setVisible(false);
            LocalUpdateBundle localUpdateBundle = updateWizardModel.getLocalBundle();
            for (UpdateInfo updateInfo : localUpdateBundle.getBundle().getUpdates()) {
                UpdateItem updateItem = new UpdateItem(updateInfo);
                updateItem.setSelected(true);
                this._allListModel.addElement((Object)updateItem);
                this._itemsByUpdateInfo.put(updateInfo, updateItem);
            }
            this._onlyUpgrades.setEnabled(false);
            this._onlyUpgrades.setSelected(false);
            this._updatesList.setModel(this._allListModel);
            this.completeValueChanged();
        }
    }

    private void showStatusMessage(Icon icon, String string) {
        this.showStatusMessage(icon, string, null);
    }

    private void showStatusMessage(Icon icon, String string, Throwable throwable) {
        this._progressMessage.setVisible(true);
        this._progressBar.setVisible(false);
        this._progressStop.setVisible(false);
        this._statusLink.setVisible(throwable != null);
        this._progressMessage.setIcon(icon);
        this._progressMessage.setText(string);
        this._progressPanel.setVisible(true);
        if (throwable != null) {
            if (this._statusLinkListener != null) {
                this._statusLink.removeActionListener(this._statusLinkListener);
            }
            this._statusLinkListener = this.createStatusLinkListener(throwable, string);
            this._statusLink.addActionListener(this._statusLinkListener);
        }
    }

    private ActionListener createStatusLinkListener(Throwable throwable, String string) {
        if (throwable instanceof SAXParseException) {
            return new KnownExceptionAction(throwable, string, UpdateArb.getString(165));
        }
        if (throwable instanceof FileNotFoundException) {
            return new KnownExceptionAction(throwable, string, UpdateArb.getString(166));
        }
        if (throwable instanceof IOException) {
            return new KnownExceptionAction(throwable, string, UpdateArb.getString(167));
        }
        return new UnknownExceptionAction(throwable, string);
    }

    protected void cleanUp() {
        if (this._checkRunnableThread != null) {
            try {
                this.setStopped(true);
                this._checkRunnableThread.join();
                this._checkRunnableThread = null;
                this._checkRunnable = null;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public boolean isComplete() {
        int n = 0;
        while (n < this.getListModel().getSize()) {
            UpdateItem updateItem = (UpdateItem)this.getListModel().getElementAt(n);
            if (updateItem.isSelected()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    List getSelectedUpdates() {
        ArrayList<UpdateInfo> arrayList = new ArrayList<UpdateInfo>();
        int n = 0;
        while (n < this.getListModel().getSize()) {
            UpdateItem updateItem = (UpdateItem)this.getListModel().getElementAt(n);
            if (updateItem.isSelected()) {
                arrayList.add(updateItem.getUpdate());
            }
            ++n;
        }
        return arrayList;
    }

    protected void save(UpdateWizardModel updateWizardModel) {
        updateWizardModel.setSelectedUpdates(this.getSelectedUpdates());
    }

    public boolean canFinish() {
        return this._checkedForUpdates && this._allListModel.getSize() == 0;
    }

    boolean isLicenseRequired() {
        List list = this.getSelectedUpdates();
        for (UpdateInfo updateInfo : list) {
            if (updateInfo.getClickThroughURL() == null) continue;
            return true;
        }
        return false;
    }

    private void updateDependencies(UpdateItem updateItem) {
        UpdateInfo updateInfo = updateItem.getUpdate();
        if (updateItem.isSelected() && !updateInfo.getRequiredUpdates().isEmpty()) {
            for (UpdateInfo updateInfo2 : updateInfo.getRequiredUpdates()) {
                UpdateItem updateItem2 = (UpdateItem)this._itemsByUpdateInfo.get(updateInfo2);
                updateItem2.setSelected(true);
                this.updateDependencies(updateItem2);
            }
        } else if (!updateItem.isSelected()) {
            int n = 0;
            while (n < this._allListModel.getSize()) {
                boolean bl;
                UpdateItem updateItem3 = (UpdateItem)this._allListModel.getElementAt(n);
                if (updateItem3.isSelected() && updateItem3.getUpdate().getRequiredUpdates().contains(updateInfo) && !(bl = MessageDialog.confirm((Component)this, (Object)UpdateArb.format(43, updateInfo.getName(), updateItem3.getUpdate().getName()), (String)UpdateArb.getString(42), null))) {
                    updateItem.setSelected(true);
                }
                ++n;
            }
        }
        UpdateBundle updateBundle = updateItem.getUpdate().getBundle();
        for (UpdateInfo updateInfo3 : updateBundle.getUpdates()) {
            if (updateInfo3 == updateItem.getUpdate()) continue;
            UpdateItem updateItem4 = (UpdateItem)this._itemsByUpdateInfo.get(updateInfo3);
            updateItem4.setSelected(updateItem.isSelected());
        }
        this.getListModel().changed();
    }

    private void setAllSelected(boolean bl) {
        SimpleListModel simpleListModel = this.getListModel();
        for (UpdateItem updateItem : simpleListModel) {
            updateItem.setSelected(bl);
        }
        simpleListModel.changed();
    }

    static SimpleListModel mav$getListModel(UpdatesPanel updatesPanel) {
        return updatesPanel.getListModel();
    }

    static JButton ra$_selectAllButton(UpdatesPanel updatesPanel) {
        return updatesPanel._selectAllButton;
    }

    static JButton ra$_deselectAllButton(UpdatesPanel updatesPanel) {
        return updatesPanel._deselectAllButton;
    }

    static void mav$populateUpdates(UpdatesPanel updatesPanel, Collection collection) {
        updatesPanel.populateUpdates(collection);
    }

    static void wa$_checkedForUpdates(UpdatesPanel updatesPanel, boolean bl) {
        updatesPanel._checkedForUpdates = bl;
    }

    static void mav$updateSelectAllButtons(UpdatesPanel updatesPanel) {
        updatesPanel.updateSelectAllButtons();
    }

    static void mav$showStatusMessage(UpdatesPanel updatesPanel, Icon icon, String string) {
        updatesPanel.showStatusMessage(icon, string);
    }

    static void mav$showStatusMessage(UpdatesPanel updatesPanel, Icon icon, String string, Throwable throwable) {
        updatesPanel.showStatusMessage(icon, string, throwable);
    }

    static boolean mav$isStopped(UpdatesPanel updatesPanel) {
        return updatesPanel.isStopped();
    }

    static JLabel ra$_progressMessage(UpdatesPanel updatesPanel) {
        return updatesPanel._progressMessage;
    }

    static JProgressBar ra$_progressBar(UpdatesPanel updatesPanel) {
        return updatesPanel._progressBar;
    }

    static JButton ra$_progressStop(UpdatesPanel updatesPanel) {
        return updatesPanel._progressStop;
    }

    static HyperlinkButton ra$_statusLink(UpdatesPanel updatesPanel) {
        return updatesPanel._statusLink;
    }

    static JPanel ra$_progressPanel(UpdatesPanel updatesPanel) {
        return updatesPanel._progressPanel;
    }

    static SimpleListModel ra$_allListModel(UpdatesPanel updatesPanel) {
        return updatesPanel._allListModel;
    }

    static JCheckBox ra$_onlyUpgrades(UpdatesPanel updatesPanel) {
        return updatesPanel._onlyUpgrades;
    }

    static SimpleListModel ra$_filteredListModel(UpdatesPanel updatesPanel) {
        return updatesPanel._filteredListModel;
    }

    static NiceList ra$_updatesList(UpdatesPanel updatesPanel) {
        return updatesPanel._updatesList;
    }

    static void mav$setStopped(UpdatesPanel updatesPanel, boolean bl) {
        updatesPanel.setStopped(bl);
    }

    static void mav$setAllSelected(UpdatesPanel updatesPanel, boolean bl) {
        updatesPanel.setAllSelected(bl);
    }

    static void mav$updateDependencies(UpdatesPanel updatesPanel, UpdateItem updateItem) {
        updatesPanel.updateDependencies(updateItem);
    }

    static void mav$showUpdateInformation(UpdatesPanel updatesPanel, UpdateItem updateItem) {
        updatesPanel.showUpdateInformation(updateItem);
    }

    public final class 4
    extends NiceListRenderer {
        public String getTitle(Object object) {
            return ((UpdateItem)object).getUpdate().getName() + " " + ((UpdateItem)object).getUpdate().getVersion().toString();
        }

        public String getDescription(Object object) {
            return ((UpdateItem)object).getUpdate().getDescription();
        }

        public String getSecondDescription(Object object) {
            UpdateInfo updateInfo = ((UpdateItem)object).getUpdate();
            if (updateInfo != null && updateInfo.getSourceCenter() != null) {
                return UpdateArb.format(162, updateInfo.getSourceCenter().getName());
            }
            return "Local Update";
        }

        public boolean isItemSelected(Object object) {
            return ((UpdateItem)object).isSelected();
        }

        public String getHyperLinkText(Object object) {
            return UpdateArb.getString(112);
        }

        public Icon getIndicator(Object object) {
            UpdateItem updateItem = (UpdateItem)object;
            if (updateItem.getUpdate().isNew()) {
                return UpdateArb.getIcon(121);
            }
            return UpdateArb.getIcon(122);
        }
    }

    public final class 3
    implements ListDataListener {
        private void doit() {
            boolean bl = UpdatesPanel.mav$getListModel(UpdatesPanel.this).getSize() > 0;
            UpdatesPanel.ra$_selectAllButton(UpdatesPanel.this).setEnabled(bl);
            UpdatesPanel.ra$_deselectAllButton(UpdatesPanel.this).setEnabled(bl);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.doit();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.doit();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.doit();
        }
    }

    public final class oracle.ideimpl.webupdate.wizard.UpdatesPanel$2
    extends CheckUpdatesRunnable {
        protected void finished(Collection collection) {
            EventQueue.invokeLater(new 3(this, collection));
        }

        protected void stopped() {
            EventQueue.invokeLater(new 2());
        }

        protected void updateCenterError(UpdateCenter updateCenter, Throwable throwable) {
            EventQueue.invokeLater(new 1(this, updateCenter, throwable));
        }

        public oracle.ideimpl.webupdate.wizard.UpdatesPanel$2(List list) {
            super(list);
        }

        public final class 3
        implements Runnable {
            private final /* synthetic */ Collection v$updates;
            final /* synthetic */ oracle.ideimpl.webupdate.wizard.UpdatesPanel$2 this$0;

            public void run() {
                try {
                    UpdatesPanel.mav$populateUpdates(this.this$0.UpdatesPanel.this, this.v$updates);
                }
                finally {
                    UpdatesPanel.wa$_checkedForUpdates(this.this$0.UpdatesPanel.this, true);
                    this.this$0.UpdatesPanel.this.completeValueChanged();
                    UpdatesPanel.mav$updateSelectAllButtons(this.this$0.UpdatesPanel.this);
                }
            }

            public 3(oracle.ideimpl.webupdate.wizard.UpdatesPanel$2 var1_1, Collection collection) {
                this.v$updates = collection;
                this.this$0 = var1_1;
            }
        }

        public final class 2
        implements Runnable {
            public void run() {
                UpdatesPanel.wa$_checkedForUpdates(UpdatesPanel.this, true);
                UpdatesPanel.mav$showStatusMessage(UpdatesPanel.this, CommonIconsUtils.getWarningIcon(), "Check for updates was stopped.");
                UpdatesPanel.this.completeValueChanged();
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ UpdateCenter v$center;
            private final /* synthetic */ Throwable v$t;
            final /* synthetic */ oracle.ideimpl.webupdate.wizard.UpdatesPanel$2 this$0;

            public void run() {
                UpdatesPanel.mav$showStatusMessage(this.this$0.UpdatesPanel.this, CommonIconsUtils.getErrorIcon(), UpdateArb.format(132, this.v$center.getName()), this.v$t);
            }

            public 1(oracle.ideimpl.webupdate.wizard.UpdatesPanel$2 var1_1, UpdateCenter updateCenter, Throwable throwable) {
                this.v$t = throwable;
                this.v$center = updateCenter;
                this.this$0 = var1_1;
            }
        }
    }

    public final class oracle.ideimpl.webupdate.wizard.UpdatesPanel$1
    implements UpdateCenterMonitor {
        public void setMessage(String string) {
            EventQueue.invokeLater(new 5(this, string));
        }

        public void setProgress(int n) {
            EventQueue.invokeLater(new 4(this, n));
        }

        public void setMaximum(int n) {
            EventQueue.invokeLater(new 3(this, n));
        }

        public void start() {
            EventQueue.invokeLater(new 2());
        }

        public void finish() {
            EventQueue.invokeLater(new 1());
        }

        public boolean isStopped() {
            return UpdatesPanel.mav$isStopped(UpdatesPanel.this);
        }

        public final class 5
        implements Runnable {
            private final /* synthetic */ String v$message;
            final /* synthetic */ oracle.ideimpl.webupdate.wizard.UpdatesPanel$1 this$0;

            public void run() {
                UpdatesPanel.ra$_progressMessage(this.this$0.UpdatesPanel.this).setText(this.v$message);
            }

            public 5(oracle.ideimpl.webupdate.wizard.UpdatesPanel$1 var1_1, String string) {
                this.v$message = string;
                this.this$0 = var1_1;
            }
        }

        public final class 4
        implements Runnable {
            private final /* synthetic */ int v$progress;
            final /* synthetic */ oracle.ideimpl.webupdate.wizard.UpdatesPanel$1 this$0;

            public void run() {
                UpdatesPanel.ra$_progressBar(this.this$0.UpdatesPanel.this).setValue(this.v$progress);
            }

            public 4(oracle.ideimpl.webupdate.wizard.UpdatesPanel$1 var1_1, int n) {
                this.v$progress = n;
                this.this$0 = var1_1;
            }
        }

        public final class 3
        implements Runnable {
            private final /* synthetic */ int v$max;
            final /* synthetic */ oracle.ideimpl.webupdate.wizard.UpdatesPanel$1 this$0;

            public void run() {
                UpdatesPanel.ra$_progressBar(this.this$0.UpdatesPanel.this).setMaximum(this.v$max);
            }

            public 3(oracle.ideimpl.webupdate.wizard.UpdatesPanel$1 var1_1, int n) {
                this.v$max = n;
                this.this$0 = var1_1;
            }
        }

        public final class 2
        implements Runnable {
            public void run() {
                UpdatesPanel.ra$_progressMessage(UpdatesPanel.this).setIcon(null);
                UpdatesPanel.ra$_progressMessage(UpdatesPanel.this).setVisible(true);
                UpdatesPanel.ra$_progressBar(UpdatesPanel.this).setValue(0);
                UpdatesPanel.ra$_progressBar(UpdatesPanel.this).setVisible(true);
                UpdatesPanel.ra$_progressStop(UpdatesPanel.this).setVisible(true);
                UpdatesPanel.ra$_progressStop(UpdatesPanel.this).setEnabled(true);
                UpdatesPanel.ra$_statusLink(UpdatesPanel.this).setVisible(false);
                UpdatesPanel.ra$_progressPanel(UpdatesPanel.this).setVisible(true);
                UpdatesPanel.ra$_progressPanel(UpdatesPanel.this).invalidate();
                UpdatesPanel.ra$_progressPanel(UpdatesPanel.this).validate();
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                if (UpdatesPanel.ra$_allListModel(UpdatesPanel.this).getSize() > 0) {
                    UpdatesPanel.ra$_progressPanel(UpdatesPanel.this).setVisible(false);
                }
            }
        }
    }

    private class KnownExceptionAction
    implements ActionListener {
        private final Throwable _exception;
        private final String _baseMessage;
        private final String _detailMessage;

        public KnownExceptionAction(Throwable throwable, String string, String string2) {
            this._exception = throwable;
            this._baseMessage = string;
            this._detailMessage = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MessageDialog.error((Component)UpdatesPanel.this, (Object)(this._baseMessage + "\n" + this._detailMessage), (String)UpdateArb.getString(1), null);
        }
    }

    private class UnknownExceptionAction
    implements ActionListener {
        private final Throwable _exception;
        private final String _message;

        public UnknownExceptionAction(Throwable throwable, String string) {
            this._exception = throwable;
            this._message = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExceptionDialog.showExceptionDialog((Component)UpdatesPanel.this, (Throwable)this._exception, (String)this._message, (String)UpdateArb.getString(1), null);
        }
    }

    private class UpdateItem {
        private boolean _isSelected;
        private final UpdateInfo _update;

        void $init$() {
            this._isSelected = false;
        }

        UpdateItem(UpdateInfo updateInfo) {
            this.$init$();
            this._update = updateInfo;
        }

        public UpdateInfo getUpdate() {
            return this._update;
        }

        public boolean isSelected() {
            return this._isSelected;
        }

        public void setSelected(boolean bl) {
            this._isSelected = bl;
        }

        public String toString() {
            return this.getUpdate().getName();
        }
    }

    private class Listener
    implements ActionListener,
    NiceListActionListener {
        public void listActionPerformed(NiceListActionEvent niceListActionEvent) {
            if (niceListActionEvent.getRow() >= 0) {
                UpdateItem updateItem = (UpdateItem)UpdatesPanel.mav$getListModel(UpdatesPanel.this).getElementAt(niceListActionEvent.getRow());
                if (niceListActionEvent.getType() == 0) {
                    updateItem.setSelected(updateItem.isSelected() ^ true);
                    UpdatesPanel.mav$updateDependencies(UpdatesPanel.this, updateItem);
                    UpdatesPanel.mav$getListModel(UpdatesPanel.this).changed(niceListActionEvent.getRow());
                    UpdatesPanel.this.completeValueChanged();
                } else if (niceListActionEvent.getType() == 1) {
                    UpdatesPanel.mav$showUpdateInformation(UpdatesPanel.this, updateItem);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == UpdatesPanel.ra$_onlyUpgrades(UpdatesPanel.this)) {
                SimpleListModel simpleListModel;
                SimpleListModel simpleListModel2 = simpleListModel = UpdatesPanel.ra$_onlyUpgrades(UpdatesPanel.this).isSelected() ? UpdatesPanel.ra$_filteredListModel(UpdatesPanel.this) : UpdatesPanel.ra$_allListModel(UpdatesPanel.this);
                if (simpleListModel != UpdatesPanel.mav$getListModel(UpdatesPanel.this)) {
                    Object e = UpdatesPanel.ra$_updatesList(UpdatesPanel.this).getSelectedValue();
                    UpdatesPanel.ra$_updatesList(UpdatesPanel.this).setModel(simpleListModel);
                    if (e != null) {
                        UpdatesPanel.ra$_updatesList(UpdatesPanel.this).setSelectedValue(e, true);
                    }
                }
                UpdatesPanel.mav$getListModel(UpdatesPanel.this).changed();
                UpdatesPanel.this.completeValueChanged();
            } else if (actionEvent.getSource() == UpdatesPanel.ra$_progressStop(UpdatesPanel.this)) {
                UpdatesPanel.mav$setStopped(UpdatesPanel.this, true);
            } else if (actionEvent.getSource() == UpdatesPanel.ra$_selectAllButton(UpdatesPanel.this)) {
                UpdatesPanel.mav$setAllSelected(UpdatesPanel.this, true);
                UpdatesPanel.this.completeValueChanged();
            } else if (actionEvent.getSource() == UpdatesPanel.ra$_deselectAllButton(UpdatesPanel.this)) {
                UpdatesPanel.mav$setAllSelected(UpdatesPanel.this, false);
                UpdatesPanel.this.completeValueChanged();
            }
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

