/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorIterator;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.TabGroupState;

final class WindowFlatWindows
extends JPanel
implements KeyListener,
ListSelectionListener {
    private static final boolean DISMISS_WITHOUT_WINDOWS = true;
    private List _duplicates;
    private JList _lWindows;
    private JButton _jbActivate;
    private JButton _jbClose;
    private DismissableJEWTDialog _container;

    public static boolean runDialog(Frame frame) {
        WindowFlatWindows windowFlatWindows = new WindowFlatWindows();
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        DismissableJEWTDialog dismissableJEWTDialog = new DismissableJEWTDialog(frame);
        if (helpSystem != null) {
            helpSystem.registerTopic(windowFlatWindows, "f1_idedwindows_html");
        }
        windowFlatWindows._container = dismissableJEWTDialog;
        dismissableJEWTDialog.setInitialFocus(windowFlatWindows._lWindows);
        dismissableJEWTDialog.setContent(windowFlatWindows);
        dismissableJEWTDialog.setResizable(true);
        return WizardLauncher.runDialog((JDialog)((Object)dismissableJEWTDialog));
    }

    private WindowFlatWindows() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(400, 300));
        JLabel jLabel = new JLabel();
        this._jbActivate = new JButton();
        this._jbClose = new JButton();
        DefaultListModel defaultListModel = new DefaultListModel();
        this._lWindows = new JList(defaultListModel);
        this._lWindows.setCellRenderer(new 6());
        this._lWindows.addKeyListener(this);
        this._lWindows.addListSelectionListener(this);
        this.fillEditors();
        if (!defaultListModel.isEmpty()) {
            this._lWindows.setSelectedIndex(0);
        }
        this.enableButtons();
        ResourceUtils.resLabel(jLabel, this._lWindows, DialogsArb.getString(11));
        ResourceUtils.resButton(this._jbActivate, DialogsArb.getString(12));
        ResourceUtils.resButton(this._jbClose, DialogsArb.getString(13));
        5 var4_4 = new 5();
        this._jbActivate.addActionListener(new 4());
        this._jbClose.addActionListener(new 3());
        this._lWindows.addMouseListener(new 2(this, var4_4));
        this._lWindows.setSelectionMode(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)new JScrollPane(this._lWindows), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this._jbActivate, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this._jbClose, gridBagConstraints);
        gridBagConstraints.fill = 0;
    }

    private void fillEditors() {
        EditorIterator editorIterator = new EditorIterator(3);
        ArrayList arrayList = Collections.list(editorIterator);
        Collections.sort(arrayList, new 1());
        this._duplicates = WindowFlatWindows.getDuplicates(arrayList);
        DefaultListModel defaultListModel = (DefaultListModel)this._lWindows.getModel();
        ListSelectionModel listSelectionModel = this._lWindows.getSelectionModel();
        List<Object> list = Arrays.asList(this._lWindows.getSelectedValues());
        defaultListModel.clear();
        int n = arrayList.size();
        defaultListModel.ensureCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            TabGroupState tabGroupState = (TabGroupState)arrayList.get(n2);
            MyModelElement myModelElement = new MyModelElement(tabGroupState);
            defaultListModel.addElement(myModelElement);
            if (list.contains(myModelElement)) {
                listSelectionModel.addSelectionInterval(n2, n2);
            }
            ++n2;
        }
        this.enableButtons();
    }

    private static List getDuplicates(List list) {
        ArrayList<TabGroupState> arrayList = null;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            TabGroupState tabGroupState = (TabGroupState)list.get(n2);
            String string = tabGroupState.getContext().getNode().getShortLabel();
            boolean bl = false;
            int n3 = n2 + 1;
            while (n3 < n) {
                TabGroupState tabGroupState2 = (TabGroupState)list.get(n3);
                Node node = tabGroupState2.getContext().getNode();
                if (string.equals(node.getShortLabel())) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<TabGroupState>();
                    }
                    arrayList.add(tabGroupState2);
                    bl = true;
                }
                ++n3;
            }
            if (bl) {
                arrayList.add(tabGroupState);
            }
            ++n2;
        }
        return arrayList == null ? Collections.EMPTY_LIST : arrayList;
    }

    private void whenActivate() {
        Object[] objectArray = this._lWindows.getSelectedValues();
        if (objectArray.length > 0) {
            EditorPathImpl editorPathImpl;
            MyModelElement myModelElement = (MyModelElement)objectArray[objectArray.length - 1];
            TabGroupState tabGroupState = myModelElement.getTabGroupState();
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            if (editorManagerImpl.searchEditor(editorPathImpl = new EditorPathImpl(), new EditorCriteriaImpl(tabGroupState))) {
                editorManagerImpl.activateEditor(editorPathImpl);
            }
        }
    }

    private void whenClose() {
        DefaultListModel defaultListModel = (DefaultListModel)this._lWindows.getModel();
        Object[] objectArray = this._lWindows.getSelectedValues();
        int n = objectArray.length;
        if (n > 0) {
            MyModelElement myModelElement = (MyModelElement)objectArray[0];
            int n2 = this.getIndexOf(myModelElement);
            TabGroupState[] tabGroupStateArray = new TabGroupState[n];
            int n3 = 0;
            while (n3 < n) {
                MyModelElement myModelElement2 = (MyModelElement)objectArray[n3];
                tabGroupStateArray[n3] = myModelElement2.getTabGroupState();
                ++n3;
            }
            EditorManagerImpl editorManagerImpl = (EditorManagerImpl)EditorManager.getEditorManager();
            editorManagerImpl.closeEditors(tabGroupStateArray);
            this.fillEditors();
            int n4 = defaultListModel.getSize();
            if (n4 > 0) {
                if ((n2 = Math.min(n2, n4 - 1)) >= 0) {
                    this._lWindows.setSelectedIndex(n2);
                }
            } else {
                DismissableJEWTDialog.mav$dismiss(this._container);
            }
        }
    }

    private int getIndexOf(MyModelElement myModelElement) {
        ListModel listModel = this._lWindows.getModel();
        int n = listModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            if (myModelElement.equals(listModel.getElementAt(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void enableButtons() {
        int[] nArray = this._lWindows.getSelectedIndices();
        switch (nArray.length) {
            case 0: {
                this._jbActivate.setEnabled(false);
                this._jbClose.setEnabled(false);
                break;
            }
            case 1: {
                this._jbActivate.setEnabled(true);
                this._jbClose.setEnabled(true);
                break;
            }
            default: {
                this._jbActivate.setEnabled(false);
                this._jbClose.setEnabled(true);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 10) {
            this.whenActivate();
            DismissableJEWTDialog.mav$dismiss(this._container);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    static void mav$whenActivate(WindowFlatWindows windowFlatWindows) {
        windowFlatWindows.whenActivate();
    }

    static DismissableJEWTDialog ra$_container(WindowFlatWindows windowFlatWindows) {
        return windowFlatWindows._container;
    }

    static void mav$whenClose(WindowFlatWindows windowFlatWindows) {
        windowFlatWindows.whenClose();
    }

    static List ra$_duplicates(WindowFlatWindows windowFlatWindows) {
        return windowFlatWindows._duplicates;
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog(Frame frame) {
            super(frame, DialogsArb.getString(10), 5);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }

        static void mav$dismiss(DismissableJEWTDialog dismissableJEWTDialog) {
            dismissableJEWTDialog.dismiss();
        }
    }

    final class 6
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            MyModelElement myModelElement = (MyModelElement)object;
            String string = myModelElement.getText();
            this.setText(string);
            TabGroupState tabGroupState = myModelElement.getTabGroupState();
            Node node = tabGroupState.getContext().getNode();
            this.setIcon(node.getIcon());
            return this;
        }
    }

    final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            WindowFlatWindows.mav$whenActivate(WindowFlatWindows.this);
            DismissableJEWTDialog.mav$dismiss(WindowFlatWindows.ra$_container(WindowFlatWindows.this));
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            WindowFlatWindows.mav$whenActivate(WindowFlatWindows.this);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            WindowFlatWindows.mav$whenClose(WindowFlatWindows.this);
        }
    }

    final class 2
    extends MouseAdapter {
        private final /* synthetic */ ActionListener v$alActivateAndGo;
        final /* synthetic */ WindowFlatWindows this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                this.v$alActivateAndGo.actionPerformed(null);
            }
        }

        public 2(WindowFlatWindows windowFlatWindows, ActionListener actionListener) {
            this.v$alActivateAndGo = actionListener;
            this.this$0 = windowFlatWindows;
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            TabGroupState tabGroupState = (TabGroupState)object;
            TabGroupState tabGroupState2 = (TabGroupState)object2;
            Context context = tabGroupState.getContext();
            Context context2 = tabGroupState2.getContext();
            Node node = context.getNode();
            Node node2 = context2.getNode();
            return String.CASE_INSENSITIVE_ORDER.compare(node.getShortLabel(), node2.getShortLabel());
        }
    }

    private class MyModelElement {
        private TabGroupState _tabGroupState;

        public MyModelElement(TabGroupState tabGroupState) {
            this._tabGroupState = tabGroupState;
        }

        public boolean equals(Object object) {
            MyModelElement myModelElement = (MyModelElement)object;
            return this._tabGroupState.equals(myModelElement._tabGroupState);
        }

        public int hashCode() {
            return this._tabGroupState.hashCode();
        }

        public String toString() {
            return this.getText();
        }

        public TabGroupState getTabGroupState() {
            return this._tabGroupState;
        }

        String getText() {
            Node node = this._tabGroupState.getContext().getNode();
            String string = node.getShortLabel();
            if (WindowFlatWindows.ra$_duplicates(WindowFlatWindows.this).contains(this._tabGroupState)) {
                string = string + "(" + node.getLongLabel() + ")";
            }
            return string;
        }
    }
}

