/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.ideimpl.window.WindowFlatWindows;

public final class WindowManagerImpl
implements Addin,
Controller,
MenuListener {
    public static final float WEIGHT_WINDOW_MENU = MenuConstants.WEIGHT_TOOLS_MENU + 1.0f;
    public static final float SECTION_WINDOW_SPLITS = 1.0f;
    public static final float SECTION_WINDOW_GOTO = 2.0f;
    public static final float SECTION_WINDOW_ADDINS = 3.0f;
    public static final float SECTION_WINDOW_WINDOW_LIST = 4.0f;
    public static final float SECTION_WINDOW_WINDOWS = 5.0f;

    public void initialize() {
        this.createActions();
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = menubar.createMenu(IdeArb.getString(191), IdeArb.getInteger(192), WEIGHT_WINDOW_MENU, 3.0f);
        jMenu.addMenuListener(this);
        menubar.add(jMenu);
        MenuManager.putJMenu("Window", jMenu);
    }

    private void createActions() {
        AddinManager addinManager = AddinManager.getAddinManager();
        IdeAction ideAction = IdeAction.get(42, addinManager.getCommand(42, "oracle.ide.cmd.NotImplementedCommand"), IdeArb.getString(331), IdeMainWindow.ACTION_CATEGORY_WINDOWS, IdeArb.getInteger(332), IdeArb.getInstance(), 333, null, false);
        ideAction.addController(this);
        IdeAction ideAction2 = IdeAction.get(43, addinManager.getCommand(43, "oracle.ide.cmd.NotImplementedCommand"), IdeArb.getString(334), IdeMainWindow.ACTION_CATEGORY_WINDOWS, IdeArb.getInteger(335), IdeArb.getInstance(), 336, null, false);
        ideAction2.addController(this);
        IdeAction ideAction3 = IdeAction.get(61, addinManager.getCommand(61, "oracle.ide.cmd.NotImplementedCommand"), IdeArb.getString(194), IdeMainWindow.ACTION_CATEGORY_WINDOWS, IdeArb.getInteger(195), null, null, false);
        ideAction3.addController(this);
        ideAction3.setEnabled(true);
    }

    private Controller getController(Context context) {
        View view = context.getView();
        Component component = view.getGUI();
        if (SwingUtilities.getAncestorOfClass(TitledPanel.class, component) != null) {
            return DockStation.getDockStation();
        }
        return EditorManager.getEditorManager();
    }

    private void whenWindowsDotDotDot() {
        WindowFlatWindows.runDialog((Frame)((Object)Ide.getMainWindow()));
        EditorManager.getEditorManager().activateCurrentEditorFrame();
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        switch (n) {
            case 42: 
            case 43: {
                this.getController(context).handleEvent(ideAction, context);
                break;
            }
            case 61: {
                this.whenWindowsDotDotDot();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        switch (n) {
            case 42: 
            case 43: {
                this.getController(context).update(ideAction, context);
                break;
            }
            case 61: {
                Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                boolean bl = editor != null;
                ideAction.setEnabled(bl);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void fillWindowMenu(JMenu jMenu) {
        Menubar menubar = Ide.getMenubar();
        jMenu.removeAll();
        menubar.add(menubar.createMenuItem(IdeAction.find(EditorManagerImpl.SPLIT_DOCUMENT_CMD_ID)), jMenu, 1.0f);
        menubar.add(menubar.createMenuItem(IdeAction.find(EditorManagerImpl.UNSPLIT_DOCUMENT_CMD_ID)), jMenu, 1.0f);
        menubar.add(menubar.createMenuItem(IdeAction.find(EditorManagerImpl.DETACH_DOCUMENT_CMD_ID)), jMenu, 1.0f);
        menubar.add(menubar.createMenuItem(IdeAction.find(EditorManagerImpl.REGROUP_DOCUMENTS_CMD_ID)), jMenu, 1.0f);
        JMenu jMenu2 = this.fillGoToMenu(menubar);
        menubar.add(jMenu2, jMenu, 2.0f);
        JMenu jMenu3 = this.fillAssignMenu(menubar);
        menubar.add(jMenu3, jMenu, 2.0f);
        EditorManagerImpl editorManagerImpl = (EditorManagerImpl)EditorManager.getEditorManager();
        List list = editorManagerImpl.getWindowList();
        int n = list.size();
        if (n != 0) {
            int n2 = 0;
            while (n2 < n) {
                JMenuItem jMenuItem = (JMenuItem)list.get(n2);
                menubar.add(jMenuItem, jMenu, 4.0f);
                ++n2;
            }
        }
        IdeAction ideAction = IdeAction.find(61);
        JMenuItem jMenuItem = menubar.createMenuItem(ideAction);
        menubar.add(jMenuItem, jMenu, 5.0f);
    }

    private JMenu fillGoToMenu(Menubar menubar) {
        float f = 1.0f;
        String string = IdeImplArb.getString(0);
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        JMenu jMenu = menubar.createSubMenu(string2, n);
        menubar.add(menubar.createMenuItem(IdeAction.find(EditorManagerImpl.SYSTEM_MENU_CMD_ID)), jMenu, f);
        menubar.add(menubar.createMenuItem(IdeAction.find(EditorManagerImpl.SHOW_DROPDOWN_CMD_ID)), jMenu, f);
        JMenuItem jMenuItem = menubar.createMenuItem(IdeAction.find(42));
        menubar.add(jMenuItem, jMenu, f += 1.0f);
        JMenuItem jMenuItem2 = menubar.createMenuItem(IdeAction.find(43));
        menubar.add(jMenuItem2, jMenu, f);
        menubar.add(menubar.createMenuItem(IdeAction.find(70)), jMenu, f += 1.0f);
        menubar.add(menubar.createMenuItem(IdeAction.find(71)), jMenu, f);
        menubar.add(menubar.createMenuItem(IdeAction.find(EditorManagerImpl.NEXT_PANE_CMD_ID)), jMenu, f += 1.0f);
        menubar.add(menubar.createMenuItem(IdeAction.find(EditorManagerImpl.PREV_PANE_CMD_ID)), jMenu, f);
        menubar.add(menubar.createMenuItem(IdeAction.find(41)), jMenu, f += 1.0f);
        menubar.add(menubar.createMenuItem(IdeAction.find(40)), jMenu, f);
        return jMenu;
    }

    private JMenu fillAssignMenu(Menubar menubar) {
        float f = 1.0f;
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
        String string = IdeImplArb.getString(2);
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        JMenu jMenu = menubar.createSubMenu(string2, n);
        int n2 = 0;
        while (n2 < 9) {
            int n3 = editorManagerImpl.getAssignCmdId(n2);
            IdeAction ideAction = IdeAction.find(n3);
            JMenuItem jMenuItem = menubar.createMenuItem(ideAction);
            menubar.add(jMenuItem, jMenu, f);
            ++n2;
        }
        return jMenu;
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        this.fillWindowMenu(MenuManager.getJMenu("Window"));
    }
}

