/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.GlobalMouseDispatcher;
import oracle.ide.model.Displayable;
import oracle.ide.util.GraphicsUtils;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableHeaderRenderer;

public abstract class WindowSelector {
    private static final KeyModifierTracker KEY_MODIFIER_TRACKER;
    private SelectionWindow _selectionWindow;
    private EventHandler _eventHandler;
    private Displayable[] _displayables;
    private int _selectedIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = WindowSelector.class.desiredAssertionStatus() ^ true;
        KEY_MODIFIER_TRACKER = KeyModifierTracker.getInstance();
    }

    protected WindowSelector() {
    }

    protected abstract Displayable[] getDisplayables();

    protected abstract void activateSelectedWindow();

    protected void selectNextItem() {
        if (this._displayables == null) {
            this._selectedIndex = 0;
            this._displayables = this.getDisplayables();
        }
        ++this._selectedIndex;
        if (this._selectedIndex >= this._displayables.length) {
            this._selectedIndex = 0;
        }
        this.updateSelection();
    }

    protected void selectPreviousItem() {
        if (this._displayables == null) {
            this._selectedIndex = 0;
            this._displayables = this.getDisplayables();
        }
        --this._selectedIndex;
        if (this._selectedIndex < 0) {
            this._selectedIndex = this._displayables.length - 1;
        }
        this.updateSelection();
    }

    protected void dispose() {
        this._displayables = null;
        if (this._selectionWindow != null) {
            Window window = this._selectionWindow.getOwner();
            this._selectionWindow.dispose();
            this._selectionWindow = null;
            window.removeComponentListener(this._eventHandler);
            window.removeWindowListener(this._eventHandler);
            window.removeWindowFocusListener(this._eventHandler);
            window.removeWindowStateListener(this._eventHandler);
            GlobalMouseDispatcher.getInstance().removeMouseListener(this._eventHandler);
            this._eventHandler = null;
        }
    }

    protected int getSelectedIndex() {
        return this._selectedIndex;
    }

    protected int getKeyModifiers() {
        return KEY_MODIFIER_TRACKER.getModifiers();
    }

    private SelectionWindow getSelectionWindow() {
        if (this._selectionWindow == null) {
            if (!$assertionsDisabled && this._displayables == null) {
                throw new AssertionError();
            }
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            this._eventHandler = new EventHandler(this);
            ((Component)((Object)ideMainWindow)).addComponentListener(this._eventHandler);
            ((Window)((Object)ideMainWindow)).addWindowListener(this._eventHandler);
            ((Window)((Object)ideMainWindow)).addWindowFocusListener(this._eventHandler);
            ((Window)((Object)ideMainWindow)).addWindowStateListener(this._eventHandler);
            GlobalMouseDispatcher.getInstance().addMouseListener(this._eventHandler);
            this._selectionWindow = SelectionWindow.createWindow((JFrame)((Object)ideMainWindow), this._displayables);
            this._selectionWindow.setVisible(true);
            this._selectionWindow.getContentPane().repaint();
            KEY_MODIFIER_TRACKER.setPostProcessor(this._eventHandler);
        }
        return this._selectionWindow;
    }

    private void updateSelection() {
        if (this.getKeyModifiers() == 0) {
            this.activateSelectedWindow();
        } else {
            this.getSelectionWindow().setSelectedIndex(this._selectedIndex);
        }
    }

    private void selectWindow(MouseEvent mouseEvent) {
        if (this._selectionWindow != null) {
            this._selectedIndex = this._selectionWindow.getSelectedIndex(mouseEvent);
            if (this._selectedIndex >= 0) {
                this.activateSelectedWindow();
            }
        }
    }

    static void mav$selectWindow(WindowSelector windowSelector, MouseEvent mouseEvent) {
        windowSelector.selectWindow(mouseEvent);
    }

    private static final class KeyModifierTracker
    implements AWTEventListener {
        private static final KeyModifierTracker INSTANCE = new KeyModifierTracker();
        private static final int MODIFIER_MASK = 910;
        private Runnable _postProcessor;
        private int _keyModifiers;

        private KeyModifierTracker() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.addAWTEventListener(this, 8);
        }

        public static KeyModifierTracker getInstance() {
            return INSTANCE;
        }

        public int getModifiers() {
            return this._keyModifiers;
        }

        public void setPostProcessor(Runnable runnable) {
            this._postProcessor = runnable;
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            int n = keyEvent.getID();
            if (n == 401 || n == 402) {
                this._keyModifiers = keyEvent.getModifiers() & 0x38E;
                if (this._keyModifiers == 0 && this._postProcessor != null) {
                    SwingUtilities.invokeLater(this._postProcessor);
                    this._postProcessor = null;
                }
            }
        }
    }

    private static final class EventHandler
    implements WindowStateListener,
    WindowFocusListener,
    WindowListener,
    MouseListener,
    ComponentListener,
    Runnable {
        private final WindowSelector _windowSelector;

        EventHandler(WindowSelector windowSelector) {
            this._windowSelector = windowSelector;
        }

        public void run() {
            this._windowSelector.activateSelectedWindow();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.dispose();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.dispose();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.dispose();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            WindowSelector.mav$selectWindow(this._windowSelector, mouseEvent);
            this.dispose();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.dispose();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            this.dispose();
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        public void windowStateChanged(WindowEvent windowEvent) {
            this.dispose();
        }

        private void dispose() {
            this._windowSelector.dispose();
        }
    }

    private static final class SelectionWindow
    extends JWindow {
        private static final Border CELL_BORDER;
        private final NiceTable _table;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = SelectionWindow.class.desiredAssertionStatus() ^ true;
            CELL_BORDER = BorderFactory.createEmptyBorder(2, 3, 2, 3);
        }

        public static SelectionWindow createWindow(JFrame jFrame, Displayable[] displayableArray) {
            SelectionWindow selectionWindow = new SelectionWindow(jFrame, displayableArray);
            selectionWindow.pack();
            GraphicsUtils.centerWindowOnComponent(selectionWindow, jFrame);
            return selectionWindow;
        }

        private SelectionWindow(JFrame jFrame, Displayable[] displayableArray) {
            super(jFrame);
            if (!$assertionsDisabled && jFrame == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && displayableArray.length <= 1) {
                throw new AssertionError();
            }
            SelectionTableModel selectionTableModel = new SelectionTableModel(displayableArray);
            DisplayableCellRenderer displayableCellRenderer = new DisplayableCellRenderer(null);
            HeaderRenderer headerRenderer = new HeaderRenderer(null);
            this._table = new NiceTable((TableModel)selectionTableModel);
            this._table.setShowGrid(true);
            this._table.setFont(this._table.getFont().deriveFont(1));
            this._table.setDefaultRenderer(Displayable.class, (TableCellRenderer)displayableCellRenderer);
            this._table.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)headerRenderer));
            this._table.setRowHeight(this.measureRowHeight(displayableCellRenderer, displayableArray));
            this._table.autoSizeColumnsToFit();
            Dimension dimension = this._table.getPreferredSize();
            this._table.setPreferredScrollableViewportSize(dimension);
            JPanel jPanel = new JPanel(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane((Component)this._table);
            jScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
            jPanel.add((Component)jScrollPane, "Center");
            this.setFocusableWindowState(false);
            this.setContentPane(jPanel);
        }

        void setSelectedIndex(int n) {
            this._table.changeSelection(n, 0, false, false);
        }

        int getSelectedIndex() {
            return this._table.getSelectedRow();
        }

        int getSelectedIndex(MouseEvent mouseEvent) {
            int n = mouseEvent.getComponent() == this._table ? this._table.rowAtPoint(mouseEvent.getPoint()) : -1;
            this.setSelectedIndex(n);
            return n;
        }

        private int measureRowHeight(TableCellRenderer tableCellRenderer, Displayable[] displayableArray) {
            int n = 0;
            int n2 = displayableArray.length;
            while (n2-- > 0) {
                Displayable displayable = displayableArray[n2];
                String string = displayable.getShortLabel();
                Component component = tableCellRenderer.getTableCellRendererComponent((JTable)this._table, displayable, false, false, n2, 0);
                int n3 = (int)component.getPreferredSize().getHeight();
                n = Math.max(n, n3);
            }
            return n;
        }

        static Border ra$CELL_BORDER() {
            return CELL_BORDER;
        }

        private static final class SelectionTableModel
        extends AbstractTableModel {
            private static final String[] columns = new String[]{IdeImplArb.getString(96)};
            private final Displayable[] _displayables;

            public SelectionTableModel(Displayable[] displayableArray) {
                this._displayables = displayableArray;
            }

            public int getColumnCount() {
                return columns.length;
            }

            public String getColumnName(int n) {
                return columns[n];
            }

            public int getRowCount() {
                return this._displayables != null ? this._displayables.length : 0;
            }

            public Object getValueAt(int n, int n2) {
                return this._displayables[n];
            }

            public Class getColumnClass(int n) {
                return Displayable.class;
            }
        }

        private static final class HeaderRenderer
        extends NiceTableHeaderRenderer {
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.setBorder(SelectionWindow.ra$CELL_BORDER());
                return this;
            }

            private HeaderRenderer() {
            }

            HeaderRenderer(1 var1_1) {
                this();
            }

            public final class 1 {
            }
        }

        private static final class DisplayableCellRenderer
        extends DefaultTableCellRenderer {
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (object instanceof Displayable) {
                    Displayable displayable = (Displayable)object;
                    this.setIcon(displayable.getIcon());
                    this.setText(displayable.getShortLabel());
                    this.setToolTipText(displayable.getLongLabel());
                }
                this.setBorder(SelectionWindow.ra$CELL_BORDER());
                return this;
            }

            private DisplayableCellRenderer() {
            }

            DisplayableCellRenderer(1 var1_1) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

