/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import oracle.ide.IdeConstants;

public class WindowingConstants {
    public static final int DIVIDER_SIZE = 4;
    public static final Color COLOR_BACKGROUND = WindowingConstants.getBackgroundColor();
    public static final Border FLAT_COMPOUND_BORDER = WindowingConstants.getFlatCompoundBorder();
    public static final Color CONTROL_SHADOW_COLOR;
    public static final Color DRAG_FEEDBACK_BACKGROUND;
    public static final Color DRAG_FEEDBACK_OUTLINE;

    static {
        DRAG_FEEDBACK_BACKGROUND = new Color(32, 64, 255, 64);
        DRAG_FEEDBACK_OUTLINE = Color.blue;
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Color color = uIDefaults.getColor("controlShadow");
        CONTROL_SHADOW_COLOR = color != null ? color : SystemColor.controlShadow;
    }

    private static Border getFlatCompoundBorder() {
        return new RoundedLineBorder(IdeConstants.COLOR_IDE_LINES);
    }

    private static Color getBackgroundColor() {
        Color color = UIManager.getColor("Panel.background");
        return new Color((int)((double)color.getRed() * 0.92), (int)((double)color.getGreen() * 0.92), (int)((double)color.getBlue() * 0.92));
    }

    private static final class RoundedLineBorder
    extends LineBorder {
        public RoundedLineBorder(Color color) {
            super(color);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.getLineColor());
            graphics.translate(n, n2);
            graphics.drawLine(1, 0, n3 - 2, 0);
            graphics.drawLine(0, 1, 0, n4 - 2);
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }
}

