/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.importexport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.ImportExportArb;
import oracle.ide.util.ResourceUtils;
import oracle.ideri.importexport.ImportExportInvoker;

class ImportExportWizard
extends JPanel {
    private final Component _parent;
    private final Context _context;
    private final List _invokers;
    private final int _titleIndex;
    private final int _labelIndex;
    private final String _helpTag;
    private CheckBoxList _list;
    private CheckBoxListModel _listModel;
    private int _selectedIndex;
    private JEWTDialog _dlg;

    void $init$() {
        this._list = new CheckBoxList();
        this._listModel = new CheckBoxListModel();
    }

    public ImportExportWizard(Component component, Context context, List list, int n, int n2, String string) throws Exception {
        this.$init$();
        this._parent = component;
        this._context = context;
        this._invokers = list;
        this._titleIndex = n;
        this._labelIndex = n2;
        this._helpTag = string;
        this.jbInit();
    }

    public ImportExportInvoker getSelectedWizard() {
        return (ImportExportInvoker)this._listModel.getUserObjectAt(this._selectedIndex);
    }

    public boolean runDialog() {
        this._dlg = JEWTDialog.createDialog((Component)this._parent, (String)ImportExportArb.getString(this._titleIndex), (int)7);
        this._dlg.setCenterOver(this._parent);
        this._dlg.setContent((Component)this);
        this._dlg.setInitialFocus((Component)this._list);
        this._dlg.setResizable(true);
        this._dlg.setPreferredSize(350, 250);
        this.setOKEnabled();
        try {
            boolean bl = this._dlg.runDialog();
            this._dlg.dispose();
            return bl;
        }
        catch (Throwable throwable) {
            this._dlg.dispose();
            throw throwable;
        }
    }

    private void jbInit() throws Exception {
        this.populateListModel(this._invokers);
        this._list.setModel(this._listModel);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel(jLabel, this._list, ImportExportArb.getString(this._labelIndex));
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._list.setSelectionMode(0);
        this._list.setSelectedIndex(0);
        this._list.addListSelectionListener(new 2());
        this._list.addMouseListener(new 1());
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic(this, this._helpTag);
        }
    }

    private void populateListModel(List list) throws Exception {
        for (ImportExportInvoker importExportInvoker : list) {
            if (!importExportInvoker.isAvailable(this._context)) continue;
            this._listModel.addElement((Object)importExportInvoker, importExportInvoker.getIcon(this._context), importExportInvoker.getName(this._context), importExportInvoker.getToolTipText(this._context));
        }
        this._listModel.sort();
    }

    private void list_mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this._list.locationToIndex(mouseEvent.getPoint())) != -1) {
            this._selectedIndex = n;
            this._dlg.setVisible(false);
        }
    }

    private void list_valueChanged() {
        this._selectedIndex = this._list.getSelectedIndex();
        this.setOKEnabled();
    }

    private void setOKEnabled() {
        this._dlg.setOKButtonEnabled(this._listModel.getSize() > 0 && this._selectedIndex != -1);
    }

    static void mav$list_valueChanged(ImportExportWizard importExportWizard) {
        importExportWizard.list_valueChanged();
    }

    static void mav$list_mouseClicked(ImportExportWizard importExportWizard, MouseEvent mouseEvent) {
        importExportWizard.list_mouseClicked(mouseEvent);
    }

    final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ImportExportWizard.mav$list_valueChanged(ImportExportWizard.this);
        }
    }

    final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            ImportExportWizard.mav$list_mouseClicked(ImportExportWizard.this, mouseEvent);
        }
    }
}

