/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import java.awt.Component;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.ViewId;
import oracle.ide.model.DefaultFilter;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.Extension;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.NavigatorArb;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.ideri.navigator.NavigatorDockableFactory;
import oracle.ideri.navigator.dnd.ProjectNodeDropHelper;
import oracle.ideri.navigator.dnd.TransferableProject;
import oracle.ideri.navigator.dnd.WorkspaceNodeDropHelper;
import oracle.javatools.dialogs.MessageDialog;

public abstract class DefaultNavigatorManager
extends NavigatorManager {
    private static final int SEARCH_CURRENT_PROJECT = 0;
    private static final int SEARCH_CURRENT_WORKSPACE = 1;
    private static final int SEARCH_ALL_WORKSPACES = 2;
    private DockableFactory _dockableFactory;
    private String _tabName;
    private String _titleName;

    static {
        DragDropManager dragDropManager = DragDropManager.getInstance();
        TransferableProject transferableProject = new TransferableProject();
        dragDropManager.registerDragHelperForInstance(transferableProject, TransferableProject.DRAG_NODE_TYPE);
        ProjectNodeDropHelper projectNodeDropHelper = new ProjectNodeDropHelper();
        dragDropManager.registerDropHelperForInstance(projectNodeDropHelper, ProjectNodeDropHelper.DROP_NODE_TYPE);
        WorkspaceNodeDropHelper workspaceNodeDropHelper = new WorkspaceNodeDropHelper();
        dragDropManager.registerDropHelperForInstance(workspaceNodeDropHelper, WorkspaceNodeDropHelper.DROP_TARGET_TYPE);
    }

    protected final IdeAction createShowAction() {
        IdeAction ideAction = this.createShowNavigatorAction();
        ideAction.addController(new 2(this, ideAction));
        return ideAction;
    }

    protected abstract IdeAction createShowNavigatorAction();

    protected DockableFactory createDockableFactory() {
        return new 1(this);
    }

    protected DockingParam createNavigatorDockingParam() {
        return new DockingParam();
    }

    public ViewId getViewId(Context context) {
        Element element;
        if (context != null && (element = DefaultNavigatorManager.getFolderFromContext(context)) != null) {
            return this.newViewId(element);
        }
        return null;
    }

    protected final DockableView createDockableView(Context context, ViewId viewId) {
        if (viewId == null && (viewId = this.getViewId(context)) == null) {
            return null;
        }
        DefaultNavigatorWindow defaultNavigatorWindow = this.createNavigatorWindow(context, viewId);
        defaultNavigatorWindow.setManager(this);
        this.initNavigatorWindow(defaultNavigatorWindow, context, viewId);
        return defaultNavigatorWindow;
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new DefaultNavigatorWindow(context, viewId.getId());
    }

    protected void initNavigatorWindow(DefaultNavigatorWindow defaultNavigatorWindow, Context context, ViewId viewId) {
        this.initNavigatorWindowComparator(defaultNavigatorWindow);
        if (!this.isSystemNavigator(viewId)) {
            defaultNavigatorWindow.setType(1);
            defaultNavigatorWindow.setRootVisible(true);
            defaultNavigatorWindow.initSelection();
        }
        this.configureNavigator(defaultNavigatorWindow);
    }

    protected void initNavigatorWindowComparator(DefaultNavigatorWindow defaultNavigatorWindow) {
        defaultNavigatorWindow.setComparator(DefaultFilter.folderFirstComparator);
    }

    protected final DockableFactory getDockableFactory() {
        if (this._dockableFactory == null) {
            this._dockableFactory = this.createDockableFactory();
        }
        return this._dockableFactory;
    }

    protected void configureNavigator(NavigatorWindow navigatorWindow) {
        if (navigatorWindow instanceof DefaultNavigatorWindow) {
            ((DefaultNavigatorWindow)navigatorWindow).setSaveExpansionState(true);
        }
    }

    public ContextMenu getContextMenu() {
        return DefaultNavigatorWindow.getOrCreateContextMenu();
    }

    protected final NavigatorWindow createNavigatorWindow(Folder folder, boolean bl, int n) {
        return this.createNavigatorWindow(folder, null, null, bl, n);
    }

    protected final NavigatorWindow createNavigatorWindow(Folder folder, String string, String string2, boolean bl, int n) {
        Context context = Context.newIdeContext(folder);
        context.setProject(null);
        context.setWorkspace(null);
        ViewId viewId = this.getDefaultViewId();
        DefaultNavigatorWindow defaultNavigatorWindow = (DefaultNavigatorWindow)this.createView(context, viewId);
        defaultNavigatorWindow.setRootVisible(bl);
        if (n != 0) {
            defaultNavigatorWindow.setDefaultVisibility(n);
        }
        return defaultNavigatorWindow;
    }

    public NavigatorWindow openNavigator(Context context) {
        NavigatorWindow navigatorWindow = this.findNavigatorWindow(context);
        if (navigatorWindow == null) {
            navigatorWindow = this.getNavigatorWindow();
        }
        this.openNavigatorNode(navigatorWindow, context);
        return navigatorWindow;
    }

    public void addContextMenuListener(ContextMenuListener contextMenuListener, Class clazz) {
        DefaultNavigatorWindow.getOrCreateContextMenu().addContextMenuListener(contextMenuListener, clazz);
    }

    public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
        DefaultNavigatorWindow.getOrCreateContextMenu().removeContextMenuListener(contextMenuListener);
    }

    public void registerExtension(Extension extension, Class clazz) {
        DefaultNavigatorWindow.registerExtension(extension, clazz);
    }

    NavigatorWindow createView(Context context, ViewId viewId) {
        return (NavigatorWindow)this.getNewView(context, viewId);
    }

    static Element getFolderFromContext(Context context) {
        Element element = context.getElement();
        if (!(element != null && element.mayHaveChildren() || (element = context.getProject()) != null || (element = context.getWorkspace()) != null)) {
            return Ide.getSystem();
        }
        return element;
    }

    private ViewId newViewId(Element element) {
        String string = element == Ide.getWorkspaces() ? this.getDefaultName() : (element instanceof Locatable ? ((Locatable)((Object)element)).getURL().getFile() : Long.toString(System.currentTimeMillis()));
        return new ViewId(this.getViewCategory(), string);
    }

    private ViewId newElementViewId(Context context) {
        Element element;
        if (context != null && (element = context.getElement()) != null && element.mayHaveChildren()) {
            return this.newViewId(element);
        }
        return null;
    }

    private ViewId newProjectViewId(Context context) {
        Project project;
        if (context != null && (project = context.getProject()) != null) {
            return this.newViewId(project);
        }
        return null;
    }

    private ViewId newWorkspaceViewId(Context context) {
        Workspace workspace;
        if (context != null && (workspace = context.getWorkspace()) != null) {
            return this.newViewId(workspace);
        }
        return null;
    }

    private NavigatorWindow findNavigatorWindow(Context context) {
        DockableView dockableView = this.findView(this.newElementViewId(context));
        if (dockableView == null && (dockableView = this.findView(this.newProjectViewId(context))) == null) {
            dockableView = this.findView(this.newWorkspaceViewId(context));
        }
        return (NavigatorWindow)dockableView;
    }

    private boolean openNavigatorNode(NavigatorWindow navigatorWindow, Context context) {
        TNode tNode;
        TNode tNode2;
        int n;
        Folder folder;
        Element element;
        if (navigatorWindow == null || context == null) {
            return false;
        }
        TreeExplorer treeExplorer = navigatorWindow.getTreeExplorer();
        if (treeExplorer == null) {
            return false;
        }
        boolean bl = false;
        if (context.containsProperty("navigate_cmd_suppress_confirmation")) {
            bl = context.getBoolean("navigate_cmd_suppress_confirmation");
        }
        if ((element = context.getNode()) == null) {
            element = DefaultNavigatorManager.getFolderFromContext(context);
        }
        Project project = context.getProject();
        if (element instanceof Workspaces) {
            project = null;
            folder = Ide.getSystem();
        } else if (element instanceof Workspace) {
            project = null;
            folder = Ide.getWorkspaces();
        } else if (element instanceof Project) {
            project = null;
            folder = context.getWorkspace();
        } else {
            folder = project;
        }
        if (folder == null) {
            n = 2;
        } else if (folder.containsChild(element)) {
            n = 0;
        } else if (bl) {
            n = 0;
        } else {
            NotInFolderPanel notInFolderPanel = new NotInFolderPanel(element, folder);
            if (!OnePageWizardDialogFactory.runDialog(notInFolderPanel, DefaultNavigatorManager.getSubDialogTitle())) {
                return false;
            }
            n = notInFolderPanel.getChoice();
        }
        if (project != null) {
            TNode tNode3;
            TNode tNode4;
            Workspaces workspaces = Ide.getWorkspaces();
            TNode tNode5 = treeExplorer.searchTNode(workspaces, null);
            if (tNode5 != null) {
                treeExplorer.open(tNode5);
            }
            Workspace workspace = context.getWorkspace();
            if (n != 2) {
                if (workspace != null) {
                    tNode4 = treeExplorer.searchTNode(workspace, tNode5);
                    if (tNode4 != null) {
                        treeExplorer.open(tNode4);
                    }
                } else {
                    tNode4 = tNode5;
                }
                if (n != 1) {
                    tNode3 = treeExplorer.searchTNode(project, tNode4);
                    if (tNode3 != null) {
                        treeExplorer.open(tNode3);
                    }
                } else {
                    tNode3 = tNode4;
                }
            } else {
                tNode4 = tNode3 = tNode5;
            }
            tNode2 = element instanceof Workspaces ? tNode5 : (element instanceof Workspace ? (element == workspace ? tNode4 : tNode5) : (element instanceof Project ? (element == project ? tNode3 : tNode4) : tNode3));
        } else {
            tNode2 = treeExplorer.searchTNode(folder, null);
        }
        if (this.hasWorkingSetSupport(navigatorWindow)) {
            Project project2;
            if (tNode2 == null) {
                project2 = this.findContainingProject(element, treeExplorer);
            } else if (tNode2.getData() instanceof Workspace) {
                project2 = this.findContainingProject(element, (Workspace)tNode2.getData());
            } else {
                Project project3 = project2 = project.containsChild(element) ? project : null;
            }
            if (project2 != null && !this.shouldAddToWorkingSet(element, project2, navigatorWindow, bl)) {
                return false;
            }
        }
        if ((tNode = treeExplorer.findTNode(element, tNode2)) != null) {
            Workspace workspace = (Workspace)tNode.getAncestor(Workspace.class, true);
            Project project4 = (Project)tNode.getAncestor(Project.class, true);
            if (project4 != context.getProject() || workspace != context.getWorkspace()) {
                Context context2 = new Context(context);
                context2.setProject(project4);
                context2.setWorkspace(workspace);
                EditorManager.getEditorManager().replaceEditors(context, context2);
            }
            treeExplorer.setSelected(tNode);
            navigatorWindow.show();
            DockStation.getDockStation().activateDockable(navigatorWindow);
            return true;
        }
        if (!bl) {
            MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)NavigatorArb.format(5, element.getShortLabel()), (String)DefaultNavigatorManager.getSubDialogTitle(), (String)"");
        }
        return false;
    }

    private static String getSubDialogTitle() {
        return StringUtils.stripMnemonic((String)IdeArb.getString(352));
    }

    private boolean shouldAddToWorkingSet(Element element, Project project, NavigatorWindow navigatorWindow, boolean bl) {
        WorkingSet workingSet;
        if (this.hasWorkingSetSupport(navigatorWindow) && (workingSet = this.getEditableWorkingSet(project)) != null) {
            URL uRL = ((Locatable)((Object)element)).getURL();
            URLPath uRLPath = ProjectContent.getInstance(project).getAllContents().getAllRootDirs();
            String string = uRLPath.toRelativePath(uRL);
            PatternFilters patternFilters = workingSet.getPatternFilters();
            if (!patternFilters.isIncluded(string)) {
                if (bl || MessageDialog.optionalConfirm((String)"add-to-working-set", (Component)((Object)Ide.getMainWindow()), (String)NavigatorArb.format(7, element.getShortLabel(), project.getShortLabel()), (String)DefaultNavigatorManager.getSubDialogTitle(), (String)"f1_idedaddtoworkingset_html")) {
                    patternFilters.addInclude(string);
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    private WorkingSet getEditableWorkingSet(Project project) {
        WorkingSet workingSet = WorkingSets.getInstance(project).getCurrentWorkingSet();
        if (!WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(workingSet.getName())) {
            return workingSet;
        }
        return null;
    }

    private Project findContainingProject(Element element, TreeExplorer treeExplorer) {
        Enumeration enumeration = treeExplorer.getRoot().getChildTNodes();
        while (enumeration.hasMoreElements()) {
            Project project;
            TNode tNode = (TNode)enumeration.nextElement();
            if (!(tNode.getData() instanceof Workspace) || (project = this.findContainingProject(element, (Workspace)tNode.getData())) == null) continue;
            return project;
        }
        return null;
    }

    private Project findContainingProject(Element element, Workspace workspace) {
        Iterator iterator = workspace.getChildren();
        while (iterator.hasNext()) {
            Project project;
            Element element2 = (Element)iterator.next();
            if (!(element2 instanceof Project) || !(project = (Project)element2).containsChild(element)) continue;
            return project;
        }
        return null;
    }

    private boolean hasWorkingSetSupport(NavigatorWindow navigatorWindow) {
        Context context = navigatorWindow.getContext();
        return context.getBoolean("enable-working-sets");
    }

    static boolean mav$isToolbarVisible(DefaultNavigatorManager defaultNavigatorManager) {
        return defaultNavigatorManager.isToolbarVisible();
    }

    public final class 2
    implements Controller {
        private final /* synthetic */ IdeAction v$showAction;
        final /* synthetic */ DefaultNavigatorManager this$0;

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction == this.v$showAction) {
                NavigatorWindow navigatorWindow = this.this$0.getNavigatorWindow();
                if (navigatorWindow != null) {
                    navigatorWindow.setToolbarVisible(DefaultNavigatorManager.mav$isToolbarVisible(this.this$0));
                    DockUtil.showDockableWindow(navigatorWindow);
                }
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction == this.v$showAction) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }

        public 2(DefaultNavigatorManager defaultNavigatorManager, IdeAction ideAction) {
            this.v$showAction = ideAction;
            this.this$0 = defaultNavigatorManager;
        }
    }

    public final class 1
    extends NavigatorDockableFactory {
        protected DockingParam createDockingParam() {
            return DefaultNavigatorManager.this.createNavigatorDockingParam();
        }

        public 1(NavigatorManager navigatorManager) {
            super(navigatorManager);
        }
    }

    private static final class NotInFolderPanel
    extends JPanel {
        protected static final String HELP_TOPIC = "f1_idedlocateinnavigator_html";
        private static int lastChoice = 1;
        private JLabel message;
        private ButtonGroup buttonGroup;
        private JRadioButton searchCurrentWorkspace;
        private JRadioButton searchAllWorkspaces;

        void $init$() {
            this.message = new JLabel();
            this.buttonGroup = new ButtonGroup();
            this.searchCurrentWorkspace = new JRadioButton();
            this.searchAllWorkspaces = new JRadioButton();
        }

        protected NotInFolderPanel(Element element, Folder folder) {
            this.$init$();
            HelpSystem.getHelpSystem().registerTopic(this, HELP_TOPIC);
            this.buttonGroup.add(this.searchCurrentWorkspace);
            this.buttonGroup.add(this.searchAllWorkspaces);
            this.setChoice(lastChoice);
            this.message.setText(NavigatorArb.format(6, element.getShortLabel(), folder != null ? folder.getShortLabel() : ""));
            ResourceUtils.resButton(this.searchCurrentWorkspace, NavigatorArb.getString(8));
            ResourceUtils.resButton(this.searchAllWorkspaces, NavigatorArb.getString(9));
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.message);
            this.add(Box.createVerticalStrut(15));
            this.add(this.searchCurrentWorkspace);
            this.add(Box.createVerticalStrut(5));
            this.add(this.searchAllWorkspaces);
        }

        protected int getChoice() {
            lastChoice = this.searchCurrentWorkspace.isSelected() ? 1 : 2;
            return lastChoice;
        }

        protected void setChoice(int n) {
            if (n == 1) {
                this.searchCurrentWorkspace.setSelected(true);
            } else {
                this.searchAllWorkspaces.setSelected(true);
            }
        }
    }
}

