/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.AbstractLayoutListener;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layout;
import oracle.ide.layout.URL2String;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.Extension;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.NavigatorArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.ProfileIDs;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.NavigatorController;
import oracle.ideri.navigator.NavigatorPrintFactory;
import oracle.ideri.util.Product;

public class DefaultNavigatorWindow
extends NavigatorWindow {
    private static final String ROOT_PROP = ".root";
    private static final String EXPAND_DATA_COUNT_PROP = "expandData.count";
    private static final String EXPAND_DATA_PROP = "expandData{0}";
    private static final String EXPAND_DATA_NODE_PATH_PROP = ".nodePath";
    private static final String EXPAND_DATA_URL_PROP = ".url";
    private static final String NAVIGATOR_SELECTION_PROP = "selectionRow";
    private static ContextMenu _contextMenu;
    private static final HashMap _extensions;
    private final Element _rootFolder;
    private final Project _project;
    private final Workspace _workspace;
    private NavigatorController _controller;
    private BaseTreeExplorer _explorer;
    private PropertyAccess _properties;
    private Comparator _comparator;
    private boolean _comparatorSet;
    private Comparator _rootComparator;
    private boolean _rootComparatorSet;
    private boolean _rootVisible;
    private boolean _rootVisibleSet;
    private boolean _initSelection;
    private String _title;
    private JPanel _host;
    private Toolbar _toolbar;
    private boolean _toolbarVisible;
    private boolean _toolbarVisibleSet;
    private int _defaultVisibility;
    private NavigatorManager _manager;
    private boolean _saveExpansionState;

    static {
        _extensions = new HashMap();
    }

    void $init$() {
        this._saveExpansionState = false;
    }

    protected DefaultNavigatorWindow(Context context, String string) {
        this(Ide.getMainWindow().getIdeMainWindowView(), context, string);
    }

    private DefaultNavigatorWindow(View view, Context context, String string) {
        Element element;
        this.$init$();
        this.setOwner(view);
        this.setId(string);
        this.setType(32);
        this._rootFolder = element = DefaultNavigatorManager.getFolderFromContext(context);
        this._project = context.getProject();
        this._workspace = context.getWorkspace();
        PrintManager printManager = PrintManager.getPrintManager();
        if (printManager != null) {
            printManager.registerDocumentPrintFactory(NavigatorWindow.class, NavigatorPrintFactory.class);
        }
    }

    public void setRootVisible(boolean bl) {
        if (this.getTreeExplorer() == null) {
            this._rootVisibleSet = true;
            this._rootVisible = bl;
        } else {
            JTree jTree = this.getTree();
            if (jTree != null) {
                jTree.setRootVisible(bl);
                jTree.setShowsRootHandles(bl ^ true);
            }
        }
    }

    public void collapse(TNode tNode, boolean bl) {
        if (this._explorer != null) {
            this._explorer.collapse(tNode, bl);
        }
    }

    public void expand(TNode tNode, boolean bl) {
        if (this._explorer != null) {
            this._explorer.expand(tNode, bl);
        }
    }

    public TNode findTNode(Element element, TNode tNode) {
        return this._explorer != null ? this._explorer.findTNode(element, tNode) : null;
    }

    public void refresh(TNode tNode) {
        if (this._explorer != null) {
            this._explorer.refresh(tNode);
        }
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void setComparator(Comparator comparator) {
        TreeExplorer treeExplorer = this.getTreeExplorer();
        if (treeExplorer != null) {
            treeExplorer.setComparator(comparator);
        } else {
            this._comparatorSet = true;
            this._comparator = comparator;
        }
    }

    public void setSelected(TNode tNode) {
        if (this._explorer != null) {
            this._explorer.setSelected(tNode);
        }
    }

    public TreeExplorer getTreeExplorer() {
        return this._explorer;
    }

    public NavigatorManager getManager() {
        return this._manager;
    }

    public void setManager(NavigatorManager navigatorManager) {
        this._manager = navigatorManager;
    }

    public Component getGUI() {
        if (this._host == null) {
            this._host = new JPanel(new BorderLayout());
            this.createTree();
            if (this._comparatorSet) {
                this.setComparator(this._comparator);
                this._comparator = null;
                this._comparatorSet = false;
            }
            if (this._rootVisibleSet) {
                this.setRootVisible(this._rootVisible);
                this._rootVisibleSet = false;
            }
            if (this._initSelection) {
                this.initSelection();
                this._initSelection = false;
            }
            if (this._rootComparatorSet) {
                TNode tNode = this.getTreeExplorer().getRoot();
                tNode.setComparator(this._rootComparator);
                this._rootComparatorSet = false;
                this._rootComparator = null;
            }
            if (this._toolbarVisibleSet) {
                this.setToolbarVisible(this._toolbarVisible);
                this._toolbarVisibleSet = false;
            }
            if (this._properties != null) {
                this.loadLayout(this._properties);
                this._properties = null;
            }
        }
        return this._host;
    }

    protected final Element[] getSelectionFromUI() {
        return this._explorer != null ? this._explorer.getSelection() : super.getSelectionFromUI();
    }

    public Context getContext(EventObject eventObject) {
        Context context = this._explorer != null ? new Context(this._explorer.getContext(eventObject)) : Context.newIdeContext();
        context.setView(this);
        Extension extension = DefaultNavigatorWindow.findExtension(context.getElement());
        if (extension != null) {
            context = extension.updateContext(context, ExplorerContext.getTNodes(context));
        }
        if (context.getProject() == null) {
            context.setProject(this._project);
        }
        if (context.getWorkspace() == null) {
            context.setWorkspace(this._workspace);
        }
        return context;
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new NavigatorController();
        }
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        return DefaultNavigatorWindow.getOrCreateContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return this.getManager().getHelpInfo();
    }

    public String getTabName() {
        if (Product.isJDeveloper() && NavigatorManager.getWorkspaceNavigatorManager().isSystemNavigator(new ViewId(this.getId()))) {
            return NavigatorArb.getString(10);
        }
        return this._rootFolder.getShortLabel();
    }

    public String getTitleName() {
        String string = !this.getTitle().equals(this.getTabName()) ? this.getTabName() + " " + this.getTitle() : this.getTitle();
        AccessibleUtils.updateAccessibleName(this.getTree(), string, false);
        return string;
    }

    public Icon getTabIcon() {
        return this._rootFolder.getIcon();
    }

    public String getMenuTitle() {
        String string = this.getId();
        if (NavigatorManager.getWorkspaceNavigatorManager().isSystemNavigator(new ViewId(string))) {
            return IdeArb.getString(155);
        }
        return super.getMenuTitle();
    }

    public void saveLayout(PropertyAccess propertyAccess) {
        if (this._host == null) {
            return;
        }
        String string = this.getId();
        DefaultNavigatorWindow.saveContext(string, this.getRoot(), this._project, this._workspace);
        this.getTreeExplorer().saveFilters(propertyAccess);
        if (this.isSaveExpansionState() && Ide.getEnvironOptions().isRememberNavigatorExpansionState()) {
            this.saveExpansionState(propertyAccess);
            this.saveSelection(propertyAccess);
        }
    }

    public void loadLayout(PropertyAccess propertyAccess) {
        if (this._host == null) {
            this._properties = propertyAccess;
            return;
        }
        int n = 0;
        if (ProfileIDs.PROFILE_LOADLAYOUT3) {
            n = IdeProfile.startEvent(3308);
        }
        this.getId();
        this.getTreeExplorer().openFilters(propertyAccess);
        if (Ide.isStarting() && Ide.getEnvironOptions().isRememberNavigatorExpansionState()) {
            try {
                this.restoreExpansionState(propertyAccess);
                this.restoreSelection(propertyAccess);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (ProfileIDs.PROFILE_LOADLAYOUT3) {
            IdeProfile.endEvent(n);
        }
    }

    public void stateChange(int n) {
        super.stateChange(n);
        switch (n) {
            case 1: {
                this.updateVisibleActions();
                break;
            }
            case 3: {
                if ((this.getType() & 1) == 0) break;
                this.removeToolbar();
                if (this._explorer == null) break;
                this._explorer.dispose();
            }
        }
    }

    public void setToolbarVisible(boolean bl) {
        if (this.getTreeExplorer() == null) {
            this._toolbarVisibleSet = true;
            this._toolbarVisible = bl;
            return;
        }
        if (bl) {
            this.createToolbar();
        } else {
            this.removeToolbar();
        }
    }

    public void setDefaultVisibility(int n) {
        this._defaultVisibility = n;
    }

    public int getDefaultVisibility(Layout layout) {
        return this._defaultVisibility;
    }

    protected boolean coalesceTreeExplorerUpdates() {
        return true;
    }

    protected void setTitle(String string) {
        this._title = string;
    }

    protected String getTitle() {
        if (this._title == null) {
            this._title = NavigatorArb.getString(4);
        }
        return this._title;
    }

    protected JTree getTree() {
        return this._explorer != null ? this._explorer.getJTree() : null;
    }

    private Element getRoot() {
        return this._rootFolder;
    }

    protected boolean canFireViewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        View view = viewSelectionEvent.getView();
        return view == Ide.getMainWindow().getLastActiveView();
    }

    protected void fireViewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        if (!this.canFireViewSelectionChanged(viewSelectionEvent)) {
            return;
        }
        super.fireViewSelectionChanged(viewSelectionEvent);
        View view = viewSelectionEvent.getView();
        View view2 = Ide.getMainWindow().getLastActiveView();
        if (view == view2) {
            this.updateActiveNode();
            Element[] elementArray = viewSelectionEvent.getSelection();
            if (elementArray != null && elementArray.length > 0) {
                Element element = elementArray[0];
                this.updateStatusBar(element);
            }
        }
    }

    protected boolean isSaveExpansionState() {
        return this._saveExpansionState;
    }

    protected void setSaveExpansionState(boolean bl) {
        this._saveExpansionState = bl;
    }

    protected static void registerExtension(Extension extension, Class clazz) {
        _extensions.put(clazz, extension);
    }

    protected static ContextMenu getOrCreateContextMenu() {
        if (_contextMenu == null) {
            _contextMenu = new ContextMenu(new MnemonicSolver());
        }
        return _contextMenu;
    }

    protected void initSelection() {
        if (this._explorer == null || this._explorer.getJTree() == null) {
            this._initSelection = true;
            return;
        }
        JTree jTree = this._explorer.getJTree();
        int n = jTree.getRowCount();
        if (n > 0) {
            if (jTree.isRootVisible()) {
                jTree.setSelectionRow(0);
            } else if (n > 1) {
                jTree.setSelectionRow(1);
            }
        }
    }

    private static void saveContext(String string, Element element, Project project, Workspace workspace) {
        IdeProperties ideProperties = Ide.getIdeProperties();
        String string2 = string + ROOT_PROP;
        if (element instanceof Node && element instanceof Folder) {
            URL uRL = ((Node)element).getURL();
            if (uRL != null) {
                ideProperties.setProperty(string2, URL2String.toString(uRL));
            }
        } else {
            ViewId viewId = new ViewId(string);
            ideProperties.setProperty(string2, viewId.getName());
        }
        string2 = string + ".project";
        if (project != null) {
            ideProperties.setProperty(string2, URL2String.toString(project.getURL()));
        }
        string2 = string + ".workspace";
        if (workspace != null) {
            ideProperties.setProperty(string2, URL2String.toString(workspace.getURL()));
        }
    }

    static Context loadContext(String string) {
        IdeProperties ideProperties = Ide.getIdeProperties();
        String string2 = string + ROOT_PROP;
        Node node = AbstractLayoutListener.getNode(string2, ideProperties);
        Context context = Context.newIdeContext(node);
        if (node instanceof Folder) {
            context.setProject(AbstractLayoutListener.getProject(string, ideProperties));
            context.setWorkspace(AbstractLayoutListener.getWorkspace(string, ideProperties));
        }
        return context;
    }

    static void clearContext(String string) {
        IdeProperties ideProperties = Ide.getIdeProperties();
        String string2 = string + ROOT_PROP;
        ideProperties.setProperty(string2, null);
        string2 = string + ".project";
        ideProperties.setProperty(string2, null);
        string2 = string + ".workspace";
        ideProperties.setProperty(string2, null);
    }

    private String getViewType() {
        return new ViewId(this.getId()).getType();
    }

    private void createToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            String string = this.getToolbarId();
            if (string != null) {
                DefaultNavigatorWindow.loadManifestToolbar(string, this._toolbar, this);
            }
            this.updateVisibleActions();
            this._host.add((Component)this._toolbar, "North");
            this._host.revalidate();
        }
    }

    protected String getToolbarId() {
        return this.getViewType() + ".Toolbar";
    }

    private void removeToolbar() {
        if (this._toolbar != null) {
            this._host.remove(this._toolbar);
            this._host.revalidate();
            this._toolbar.dispose();
            this._toolbar = null;
        }
    }

    private void updateActiveNode() {
        Context context = this.getContext();
        if (context.getView() != this) {
            return;
        }
        TNode[] tNodeArray = ExplorerContext.getTNodes(context);
        if (tNodeArray == null || tNodeArray.length == 0) {
            return;
        }
        TNode tNode = tNodeArray[0].getAncestorTNode(Project.class, true);
        if (tNode == null) {
            TNode tNode2 = tNodeArray[0].getAncestorTNode(Workspace.class, false);
            if (tNode2 == null) {
                return;
            }
            tNode = this.findActiveProjectTNode(tNode2);
        }
        this._explorer.updateActiveNode(tNode);
    }

    private TNode findActiveProjectTNode(TNode tNode) {
        if (!tNode.isSet(TNodeConstants.IS_OPENED)) {
            return null;
        }
        Enumeration<? extends TreeNode> enumeration = tNode.children();
        Workspace workspace = (Workspace)tNode.getData();
        Project project = workspace.currentActiveProject();
        while (enumeration.hasMoreElements()) {
            TNode tNode2 = (TNode)enumeration.nextElement();
            if (tNode2.getData() != project) continue;
            return tNode2;
        }
        return null;
    }

    private void createTree() {
        int n = 0;
        if (ProfileIDs.PROFILE_CREATETREE) {
            n = IdeProfile.startEvent(3307);
        }
        Context context = Context.newIdeContext(this._rootFolder);
        context.setView(this);
        context.setProject(this._project);
        context.setWorkspace(this._workspace);
        boolean bl = this.coalesceTreeExplorerUpdates();
        this._explorer = new 1NavigatorTreeExplorer(this, this, bl);
        this._explorer.setOverlayCache(IconOverlayCache.getInstance());
        this._explorer.getOverlayCache().registerOverlayConsumer(this._explorer);
        3 var4_4 = new 3();
        this._explorer.addViewSelectionListener(var4_4);
        this._explorer.setContext(context);
        this._explorer.getJTree();
        JComponent jComponent = (JComponent)this._explorer.getGUI();
        this._host.add((Component)jComponent, "Center");
        this.initSelection();
        if (ProfileIDs.PROFILE_CREATETREE) {
            IdeProfile.endEvent(n);
        }
    }

    private void updateStatusBar(Displayable displayable) {
        String string = displayable.getLongLabel();
        Ide.getStatusBar().setText(string);
    }

    private static Extension findExtension(Element element) {
        if (element == null) {
            return null;
        }
        Class<?> clazz = element.getClass();
        Extension extension = (Extension)_extensions.get(clazz);
        if (extension != null) {
            return extension;
        }
        for (Class clazz2 : _extensions.keySet()) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            extension = (Extension)_extensions.get(clazz2);
            break;
        }
        return extension;
    }

    private void restoreExpansionState(PropertyAccess propertyAccess) {
        String string = EXPAND_DATA_COUNT_PROP;
        String string2 = propertyAccess.getProperty(EXPAND_DATA_COUNT_PROP, "0");
        int n = Integer.parseInt(string2);
        if (n <= 0) {
            return;
        }
        ArrayList<ExplorerContext.ExpandInfo> arrayList = new ArrayList<ExplorerContext.ExpandInfo>();
        int n2 = 0;
        while (n2 < n) {
            String string3 = MessageFormat.format(EXPAND_DATA_PROP, new Integer(n2));
            try {
                String string4 = propertyAccess.getProperty(string3 + EXPAND_DATA_NODE_PATH_PROP, null);
                if (string4 != null && string4.length() > 0) {
                    ExplorerContext.ExpandInfo expandInfo = new ExplorerContext.ExpandInfo(string4);
                    String string5 = propertyAccess.getProperty(string3 + EXPAND_DATA_URL_PROP, null);
                    if (string5 != null && string5.length() > 0) {
                        expandInfo._url = URL2String.toURL(string5);
                    }
                    arrayList.add(expandInfo);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            return;
        }
        this.openDataNodes(arrayList);
        this.restoreExpansionStateLater(this.getTreeExplorer(), arrayList);
    }

    private void openDataNodes(List list) {
        int n = 0;
        while (n < list.size()) {
            Node node;
            ExplorerContext.ExpandInfo expandInfo = (ExplorerContext.ExpandInfo)list.get(n);
            if (expandInfo._url != null && (node = NodeFactory.find(expandInfo._url)) != null) {
                try {
                    node.open();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    private void restoreExpansionStateLater(TreeExplorer treeExplorer, List list) {
        SwingUtilities.invokeLater(new 2(this, treeExplorer, list));
    }

    private void saveExpansionState(PropertyAccess propertyAccess) {
        TreeExplorer treeExplorer = this.getTreeExplorer();
        List list = ExplorerContext.storeExpansionState(treeExplorer.getRoot(), treeExplorer);
        String string = EXPAND_DATA_COUNT_PROP;
        propertyAccess.setProperty(EXPAND_DATA_COUNT_PROP, Integer.toString(list.size()));
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ExplorerContext.ExpandInfo expandInfo = (ExplorerContext.ExpandInfo)iterator.next();
            String string2 = expandInfo._nodePath;
            String string3 = MessageFormat.format(EXPAND_DATA_PROP, new Integer(n++));
            propertyAccess.setProperty(string3 + EXPAND_DATA_NODE_PATH_PROP, string2);
            if (expandInfo._url == null) continue;
            propertyAccess.setProperty(string3 + EXPAND_DATA_URL_PROP, URL2String.toString(expandInfo._url));
        }
    }

    private void saveSelection(PropertyAccess propertyAccess) {
        int n = this.getTreeExplorer().getJTree().getMinSelectionRow();
        if (n >= 0) {
            String string = NAVIGATOR_SELECTION_PROP;
            propertyAccess.setProperty(NAVIGATOR_SELECTION_PROP, Integer.toString(n));
        }
    }

    private void restoreSelection(PropertyAccess propertyAccess) {
        String string = NAVIGATOR_SELECTION_PROP;
        String string2 = propertyAccess.getProperty(NAVIGATOR_SELECTION_PROP, "-1");
        int n = Integer.parseInt(string2);
        if (n < 0) {
            return;
        }
        SwingUtilities.invokeLater(new 1(this, n));
    }

    static Toolbar ra$_toolbar(DefaultNavigatorWindow defaultNavigatorWindow) {
        return defaultNavigatorWindow._toolbar;
    }

    static void mav$updateActiveNode(DefaultNavigatorWindow defaultNavigatorWindow) {
        defaultNavigatorWindow.updateActiveNode();
    }

    public final class 4
    implements Runnable {
        public void run() {
            Ide.addIdeListener(new CleanUpIdeAdapter(DefaultNavigatorWindow.this));
        }
    }

    private static final class CleanUpIdeAdapter
    extends IdeAdapter {
        private final WeakReference navigatorWindowImplWeakReference;

        public CleanUpIdeAdapter(DefaultNavigatorWindow defaultNavigatorWindow) {
            this.navigatorWindowImplWeakReference = new WeakReference<DefaultNavigatorWindow>(defaultNavigatorWindow);
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
            DefaultNavigatorWindow defaultNavigatorWindow = (DefaultNavigatorWindow)this.navigatorWindowImplWeakReference.get();
            if (DefaultNavigatorWindow.ra$_toolbar(defaultNavigatorWindow) != null) {
                DefaultNavigatorWindow.ra$_toolbar(defaultNavigatorWindow).dispose();
            }
        }
    }

    public class 1NavigatorTreeExplorer
    extends BaseTreeExplorer {
        private final /* synthetic */ boolean v$coalesceObserverUpdates;
        final /* synthetic */ DefaultNavigatorWindow this$0;

        1NavigatorTreeExplorer(DefaultNavigatorWindow defaultNavigatorWindow, View view, boolean bl) {
            this.v$coalesceObserverUpdates = bl;
            this.this$0 = defaultNavigatorWindow;
            this.setOwner(view);
        }

        protected void nodeExpanded(TNode tNode, boolean bl) {
            if (bl) {
                DefaultNavigatorWindow.mav$updateActiveNode(this.this$0);
            }
        }

        protected boolean coalesceObserverUpdates() {
            return this.v$coalesceObserverUpdates;
        }

        protected void initializeContextNode(Context context, TNode[] tNodeArray) {
            context.setNode(this.findNodeInSelection(tNodeArray));
        }

        private Node findNodeInSelection(TNode[] tNodeArray) {
            Element element;
            if (tNodeArray.length == 1 && (element = tNodeArray[0].getData()) instanceof Node) {
                return (Node)element;
            }
            return null;
        }
    }

    public final class 3
    implements ViewSelectionListener {
        public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
            DefaultNavigatorWindow.this.updateSelection();
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ TreeExplorer v$treeExplorer;
        private final /* synthetic */ List v$expandDataList;
        final /* synthetic */ DefaultNavigatorWindow this$0;

        public void run() {
            ExplorerContext.restoreExpansionState(this.v$treeExplorer.getRoot(), this.v$treeExplorer, this.v$expandDataList);
        }

        public 2(DefaultNavigatorWindow defaultNavigatorWindow, TreeExplorer treeExplorer, List list) {
            this.v$expandDataList = list;
            this.v$treeExplorer = treeExplorer;
            this.this$0 = defaultNavigatorWindow;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ int v$selRow;
        final /* synthetic */ DefaultNavigatorWindow this$0;

        public void run() {
            TreeExplorer treeExplorer = this.this$0.getTreeExplorer();
            treeExplorer.getJTree().setSelectionRow(this.v$selRow);
            treeExplorer.getJTree().scrollRowToVisible(this.v$selRow);
            DefaultNavigatorWindow.mav$updateActiveNode(this.this$0);
        }

        public 1(DefaultNavigatorWindow defaultNavigatorWindow, int n) {
            this.v$selRow = n;
            this.this$0 = defaultNavigatorWindow;
        }
    }
}

