/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingUtils;

final class NavigatorController
implements Controller {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction == null) {
            return false;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        Command command = null;
        int n = ideAction.getCommandId();
        if (n == 67) {
            NavigatorWindow navigatorWindow;
            NavigatorManager navigatorManager;
            View view;
            if (context == null || !((view = context.getView()) instanceof NavigatorWindow) || (navigatorManager = (navigatorWindow = (NavigatorWindow)view).getManager()) == null) return true;
            navigatorManager.showView(context);
            return true;
        }
        if (n == 20) {
            TNode[] tNodeArray = ExplorerContext.getTNodes(context);
            ArrayList<Element> arrayList = new ArrayList<Element>();
            if (tNodeArray != null) {
                int n2 = 0;
                while (n2 < tNodeArray.length) {
                    TNode tNode = tNodeArray[n2];
                    Element element = tNode.getData();
                    if (element instanceof Project || element instanceof Workspace) {
                        arrayList.add(element);
                    }
                    ++n2;
                }
            }
            if (arrayList.size() == 0) {
                command = CommandProcessor.createCommand("oracle.ide.cmd.RemoveFromDiskCommand", context);
            } else {
                if (!MessageDialog.optionalConfirm((String)"oracle.ideri.NavigatorController.deleteRemove", (Component)SwingUtils.getMainWindow(), (String)IdeArb.getString(453), (String)IdeArb.getString(454), null)) return true;
                command = CommandProcessor.createCommand("oracle.ide.cmd.RemoveFileCommand", context);
            }
        } else {
            if (n == 51) {
                Project project;
                TNode[] tNodeArray;
                if (context == null || (tNodeArray = ExplorerContext.getTNodes(context)) == null || (project = context.getProject()) == null) return true;
                LinkedList<TNode> linkedList = new LinkedList<TNode>();
                linkedList.addAll(Arrays.asList(tNodeArray));
                URLPath uRLPath = new URLPath();
                ArrayList<Element> arrayList = new ArrayList<Element>(tNodeArray.length);
                while (linkedList.size() > 0) {
                    TNode tNode = (TNode)linkedList.removeFirst();
                    Element element = tNode.getData();
                    arrayList.add(element);
                    if (element instanceof Project) {
                        ContentSet contentSet = ProjectContent.getInstance((Project)element).getAllContents();
                        uRLPath.add(contentSet.getAllRootDirs());
                        continue;
                    }
                    if (element instanceof RelativeDirectoryContextFolder) {
                        RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element;
                        uRLPath.add(relativeDirectoryContextFolder.getRootDirectories());
                        continue;
                    }
                    if (!(element instanceof Locatable)) continue;
                    Locatable locatable = (Locatable)((Object)element);
                    uRLPath.add(URLFileSystem.getParent(locatable.getURL()));
                }
                Iterator iterator = uRLPath.iterator();
                while (iterator.hasNext()) {
                    URL uRL = (URL)iterator.next();
                    VirtualFileSystemHelper.invalidateDirectoryTree(uRL);
                }
                UpdateMessage.fireStructureChanged(project, arrayList);
                return true;
            }
            if (n == 5) {
                try {
                    CommandProcessor.getInstance().undo(null);
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return true;
            }
            if (n == 6) {
                try {
                    CommandProcessor.getInstance().redo(null);
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return true;
            }
        }
        if (command == null) return false;
        try {
            commandProcessor.invoke(command);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public final boolean update(IdeAction ideAction, Context context) {
        int n;
        block22: {
            Displayable displayable;
            boolean bl;
            block23: {
                TNode[] tNodeArray;
                n = ideAction.getCommandId();
                if (n != 20 && n != 47 && n != 21) break block22;
                bl = false;
                displayable = null;
                if (context == null || !this.isViewContext(context.getView()) || ExplorerContext.hasNonSiblingTNodes(context) || (tNodeArray = ExplorerContext.getTNodes(context)) == null || tNodeArray.length <= 0) break block23;
                bl = true;
                Workspaces workspaces = (Workspaces)tNodeArray[0].getAncestor(Workspaces.class);
                int n2 = 0;
                while (n2 < tNodeArray.length) {
                    block25: {
                        block24: {
                            Folder folder;
                            TNode tNode = tNodeArray[n2];
                            if (tNode == null || tNode.isRoot()) break block24;
                            Element element = tNode.getData();
                            if (n == 20 && tNode.isSet(TNodeConstants.IS_NOT_IN_PROJECT)) {
                                bl = false;
                                break;
                            }
                            boolean bl2 = element.getAttributes().isSet(ElementAttributes.DELETEABLE);
                            boolean bl3 = element.getAttributes().isSet(ElementAttributes.ERASEABLE);
                            boolean bl4 = element.getAttributes().isSet(ElementAttributes.REMOVEABLE);
                            if (!(bl2 || bl3 || bl4)) {
                                bl = false;
                                break;
                            }
                            if (element instanceof Node || element instanceof RelativeDirectoryContextFolder) {
                                bl = n == 21 && (bl2 || bl4) ? true : (n == 47 && (bl2 || bl3) ? true : n == 20 && (bl2 || bl3));
                            } else if (n == 21) {
                                bl = false;
                            } else if (n == 47) {
                                bl = false;
                            } else if (bl2) {
                                bl = true;
                            }
                            if (!bl) break;
                            Folder folder2 = null;
                            TNode tNode2 = (TNode)tNode.getParent();
                            if (tNode2 != null) {
                                folder2 = (Folder)tNode2.getAncestor(Folder.class, true);
                            }
                            if (folder2 == null || element == null) break block24;
                            displayable = folder2;
                            if (workspaces != null && (folder = Workspaces.findOwner(element, context)) != null) {
                                displayable = folder;
                            }
                            if (displayable.canRemove(element)) break block25;
                        }
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
            ideAction.setEnabled(bl);
            if (n == 21) {
                String string = !bl || displayable == null ? IdeArb.getString(223) : IdeArb.format(224, displayable.getShortLabel());
                ideAction.putValue("Name", string);
            }
            return true;
        }
        if (n == 51) {
            TNode[] tNodeArray;
            boolean bl = false;
            if (context != null && context.getProject() != null && (tNodeArray = ExplorerContext.getTNodes(context)) != null && tNodeArray.length > 0) {
                bl = tNodeArray[0].getOwner().canRefresh(tNodeArray[0], Project.class);
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (n == 67) {
            Element element;
            Element[] elementArray;
            View view;
            boolean bl = false;
            if (context != null && (view = context.getView()) != null && (elementArray = view.getSelection()) != null && elementArray.length == 1 && (element = elementArray[0]) != null && element.getAttributes().isSet(ElementAttributes.NAVIGABLE)) {
                bl = true;
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (n == 5) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            ideAction.setEnabled(commandProcessor != null ? commandProcessor.canUndo(null) : false);
            ideAction.putValue("Name", IdeArb.format(82, commandProcessor != null ? commandProcessor.getUndoLabel(null) : ""));
            return true;
        }
        if (n == 6) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            ideAction.setEnabled(commandProcessor != null ? commandProcessor.canRedo(null) : false);
            ideAction.putValue("Name", IdeArb.format(85, commandProcessor != null ? commandProcessor.getRedoLabel(null) : ""));
            return true;
        }
        return false;
    }

    private boolean isViewContext(View view) {
        return view instanceof NavigatorWindow;
    }

    NavigatorController() {
    }
}

