/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class NavigatorDockableFactory
implements DockableFactory {
    private final NavigatorManager _navMgr;

    public NavigatorDockableFactory(NavigatorManager navigatorManager) {
        if (navigatorManager == null) {
            throw new IllegalArgumentException();
        }
        this._navMgr = navigatorManager;
    }

    public void install() {
        NavigatorWindow navigatorWindow = this._navMgr.getNavigatorWindow();
        if (navigatorWindow != null) {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.dock(navigatorWindow, this.createDockingParam());
        }
    }

    public Dockable getDockable(ViewId viewId) {
        return this.createView(viewId);
    }

    protected DockingParam createDockingParam() {
        return new DockingParam();
    }

    private Dockable createView(ViewId viewId) {
        DockableView dockableView = null;
        if (this._navMgr.isSystemNavigator(viewId)) {
            dockableView = this._navMgr.getNavigatorWindow();
        } else {
            String string = viewId.getId();
            Context context = DefaultNavigatorWindow.loadContext(string);
            try {
                try {
                    dockableView = this._navMgr.getNewView(context, viewId);
                }
                catch (Exception exception) {}
            }
            finally {
                DefaultNavigatorWindow.clearContext(string);
            }
        }
        return dockableView;
    }
}

